/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.admin.filemanager;

import com.google.common.collect.Sets;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.nifi.toolkit.admin.AbstractAdminTool;
import org.apache.nifi.toolkit.admin.configmigrator.ConfigMigrator;
import org.apache.nifi.toolkit.admin.util.AdminUtil;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManagerTool
extends AbstractAdminTool {
    private static final String DEFAULT_DESCRIPTION = "This tool is used to perform backup, install and restore activities for a NiFi node. ";
    private static final String HELP_ARG = "help";
    private static final String VERBOSE_ARG = "verbose";
    private static final String OPERATION = "operation";
    private static final String NIFI_CURRENT_DIR = "nifiCurrentDir";
    private static final String NIFI_INSTALL_DIR = "nifiInstallDir";
    private static final String NIFI_ROLLBACK_DIR = "nifiRollbackDir";
    private static final String BACKUP_DIR = "backupDir";
    private static final String INSTALL_FILE = "installFile";
    private static final String MOVE_REPOSITORIES = "moveRepositories";
    private static final String OVERWRITE_CONFIGS = "overwriteConfigs";
    private static final String BOOTSTRAP_CONF = "bootstrapConf";
    private boolean moveRepositories;
    private static final String SUPPORTED_MINIMUM_VERSION = "1.0.0";
    private static final List<PosixFilePermission> POSIX_PERMISSIONS;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public FileManagerTool() {
        boolean bl;
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        this.moveRepositories = bl = false;
        Object object = callSiteArray[0].callCurrent((GroovyObject)this, (Object)DEFAULT_DESCRIPTION);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, FileManagerTool.class, (GroovyObject)this, (String)"header");
        callSiteArray[1].callCurrent((GroovyObject)this);
    }

    @Override
    protected Logger getLogger() {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        return (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(LoggerFactory.class, FileManagerTool.class), Logger.class);
    }

    @Override
    protected Options getOptions() {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        Options options = (Options)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(Options.class), Options.class);
        callSiteArray[4].call((Object)options, callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call(Option.class, (Object)"o"), (Object)OPERATION)), (Object)"File operation (install | backup | restore)")));
        callSiteArray[10].call((Object)options, callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call(callSiteArray[15].call(Option.class, (Object)"b"), (Object)BACKUP_DIR)), (Object)"Backup NiFi Directory (used with backup or restore operation)")));
        callSiteArray[16].call((Object)options, callSiteArray[17].call(callSiteArray[18].call(callSiteArray[19].call(callSiteArray[20].call(callSiteArray[21].call(Option.class, (Object)"c"), (Object)NIFI_CURRENT_DIR)), (Object)"Current NiFi Installation Directory (used optionally with install or restore operation)")));
        callSiteArray[22].call((Object)options, callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].call(callSiteArray[26].call(callSiteArray[27].call(Option.class, (Object)"d"), (Object)NIFI_INSTALL_DIR)), (Object)"NiFi Installation Directory (used with install or restore operation)")));
        callSiteArray[28].call((Object)options, callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].call(callSiteArray[32].call(callSiteArray[33].call(Option.class, (Object)"i"), (Object)INSTALL_FILE)), (Object)"NiFi Install File")));
        callSiteArray[34].call((Object)options, callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].call(callSiteArray[38].call(callSiteArray[39].call(Option.class, (Object)"r"), (Object)NIFI_ROLLBACK_DIR)), (Object)"NiFi Installation Directory (used with install or restore operation)")));
        callSiteArray[40].call((Object)options, callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].call(Option.class, (Object)"t"), (Object)BOOTSTRAP_CONF)), (Object)"Current NiFi Bootstrap Configuration File (optional)")));
        callSiteArray[46].call((Object)options, callSiteArray[47].call(callSiteArray[48].call(callSiteArray[49].call(callSiteArray[50].call(Option.class, (Object)"m"), (Object)MOVE_REPOSITORIES), (Object)"Allow repositories to be moved to new/restored nifi directory from existing installation, if available (used optionally with install or restore operation)")));
        callSiteArray[51].call((Object)options, callSiteArray[52].call(callSiteArray[53].call(callSiteArray[54].call(callSiteArray[55].call(Option.class, (Object)"x"), (Object)OVERWRITE_CONFIGS), (Object)"Overwrite existing configuration directory with upgrade changes (used optionally with install or restore operation)")));
        callSiteArray[56].call((Object)options, callSiteArray[57].call(callSiteArray[58].call(callSiteArray[59].call(callSiteArray[60].call(Option.class, (Object)"h"), (Object)HELP_ARG), (Object)"Print help info (optional)")));
        callSiteArray[61].call((Object)options, callSiteArray[62].call(callSiteArray[63].call(callSiteArray[64].call(callSiteArray[65].call(Option.class, (Object)"v"), (Object)VERBOSE_ARG), (Object)"Set mode to verbose (optional, default is false)")));
        return options;
    }

    public Set<PosixFilePermission> fromMode(long mode) {
        Reference mode2 = new Reference((Object)mode);
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        Reference permissions = new Reference((Object)((Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[66].call(Sets.class), Set.class)));
        public final class _fromMode_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference mode;
            private /* synthetic */ Reference permissions;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _fromMode_closure1(Object _outerInstance, Object _thisObject, Reference mode, Reference permissions) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _fromMode_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.mode = reference2 = mode;
                this.permissions = reference = permissions;
            }

            public Object doCall(Object perm, Object index) {
                CallSite[] callSiteArray = _fromMode_closure1.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].call(this.mode.get(), callSiteArray[1].call((Object)1, index)), (Object)0)) {
                    return callSiteArray[2].call(this.permissions.get(), perm);
                }
                return null;
            }

            @Generated
            public Object call(Object perm, Object index) {
                CallSite[] callSiteArray = _fromMode_closure1.$getCallSiteArray();
                return callSiteArray[3].callCurrent((GroovyObject)this, perm, index);
            }

            @Generated
            public long getMode() {
                CallSite[] callSiteArray = _fromMode_closure1.$getCallSiteArray();
                return DefaultTypeTransformation.longUnbox((Object)this.mode.get());
            }

            @Generated
            public Set getPermissions() {
                CallSite[] callSiteArray = _fromMode_closure1.$getCallSiteArray();
                return (Set)ScriptBytecodeAdapter.castToType((Object)this.permissions.get(), Set.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fromMode_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "and";
                stringArray[1] = "leftShift";
                stringArray[2] = "add";
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _fromMode_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_fromMode_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _fromMode_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[67].call(POSIX_PERMISSIONS, (Object)new _fromMode_closure1(this, this, mode2, permissions));
        return (Set)permissions.get();
    }

    public Properties getProperties(Path confFileName) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        Properties properties = (Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].callConstructor(Properties.class), Properties.class);
        File confFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].call((Object)confFileName), File.class);
        callSiteArray[70].call((Object)properties, callSiteArray[71].callConstructor(FileInputStream.class, (Object)confFile));
        return properties;
    }

    public boolean valid(File nifiDir) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[72].call((Object)nifiDir)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[73].call(Files.class, callSiteArray[74].call(Paths.class, callSiteArray[75].callGetProperty((Object)nifiDir), (Object)"bin", (Object)"nifi.sh")));
    }

    public void move(String srcDir, String oldDir, String newDir) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        String oldPathName = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[76].call((Object)srcDir, (Object)"./")) ? callSiteArray[77].call(callSiteArray[78].call((Object)oldDir, callSiteArray[79].callGetProperty(File.class)), callSiteArray[80].call((Object)srcDir, (Object)ScriptBytecodeAdapter.createRange((Object)2, (Object)-1, (boolean)true))) : callSiteArray[81].call(callSiteArray[82].call((Object)oldDir, callSiteArray[83].callGetProperty(File.class)), (Object)srcDir)));
        String newPathName = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[84].call((Object)srcDir, (Object)"./")) ? callSiteArray[85].call(callSiteArray[86].call((Object)newDir, callSiteArray[87].callGetProperty(File.class)), callSiteArray[88].call((Object)srcDir, (Object)ScriptBytecodeAdapter.createRange((Object)2, (Object)-1, (boolean)true))) : callSiteArray[89].call(callSiteArray[90].call((Object)newDir, callSiteArray[91].callGetProperty(File.class)), (Object)srcDir)));
        Path oldPath = (Path)ScriptBytecodeAdapter.castToType((Object)callSiteArray[92].call(Paths.class, (Object)oldPathName), Path.class);
        Path newPath = (Path)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].call(Paths.class, (Object)newPathName), Path.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[94].call(Files.class, (Object)oldPath))) {
            callSiteArray[95].call(Files.class, (Object)oldPath, (Object)newPath);
        }
    }

    public void moveRepository(String dirName, String installDirName) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[96].callGroovyObjectGetProperty((Object)this))) {
            callSiteArray[97].call(callSiteArray[98].callGroovyObjectGetProperty((Object)this), (Object)"Moving repositories from {} to {}. Please note that repositories may be upgraded during install and become incompatible with a previous version. ", (Object)dirName, (Object)installDirName);
        }
        String bootstrapConfFileName = ShortTypeHandling.castToString((Object)callSiteArray[99].call(callSiteArray[100].call(callSiteArray[101].call(callSiteArray[102].call((Object)dirName, callSiteArray[103].callGetProperty(File.class)), (Object)"conf"), callSiteArray[104].callGetProperty(File.class)), (Object)"bootstrap.conf"));
        Properties bootstrapProperties = (Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].callCurrent((GroovyObject)this, callSiteArray[106].call(Paths.class, (Object)bootstrapConfFileName)), Properties.class);
        String nifiPropertiesFile = ShortTypeHandling.castToString((Object)callSiteArray[107].call(callSiteArray[108].call(callSiteArray[109].call(AdminUtil.class, callSiteArray[110].call((Object)bootstrapProperties, (Object)"conf.dir"), (Object)dirName), callSiteArray[111].callGetProperty(File.class)), (Object)"nifi.properties"));
        Properties nifiProperties = (Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[112].callCurrent((GroovyObject)this, callSiteArray[113].call(Paths.class, (Object)nifiPropertiesFile)), Properties.class);
        String flowFileDirectory = ShortTypeHandling.castToString((Object)callSiteArray[114].call((Object)nifiProperties, (Object)"nifi.flowfile.repository.directory"));
        String contentRepositoryDir = ShortTypeHandling.castToString((Object)callSiteArray[115].call((Object)nifiProperties, (Object)"nifi.content.repository.directory.default"));
        String provenanceRepositoryDir = ShortTypeHandling.castToString((Object)callSiteArray[116].call((Object)nifiProperties, (Object)"nifi.provenance.repository.directory.default"));
        String databaseDirectory = ShortTypeHandling.castToString((Object)callSiteArray[117].call((Object)nifiProperties, (Object)"nifi.database.directory"));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[118].call((Object)flowFileDirectory, (Object)"./"))) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[119].callGroovyObjectGetProperty((Object)this))) {
                callSiteArray[120].call(callSiteArray[121].callGroovyObjectGetProperty((Object)this), (Object)"Moving flowfile repo");
            }
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[122].callCurrent((GroovyObject)this, (Object)flowFileDirectory, (Object)dirName, (Object)installDirName);
            } else {
                this.move(flowFileDirectory, dirName, installDirName);
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[123].call((Object)contentRepositoryDir, (Object)"./"))) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[124].callGroovyObjectGetProperty((Object)this))) {
                callSiteArray[125].call(callSiteArray[126].callGroovyObjectGetProperty((Object)this), (Object)"Moving content repo");
            }
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[127].callCurrent((GroovyObject)this, (Object)contentRepositoryDir, (Object)dirName, (Object)installDirName);
            } else {
                this.move(contentRepositoryDir, dirName, installDirName);
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[128].call((Object)provenanceRepositoryDir, (Object)"./"))) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[129].callGroovyObjectGetProperty((Object)this))) {
                callSiteArray[130].call(callSiteArray[131].callGroovyObjectGetProperty((Object)this), (Object)"Moving provenance repo");
            }
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[132].callCurrent((GroovyObject)this, (Object)provenanceRepositoryDir, (Object)dirName, (Object)installDirName);
            } else {
                this.move(provenanceRepositoryDir, dirName, installDirName);
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[133].call((Object)databaseDirectory, (Object)"./"))) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[134].callGroovyObjectGetProperty((Object)this))) {
                callSiteArray[135].call(callSiteArray[136].callGroovyObjectGetProperty((Object)this), (Object)"Moving database repo");
            }
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[137].callCurrent((GroovyObject)this, (Object)databaseDirectory, (Object)dirName, (Object)installDirName);
            } else {
                this.move(databaseDirectory, dirName, installDirName);
            }
        }
    }

    public void copyState(String currentNiFiDirName, String installDirName) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        File stateDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[138].call(callSiteArray[139].call(Paths.class, (Object)currentNiFiDirName, (Object)"state")), File.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[140].call((Object)stateDir))) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[141].call(Files.class, callSiteArray[142].call(Paths.class, (Object)installDirName, (Object)"state")))) {
                callSiteArray[143].call(Files.class, callSiteArray[144].call(Paths.class, (Object)installDirName, (Object)"state"));
            }
            callSiteArray[145].call(FileUtils.class, (Object)stateDir, callSiteArray[146].call(callSiteArray[147].call(Paths.class, (Object)installDirName)));
        }
    }

    protected void setPosixPermissions(ArchiveEntry entry, File outputFile, ZipFile zipFile) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        int mode = 0;
        if (entry instanceof TarArchiveEntry) {
            Object object = callSiteArray[148].call((Object)((TarArchiveEntry)ScriptBytecodeAdapter.castToType((Object)entry, TarArchiveEntry.class)));
            mode = DefaultTypeTransformation.intUnbox((Object)object);
        } else if (entry instanceof ZipArchiveEntry && ScriptBytecodeAdapter.compareNotEqual((Object)zipFile, null)) {
            Object object = callSiteArray[149].call(callSiteArray[150].call((Object)zipFile, callSiteArray[151].callGetProperty((Object)entry)));
            mode = DefaultTypeTransformation.intUnbox((Object)object);
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (mode == 0) {
                Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[152].call((Object)outputFile)) ? callSiteArray[153].callGetProperty(TarArchiveEntry.class) : callSiteArray[154].callGetProperty(TarArchiveEntry.class);
                mode = DefaultTypeTransformation.intUnbox((Object)object);
            }
        } else if (mode == 0) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[155].call((Object)outputFile)) ? callSiteArray[156].callGetProperty(TarArchiveEntry.class) : callSiteArray[157].callGetProperty(TarArchiveEntry.class);
            mode = DefaultTypeTransformation.intUnbox((Object)object);
        }
        Set permissions = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[158].callCurrent((GroovyObject)this, (Object)mode), Set.class);
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[159].call((Object)permissions), (Object)0)) {
            callSiteArray[160].call(Files.class, callSiteArray[161].call((Object)outputFile), callSiteArray[162].callCurrent((GroovyObject)this, (Object)mode));
        }
    }

    protected void setPosixPermissions(File file, List<PosixFilePermission> permissions) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[163].callGetProperty(SystemUtils.class))) {
            callSiteArray[164].callSafe((Object)file, callSiteArray[165].call(permissions, callSiteArray[166].callGetProperty(PosixFilePermission.class)));
            callSiteArray[167].callSafe((Object)file, callSiteArray[168].call(permissions, callSiteArray[169].callGetProperty(PosixFilePermission.class)));
            callSiteArray[170].callSafe((Object)file, callSiteArray[171].call(permissions, callSiteArray[172].callGetProperty(PosixFilePermission.class)));
        } else {
            callSiteArray[173].call(Files.class, callSiteArray[174].callSafe((Object)file), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Set)ScriptBytecodeAdapter.asType(permissions, Set.class)), Set.class));
        }
    }

    public void backup(String backupNiFiDirName, String currentNiFiDirName, String bootstrapConfFileName) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[175].callGroovyObjectGetProperty((Object)this))) {
            callSiteArray[176].call(callSiteArray[177].callGroovyObjectGetProperty((Object)this), (Object)"Creating backup in directory {}. Please note that repositories are not included in backup operation.", (Object)backupNiFiDirName);
        }
        File backupNiFiDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[178].callConstructor(File.class, (Object)backupNiFiDirName), File.class);
        Properties bootstrapProperties = (Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[179].callCurrent((GroovyObject)this, callSiteArray[180].call(Paths.class, (Object)bootstrapConfFileName)), Properties.class);
        File confDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[181].callConstructor(File.class, callSiteArray[182].call(AdminUtil.class, callSiteArray[183].call((Object)bootstrapProperties, (Object)"conf.dir"), (Object)currentNiFiDirName)), File.class);
        File libDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[184].callConstructor(File.class, callSiteArray[185].call(AdminUtil.class, callSiteArray[186].call((Object)bootstrapProperties, (Object)"lib.dir"), (Object)currentNiFiDirName)), File.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[187].call((Object)backupNiFiDir)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[188].call((Object)backupNiFiDir))) {
            callSiteArray[189].call((Object)backupNiFiDir);
        }
        callSiteArray[190].call((Object)backupNiFiDir);
        callSiteArray[191].call(Files.class, callSiteArray[192].call(Paths.class, (Object)backupNiFiDirName, (Object)"bootstrap_files"));
        callSiteArray[193].call(FileUtils.class, callSiteArray[194].call(callSiteArray[195].call(Paths.class, (Object)bootstrapConfFileName)), callSiteArray[196].call(callSiteArray[197].call(Paths.class, (Object)backupNiFiDirName, (Object)"bootstrap_files")));
        callSiteArray[198].call(FileUtils.class, callSiteArray[199].call(callSiteArray[200].call(Paths.class, (Object)currentNiFiDirName, (Object)"lib", (Object)"bootstrap")), callSiteArray[201].call(callSiteArray[202].call(Paths.class, (Object)backupNiFiDirName, (Object)"bootstrap_files")));
        callSiteArray[203].call(Files.class, callSiteArray[204].call(Paths.class, (Object)backupNiFiDirName, (Object)"conf"));
        callSiteArray[205].call(Files.class, callSiteArray[206].call(Paths.class, (Object)backupNiFiDirName, (Object)"lib"));
        callSiteArray[207].call(FileUtils.class, (Object)confDir, callSiteArray[208].call(callSiteArray[209].call(Paths.class, (Object)backupNiFiDirName)));
        callSiteArray[210].call(FileUtils.class, (Object)libDir, callSiteArray[211].call(callSiteArray[212].call(Paths.class, (Object)backupNiFiDirName)));
        callSiteArray[213].call(FileUtils.class, callSiteArray[214].call(callSiteArray[215].call(Paths.class, (Object)currentNiFiDirName, (Object)"bin")), callSiteArray[216].callConstructor(File.class, (Object)backupNiFiDirName));
        callSiteArray[217].call(FileUtils.class, callSiteArray[218].call(callSiteArray[219].call(Paths.class, (Object)currentNiFiDirName, (Object)"docs")), callSiteArray[220].callConstructor(File.class, (Object)backupNiFiDirName));
        callSiteArray[221].call(FileUtils.class, callSiteArray[222].call(callSiteArray[223].call(Paths.class, (Object)currentNiFiDirName, (Object)"LICENSE")), callSiteArray[224].callConstructor(File.class, (Object)backupNiFiDirName));
        callSiteArray[225].call(FileUtils.class, callSiteArray[226].call(callSiteArray[227].call(Paths.class, (Object)currentNiFiDirName, (Object)"NOTICE")), callSiteArray[228].callConstructor(File.class, (Object)backupNiFiDirName));
        callSiteArray[229].call(FileUtils.class, callSiteArray[230].call(callSiteArray[231].call(Paths.class, (Object)currentNiFiDirName, (Object)"README")), callSiteArray[232].callConstructor(File.class, (Object)backupNiFiDirName));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[233].callGroovyObjectGetProperty((Object)this))) {
            callSiteArray[234].call(callSiteArray[235].callGroovyObjectGetProperty((Object)this), (Object)"Backup Complete");
        }
    }

    public void restore(String backupNiFiDirName, String rollbackNiFiDirName, String currentNiFiDirName, String bootstrapConfFileName) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[236].callGroovyObjectGetProperty((Object)this))) {
            callSiteArray[237].call(callSiteArray[238].callGroovyObjectGetProperty((Object)this), callSiteArray[239].call((Object)"Restoring to directory:", (Object)rollbackNiFiDirName));
        }
        File rollbackNiFiDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[240].callConstructor(File.class, (Object)rollbackNiFiDirName), File.class);
        File rollbackNiFiLibDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[241].call(callSiteArray[242].call(Paths.class, (Object)rollbackNiFiDirName, (Object)"lib")), File.class);
        File rollbackNiFiConfDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[243].call(callSiteArray[244].call(Paths.class, (Object)rollbackNiFiDirName, (Object)"conf")), File.class);
        Properties bootstrapProperties = (Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[245].callCurrent((GroovyObject)this, callSiteArray[246].call(Paths.class, (Object)backupNiFiDirName, (Object)"bootstrap_files", (Object)"bootstrap.conf")), Properties.class);
        File confDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[247].callConstructor(File.class, callSiteArray[248].call(AdminUtil.class, callSiteArray[249].call((Object)bootstrapProperties, (Object)"conf.dir"), (Object)rollbackNiFiDirName)), File.class);
        File libDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[250].callConstructor(File.class, callSiteArray[251].call(AdminUtil.class, callSiteArray[252].call((Object)bootstrapProperties, (Object)"lib.dir"), (Object)rollbackNiFiDirName)), File.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[253].call((Object)rollbackNiFiDir))) {
            callSiteArray[254].call((Object)rollbackNiFiDir);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[255].call((Object)rollbackNiFiLibDir))) {
            callSiteArray[256].call((Object)rollbackNiFiLibDir);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[257].call((Object)rollbackNiFiConfDir))) {
            callSiteArray[258].call((Object)rollbackNiFiConfDir);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[259].call((Object)libDir))) {
            callSiteArray[260].call((Object)libDir);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[261].call((Object)confDir))) {
            callSiteArray[262].call((Object)confDir);
        }
        callSiteArray[263].call(FileUtils.class, callSiteArray[264].call(callSiteArray[265].call(Paths.class, (Object)backupNiFiDirName, (Object)"bootstrap_files", (Object)"bootstrap.conf")), callSiteArray[266].callConstructor(File.class, (Object)bootstrapConfFileName));
        callSiteArray[267].call(FileUtils.class, callSiteArray[268].call(callSiteArray[269].call(Paths.class, (Object)backupNiFiDirName, (Object)"bootstrap_files", (Object)"bootstrap")), callSiteArray[270].call(callSiteArray[271].call(Paths.class, (Object)rollbackNiFiDirName, (Object)"lib")));
        callSiteArray[272].call(FileUtils.class, callSiteArray[273].call(callSiteArray[274].call(Paths.class, (Object)backupNiFiDirName, (Object)"bin")), callSiteArray[275].callConstructor(File.class, (Object)rollbackNiFiDirName));
        callSiteArray[276].call(FileUtils.class, callSiteArray[277].call(callSiteArray[278].call(Paths.class, (Object)backupNiFiDirName, (Object)"docs")), callSiteArray[279].callConstructor(File.class, (Object)rollbackNiFiDirName));
        callSiteArray[280].call(FileUtils.class, callSiteArray[281].call(callSiteArray[282].call(Paths.class, (Object)backupNiFiDirName, (Object)"lib")), (Object)libDir);
        callSiteArray[283].call(FileUtils.class, callSiteArray[284].call(callSiteArray[285].call(Paths.class, (Object)backupNiFiDirName, (Object)"conf")), (Object)confDir);
        callSiteArray[286].call(FileUtils.class, callSiteArray[287].call(callSiteArray[288].call(Paths.class, (Object)backupNiFiDirName, (Object)"LICENSE")), callSiteArray[289].callConstructor(File.class, (Object)rollbackNiFiDirName));
        callSiteArray[290].call(FileUtils.class, callSiteArray[291].call(callSiteArray[292].call(Paths.class, (Object)backupNiFiDirName, (Object)"NOTICE")), callSiteArray[293].callConstructor(File.class, (Object)rollbackNiFiDirName));
        callSiteArray[294].call(FileUtils.class, callSiteArray[295].call(callSiteArray[296].call(Paths.class, (Object)backupNiFiDirName, (Object)"README")), callSiteArray[297].callConstructor(File.class, (Object)rollbackNiFiDirName));
        File binDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[298].call(callSiteArray[299].call(Paths.class, (Object)rollbackNiFiDirName, (Object)"bin")), File.class);
        public final class _restore_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _restore_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _restore_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _restore_closure2.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, it, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[1].callGetProperty(PosixFilePermission.class), callSiteArray[2].callGetProperty(PosixFilePermission.class), callSiteArray[3].callGetProperty(PosixFilePermission.class), callSiteArray[4].callGetProperty(PosixFilePermission.class), callSiteArray[5].callGetProperty(PosixFilePermission.class), callSiteArray[6].callGetProperty(PosixFilePermission.class), callSiteArray[7].callGetProperty(PosixFilePermission.class)}));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _restore_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _restore_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "setPosixPermissions";
                stringArray[1] = "OWNER_READ";
                stringArray[2] = "OWNER_WRITE";
                stringArray[3] = "OWNER_EXECUTE";
                stringArray[4] = "GROUP_READ";
                stringArray[5] = "GROUP_EXECUTE";
                stringArray[6] = "OTHERS_READ";
                stringArray[7] = "OTHERS_EXECUTE";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _restore_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_restore_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _restore_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[300].call(callSiteArray[301].call((Object)binDir), (Object)new _restore_closure2(this, this));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)currentNiFiDirName) && this.moveRepositories) {
                callSiteArray[302].callCurrent((GroovyObject)this, (Object)currentNiFiDirName, (Object)rollbackNiFiDirName);
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)currentNiFiDirName) && this.moveRepositories) {
            this.moveRepository(currentNiFiDirName, rollbackNiFiDirName);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[303].callGroovyObjectGetProperty((Object)this))) {
            callSiteArray[304].call(callSiteArray[305].callGroovyObjectGetProperty((Object)this), (Object)"Restore Completed.");
        }
    }

    public String extract(File installFile, File installDirName) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[306].callGroovyObjectGetProperty((Object)this))) {
            callSiteArray[307].call(callSiteArray[308].callGroovyObjectGetProperty((Object)this), (Object)"Beginning extraction using {} into installation directory {}", callSiteArray[309].callGetProperty((Object)installFile), callSiteArray[310].callGetProperty((Object)installDirName));
        }
        String extension = ShortTypeHandling.castToString((Object)callSiteArray[311].call(FilenameUtils.class, callSiteArray[312].call((Object)installFile)));
        InputStream fis = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[313].call((Object)extension, (Object)"gz")) ? (InputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[314].callConstructor(GzipCompressorInputStream.class, callSiteArray[315].callConstructor(FileInputStream.class, (Object)installFile)), InputStream.class) : (InputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[316].callConstructor(FileInputStream.class, (Object)installFile), InputStream.class);
        ArchiveInputStream inputStream = (ArchiveInputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[317].call(callSiteArray[318].callConstructor(ArchiveStreamFactory.class), callSiteArray[319].callConstructor(BufferedInputStream.class, (Object)fis)), ArchiveInputStream.class);
        ZipFile zipFile = (ZipFile)ScriptBytecodeAdapter.castToType(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[320].call((Object)extension, (Object)"zip")) ? callSiteArray[321].callConstructor(ZipFile.class, (Object)installFile) : null, ZipFile.class);
        ArchiveEntry entry = (ArchiveEntry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[322].callGetProperty((Object)inputStream), ArchiveEntry.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)entry, null)) {
            String archiveRootDir = null;
            while (ScriptBytecodeAdapter.compareNotEqual((Object)entry, null)) {
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[323].call((Object)ScriptBytecodeAdapter.compareEqual(archiveRootDir, null), callSiteArray[324].call(callSiteArray[325].call(callSiteArray[326].callGetProperty((Object)entry)), (Object)"nifi")))) {
                    Object object = ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[327].call(callSiteArray[328].callGetProperty((Object)entry), callSiteArray[329].callGetProperty(File.class)), (Object)-1) ? callSiteArray[330].call(callSiteArray[331].callGetProperty((Object)entry), (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)callSiteArray[332].call(callSiteArray[333].call(callSiteArray[334].callGetProperty((Object)entry), callSiteArray[335].callGetProperty(File.class)), (Object)1), (boolean)true)) : callSiteArray[336].callGetProperty((Object)entry);
                    archiveRootDir = ShortTypeHandling.castToString((Object)object);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[337].callGroovyObjectGetProperty((Object)this))) {
                        callSiteArray[338].call(callSiteArray[339].callGroovyObjectGetProperty((Object)this), (Object)"Upgrade root directory: {}", (Object)archiveRootDir);
                    }
                    File archiveRootDirFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[340].call(callSiteArray[341].call(Paths.class, callSiteArray[342].call((Object)installDirName), (Object)archiveRootDir)), File.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[343].call((Object)archiveRootDirFile))) {
                        callSiteArray[344].call((Object)archiveRootDirFile);
                    }
                    callSiteArray[345].call((Object)archiveRootDirFile);
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[346].callGroovyObjectGetProperty((Object)this))) {
                    callSiteArray[347].call(callSiteArray[348].callGroovyObjectGetProperty((Object)this), (Object)"Extracting file: {} ", callSiteArray[349].callGetProperty((Object)entry));
                }
                if (DefaultTypeTransformation.booleanUnbox(archiveRootDir) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[350].call(callSiteArray[351].callGetProperty((Object)entry), archiveRootDir))) {
                    File outputFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[352].call(callSiteArray[353].call(Paths.class, callSiteArray[354].call((Object)installDirName), callSiteArray[355].callGetProperty((Object)entry))), File.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[356].call((Object)entry))) {
                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[357].call((Object)outputFile)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[358].call((Object)outputFile))) {
                            throw (Throwable)callSiteArray[359].callConstructor(IllegalStateException.class, callSiteArray[360].call((Object)"Could not create directory :", callSiteArray[361].call((Object)outputFile)));
                        }
                    } else {
                        File parentDirectory = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[362].call((Object)outputFile), File.class);
                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[363].call((Object)parentDirectory))) {
                            callSiteArray[364].call((Object)parentDirectory);
                        }
                        OutputStream outputFileStream = (OutputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[365].callConstructor(FileOutputStream.class, (Object)outputFile), OutputStream.class);
                        callSiteArray[366].call(IOUtils.class, (Object)inputStream, (Object)outputFileStream);
                        callSiteArray[367].call((Object)outputFileStream);
                    }
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[368].callGetProperty(SystemUtils.class))) {
                        callSiteArray[369].callCurrent((GroovyObject)this, (Object)entry, (Object)outputFile, (Object)zipFile);
                    }
                }
                Object object = callSiteArray[370].callGetProperty((Object)inputStream);
                entry = (ArchiveEntry)ScriptBytecodeAdapter.castToType((Object)object, ArchiveEntry.class);
            }
            return archiveRootDir;
        }
        throw (Throwable)callSiteArray[371].callConstructor(RuntimeException.class, callSiteArray[372].call((Object)"Attempting to extract installation file however it is empty: ", callSiteArray[373].call((Object)installFile)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void install(String installFileName, String installDirName, String currentNiFiDirName, String bootstrapConfFileName, Boolean overwriteConfigs) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        File installFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[374].callConstructor(File.class, (Object)installFileName), File.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[375].callGroovyObjectGetProperty((Object)this))) {
            callSiteArray[376].call(callSiteArray[377].callGroovyObjectGetProperty((Object)this), callSiteArray[378].call((Object)"Beginning installation into directory:", (Object)installDirName));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[379].call((Object)installFile))) throw (Throwable)callSiteArray[396].callConstructor(RuntimeException.class, (Object)"Installation file provided does not exist");
        File installDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[380].callConstructor(File.class, (Object)installDirName), File.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[381].call((Object)installDir))) {
            callSiteArray[382].call((Object)installDir);
        }
        String installRootDirName = ShortTypeHandling.castToString((Object)callSiteArray[383].callCurrent((GroovyObject)this, (Object)installFile, (Object)installDir));
        File installRootDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[384].call(callSiteArray[385].call(Paths.class, (Object)installDirName, (Object)installRootDirName)), File.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[386].callCurrent((GroovyObject)this, (Object)installRootDir))) throw (Throwable)callSiteArray[395].callConstructor(RuntimeException.class, (Object)"Extract failed: Invalid NiFi Installation. Check the install path provided and retry.");
        if (DefaultTypeTransformation.booleanUnbox((Object)currentNiFiDirName) && DefaultTypeTransformation.booleanUnbox((Object)bootstrapConfFileName)) {
            callSiteArray[387].callCurrent((GroovyObject)this, (Object)currentNiFiDirName, callSiteArray[388].callGetProperty((Object)installRootDir));
            if (this.moveRepositories) {
                callSiteArray[389].callCurrent((GroovyObject)this, (Object)currentNiFiDirName, callSiteArray[390].callGetProperty((Object)installRootDir));
            }
            ConfigMigrator configMigrator = (ConfigMigrator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[391].callConstructor(ConfigMigrator.class, callSiteArray[392].callGroovyObjectGetProperty((Object)this), (Object)overwriteConfigs), ConfigMigrator.class);
            callSiteArray[393].call((Object)configMigrator, (Object)currentNiFiDirName, (Object)bootstrapConfFileName, callSiteArray[394].callGetProperty((Object)installRootDir));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[397].callGroovyObjectGetProperty((Object)this))) return;
        callSiteArray[398].call(callSiteArray[399].callGroovyObjectGetProperty((Object)this), (Object)"Installation Complete");
    }

    public void parseInstall(CommandLine commandLine) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[400].call((Object)commandLine, (Object)MOVE_REPOSITORIES))) {
            boolean bl;
            this.moveRepositories = bl = true;
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[401].call((Object)commandLine, (Object)INSTALL_FILE))) {
                throw (Throwable)callSiteArray[402].callConstructor(ParseException.class, (Object)"Missing -i option");
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[403].call((Object)commandLine, (Object)NIFI_INSTALL_DIR))) {
                throw (Throwable)callSiteArray[404].callConstructor(ParseException.class, (Object)"Missing -d option");
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[405].call((Object)commandLine, (Object)NIFI_CURRENT_DIR)) && this.moveRepositories) {
                throw (Throwable)callSiteArray[406].callConstructor(ParseException.class, (Object)"Missing -c option: Moving repositories requires current nifi directory");
            }
        } else {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[407].call((Object)commandLine, (Object)INSTALL_FILE))) {
                throw (Throwable)callSiteArray[408].callConstructor(ParseException.class, (Object)"Missing -i option");
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[409].call((Object)commandLine, (Object)NIFI_INSTALL_DIR))) {
                throw (Throwable)callSiteArray[410].callConstructor(ParseException.class, (Object)"Missing -d option");
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[411].call((Object)commandLine, (Object)NIFI_CURRENT_DIR)) && this.moveRepositories) {
                throw (Throwable)callSiteArray[412].callConstructor(ParseException.class, (Object)"Missing -c option: Moving repositories requires current nifi directory");
            }
        }
        String installFileName = ShortTypeHandling.castToString((Object)callSiteArray[413].call((Object)commandLine, (Object)INSTALL_FILE));
        String nifiCurrentDirName = ShortTypeHandling.castToString((Object)callSiteArray[414].call((Object)commandLine, (Object)NIFI_CURRENT_DIR));
        String nifiInstallDirName = ShortTypeHandling.castToString((Object)callSiteArray[415].call((Object)commandLine, (Object)NIFI_INSTALL_DIR));
        Boolean overwriteConfigs = (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[416].call((Object)commandLine, (Object)OVERWRITE_CONFIGS), Boolean.class);
        String bootstrapConfFileName = ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[417].call((Object)commandLine, (Object)BOOTSTRAP_CONF)) ? callSiteArray[418].call((Object)commandLine, (Object)BOOTSTRAP_CONF) : (DefaultTypeTransformation.booleanUnbox((Object)nifiCurrentDirName) ? callSiteArray[419].call(callSiteArray[420].call(Paths.class, (Object)nifiCurrentDirName, (Object)"conf", (Object)"bootstrap.conf")) : null));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[421].call(Files.class, callSiteArray[422].call(Paths.class, (Object)installFileName)))) {
            throw (Throwable)callSiteArray[423].callConstructor(ParseException.class, callSiteArray[424].call((Object)"Missing installation file: ", (Object)installFileName));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)nifiCurrentDirName) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[425].call(Files.class, callSiteArray[426].call(Paths.class, (Object)nifiCurrentDirName)))) {
            throw (Throwable)callSiteArray[427].callConstructor(ParseException.class, callSiteArray[428].call((Object)"Current NiFi installation path does not exist: ", (Object)nifiCurrentDirName));
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)nifiCurrentDirName) && DefaultTypeTransformation.booleanUnbox((Object)bootstrapConfFileName) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[429].callCurrent((GroovyObject)this, (Object)nifiCurrentDirName, (Object)bootstrapConfFileName, (Object)SUPPORTED_MINIMUM_VERSION))) {
                throw (Throwable)callSiteArray[430].callConstructor(UnsupportedOperationException.class, (Object)"File Manager Tool only supports NiFi versions 1.0.0 or higher.");
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)nifiCurrentDirName) && DefaultTypeTransformation.booleanUnbox((Object)bootstrapConfFileName) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[431].callCurrent((GroovyObject)this, (Object)nifiCurrentDirName, (Object)bootstrapConfFileName, (Object)SUPPORTED_MINIMUM_VERSION))) {
            throw (Throwable)callSiteArray[432].callConstructor(UnsupportedOperationException.class, (Object)"File Manager Tool only supports NiFi versions 1.0.0 or higher.");
        }
        callSiteArray[433].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)installFileName, (Object)nifiInstallDirName, !DefaultTypeTransformation.booleanUnbox((Object)nifiCurrentDirName) ? null : callSiteArray[434].call(callSiteArray[435].call(callSiteArray[436].call(Paths.class, (Object)nifiCurrentDirName))), (Object)bootstrapConfFileName, (Object)overwriteConfigs));
    }

    public void parseBackup(CommandLine commandLine) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[437].call((Object)commandLine, (Object)BACKUP_DIR))) {
            throw (Throwable)callSiteArray[438].callConstructor(ParseException.class, (Object)"Missing -b option");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[439].call((Object)commandLine, (Object)NIFI_CURRENT_DIR))) {
            throw (Throwable)callSiteArray[440].callConstructor(ParseException.class, (Object)"Missing -c option");
        }
        String backupDirName = ShortTypeHandling.castToString((Object)callSiteArray[441].call((Object)commandLine, (Object)BACKUP_DIR));
        String nifiCurrentDirName = ShortTypeHandling.castToString((Object)callSiteArray[442].call((Object)commandLine, (Object)NIFI_CURRENT_DIR));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[443].call(Files.class, callSiteArray[444].call(Paths.class, (Object)nifiCurrentDirName)))) {
            throw (Throwable)callSiteArray[445].callConstructor(ParseException.class, callSiteArray[446].call((Object)"Current NiFi installation link does not exist: ", (Object)nifiCurrentDirName));
        }
        String bootstrapConfFileName = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[447].call((Object)commandLine, (Object)BOOTSTRAP_CONF)) ? callSiteArray[448].call((Object)commandLine, (Object)BOOTSTRAP_CONF) : callSiteArray[449].call(callSiteArray[450].call(Paths.class, (Object)nifiCurrentDirName, (Object)"conf", (Object)"bootstrap.conf"))));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[451].callCurrent((GroovyObject)this, (Object)nifiCurrentDirName, (Object)bootstrapConfFileName, (Object)SUPPORTED_MINIMUM_VERSION))) {
            throw (Throwable)callSiteArray[456].callConstructor(UnsupportedOperationException.class, (Object)"File Manager Tool only supports NiFi versions 1.0.0 or higher.");
        }
        callSiteArray[452].callCurrent((GroovyObject)this, (Object)backupDirName, callSiteArray[453].call(callSiteArray[454].call(callSiteArray[455].call(Paths.class, (Object)nifiCurrentDirName))), (Object)bootstrapConfFileName);
    }

    public void parseRestore(CommandLine commandLine) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[457].call((Object)commandLine, (Object)MOVE_REPOSITORIES))) {
            boolean bl;
            this.moveRepositories = bl = true;
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[458].call((Object)commandLine, (Object)BACKUP_DIR))) {
                throw (Throwable)callSiteArray[459].callConstructor(ParseException.class, (Object)"Missing -b option");
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[460].call((Object)commandLine, (Object)NIFI_ROLLBACK_DIR))) {
                throw (Throwable)callSiteArray[461].callConstructor(ParseException.class, (Object)"Missing -r option");
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[462].call((Object)commandLine, (Object)NIFI_CURRENT_DIR)) && this.moveRepositories) {
                throw (Throwable)callSiteArray[463].callConstructor(ParseException.class, (Object)"Missing -c option: Moving repositories requires current nifi directory");
            }
        } else {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[464].call((Object)commandLine, (Object)BACKUP_DIR))) {
                throw (Throwable)callSiteArray[465].callConstructor(ParseException.class, (Object)"Missing -b option");
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[466].call((Object)commandLine, (Object)NIFI_ROLLBACK_DIR))) {
                throw (Throwable)callSiteArray[467].callConstructor(ParseException.class, (Object)"Missing -r option");
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[468].call((Object)commandLine, (Object)NIFI_CURRENT_DIR)) && this.moveRepositories) {
                throw (Throwable)callSiteArray[469].callConstructor(ParseException.class, (Object)"Missing -c option: Moving repositories requires current nifi directory");
            }
        }
        String backupDirName = ShortTypeHandling.castToString((Object)callSiteArray[470].call((Object)commandLine, (Object)BACKUP_DIR));
        String nifiRollbackDirName = ShortTypeHandling.castToString((Object)callSiteArray[471].call((Object)commandLine, (Object)NIFI_ROLLBACK_DIR));
        String nifiCurrentDirName = ShortTypeHandling.castToString((Object)callSiteArray[472].call((Object)commandLine, (Object)NIFI_CURRENT_DIR));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[473].call(Files.class, callSiteArray[474].call(Paths.class, (Object)backupDirName))) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[475].call(Files.class, callSiteArray[476].call(Paths.class, (Object)backupDirName)))) {
            throw (Throwable)callSiteArray[477].callConstructor(ParseException.class, callSiteArray[478].call((Object)"Missing or invalid backup directory: ", (Object)backupDirName));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)nifiCurrentDirName) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[479].call(Files.class, callSiteArray[480].call(Paths.class, (Object)nifiCurrentDirName)))) {
            throw (Throwable)callSiteArray[481].callConstructor(ParseException.class, callSiteArray[482].call((Object)"Current NiFi installation path does not exist: ", (Object)nifiCurrentDirName));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[483].callCurrent((GroovyObject)this, (Object)backupDirName, callSiteArray[484].call(callSiteArray[485].call(Paths.class, (Object)backupDirName, (Object)"bootstrap_files", (Object)"bootstrap.conf")), (Object)SUPPORTED_MINIMUM_VERSION))) {
            throw (Throwable)callSiteArray[486].callConstructor(UnsupportedOperationException.class, (Object)"File Manager Tool only supports NiFi versions 1.0.0 or higher.");
        }
        String bootstrapConfFileName = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[487].call((Object)commandLine, (Object)BOOTSTRAP_CONF)) ? callSiteArray[488].call((Object)commandLine, (Object)BOOTSTRAP_CONF) : callSiteArray[489].call(callSiteArray[490].call(Paths.class, (Object)nifiRollbackDirName, (Object)"conf", (Object)"bootstrap.conf"))));
        callSiteArray[491].callCurrent((GroovyObject)this, (Object)backupDirName, (Object)nifiRollbackDirName, !DefaultTypeTransformation.booleanUnbox((Object)nifiCurrentDirName) ? null : callSiteArray[492].call(callSiteArray[493].call(callSiteArray[494].call(Paths.class, (Object)nifiCurrentDirName))), (Object)bootstrapConfFileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(String ... args) throws ParseException, IllegalArgumentException {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        CommandLine commandLine = (CommandLine)ScriptBytecodeAdapter.castToType((Object)callSiteArray[495].call(callSiteArray[496].callConstructor(DefaultParser.class), callSiteArray[497].callGroovyObjectGetProperty((Object)this), (Object)args), CommandLine.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[498].call((Object)commandLine, (Object)HELP_ARG))) {
            callSiteArray[499].callCurrent((GroovyObject)this, null);
            return;
        } else {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[500].call((Object)commandLine, (Object)OPERATION))) throw (Throwable)callSiteArray[512].callConstructor(ParseException.class, (Object)"Missing -o option");
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[501].call((Object)commandLine, (Object)VERBOSE_ARG))) {
                boolean bl = true;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, FileManagerTool.class, (GroovyObject)this, (String)"isVerbose");
            }
            String operation = ShortTypeHandling.castToString((Object)callSiteArray[502].call(callSiteArray[503].call((Object)commandLine, (Object)OPERATION)));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[504].call((Object)operation, (Object)"install"))) {
                callSiteArray[505].callCurrent((GroovyObject)this, (Object)commandLine);
                return;
            } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[506].call((Object)operation, (Object)"backup"))) {
                callSiteArray[507].callCurrent((GroovyObject)this, (Object)commandLine);
                return;
            } else {
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[508].call((Object)operation, (Object)"restore"))) throw (Throwable)callSiteArray[510].callConstructor(ParseException.class, callSiteArray[511].call((Object)"Invalid operation value:", (Object)operation));
                callSiteArray[509].callCurrent((GroovyObject)this, (Object)commandLine);
            }
        }
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        FileManagerTool tool = (FileManagerTool)ScriptBytecodeAdapter.castToType((Object)callSiteArray[513].callConstructor(FileManagerTool.class), FileManagerTool.class);
        try {
            callSiteArray[514].call((Object)tool, (Object)args);
        }
        catch (Exception e) {
            callSiteArray[515].call((Object)tool, callSiteArray[516].call((Object)e));
            callSiteArray[517].call(System.class, (Object)1);
        }
        callSiteArray[518].call(System.class, (Object)0);
    }

    @Generated
    protected void setPosixPermissions(File file) {
        CallSite[] callSiteArray = FileManagerTool.$getCallSiteArray();
        this.setPosixPermissions(file, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileManagerTool.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        List list;
        POSIX_PERMISSIONS = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{FileManagerTool.$getCallSiteArray()[519].callGetProperty(PosixFilePermission.class), FileManagerTool.$getCallSiteArray()[520].callGetProperty(PosixFilePermission.class), FileManagerTool.$getCallSiteArray()[521].callGetProperty(PosixFilePermission.class), FileManagerTool.$getCallSiteArray()[522].callGetProperty(PosixFilePermission.class), FileManagerTool.$getCallSiteArray()[523].callGetProperty(PosixFilePermission.class), FileManagerTool.$getCallSiteArray()[524].callGetProperty(PosixFilePermission.class), FileManagerTool.$getCallSiteArray()[525].callGetProperty(PosixFilePermission.class), FileManagerTool.$getCallSiteArray()[526].callGetProperty(PosixFilePermission.class), FileManagerTool.$getCallSiteArray()[527].callGetProperty(PosixFilePermission.class)});
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "buildHeader";
        stringArray[1] = "setup";
        stringArray[2] = "getLogger";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "addOption";
        stringArray[5] = "build";
        stringArray[6] = "desc";
        stringArray[7] = "hasArg";
        stringArray[8] = "longOpt";
        stringArray[9] = "builder";
        stringArray[10] = "addOption";
        stringArray[11] = "build";
        stringArray[12] = "desc";
        stringArray[13] = "hasArg";
        stringArray[14] = "longOpt";
        stringArray[15] = "builder";
        stringArray[16] = "addOption";
        stringArray[17] = "build";
        stringArray[18] = "desc";
        stringArray[19] = "hasArg";
        stringArray[20] = "longOpt";
        stringArray[21] = "builder";
        stringArray[22] = "addOption";
        stringArray[23] = "build";
        stringArray[24] = "desc";
        stringArray[25] = "hasArg";
        stringArray[26] = "longOpt";
        stringArray[27] = "builder";
        stringArray[28] = "addOption";
        stringArray[29] = "build";
        stringArray[30] = "desc";
        stringArray[31] = "hasArg";
        stringArray[32] = "longOpt";
        stringArray[33] = "builder";
        stringArray[34] = "addOption";
        stringArray[35] = "build";
        stringArray[36] = "desc";
        stringArray[37] = "hasArg";
        stringArray[38] = "longOpt";
        stringArray[39] = "builder";
        stringArray[40] = "addOption";
        stringArray[41] = "build";
        stringArray[42] = "desc";
        stringArray[43] = "hasArg";
        stringArray[44] = "longOpt";
        stringArray[45] = "builder";
        stringArray[46] = "addOption";
        stringArray[47] = "build";
        stringArray[48] = "desc";
        stringArray[49] = "longOpt";
        stringArray[50] = "builder";
        stringArray[51] = "addOption";
        stringArray[52] = "build";
        stringArray[53] = "desc";
        stringArray[54] = "longOpt";
        stringArray[55] = "builder";
        stringArray[56] = "addOption";
        stringArray[57] = "build";
        stringArray[58] = "desc";
        stringArray[59] = "longOpt";
        stringArray[60] = "builder";
        stringArray[61] = "addOption";
        stringArray[62] = "build";
        stringArray[63] = "desc";
        stringArray[64] = "longOpt";
        stringArray[65] = "builder";
        stringArray[66] = "newHashSet";
        stringArray[67] = "eachWithIndex";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "toFile";
        stringArray[70] = "load";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "isDirectory";
        stringArray[73] = "exists";
        stringArray[74] = "get";
        stringArray[75] = "absolutePath";
        stringArray[76] = "startsWith";
        stringArray[77] = "plus";
        stringArray[78] = "plus";
        stringArray[79] = "separator";
        stringArray[80] = "getAt";
        stringArray[81] = "plus";
        stringArray[82] = "plus";
        stringArray[83] = "separator";
        stringArray[84] = "startsWith";
        stringArray[85] = "plus";
        stringArray[86] = "plus";
        stringArray[87] = "separator";
        stringArray[88] = "getAt";
        stringArray[89] = "plus";
        stringArray[90] = "plus";
        stringArray[91] = "separator";
        stringArray[92] = "get";
        stringArray[93] = "get";
        stringArray[94] = "exists";
        stringArray[95] = "move";
        stringArray[96] = "isVerbose";
        stringArray[97] = "info";
        stringArray[98] = "logger";
        stringArray[99] = "plus";
        stringArray[100] = "plus";
        stringArray[101] = "plus";
        stringArray[102] = "plus";
        stringArray[103] = "separator";
        stringArray[104] = "separator";
        stringArray[105] = "getProperties";
        stringArray[106] = "get";
        stringArray[107] = "plus";
        stringArray[108] = "plus";
        stringArray[109] = "getRelativeDirectory";
        stringArray[110] = "getProperty";
        stringArray[111] = "separator";
        stringArray[112] = "getProperties";
        stringArray[113] = "get";
        stringArray[114] = "getProperty";
        stringArray[115] = "getProperty";
        stringArray[116] = "getProperty";
        stringArray[117] = "getProperty";
        stringArray[118] = "startsWith";
        stringArray[119] = "isVerbose";
        stringArray[120] = "info";
        stringArray[121] = "logger";
        stringArray[122] = "move";
        stringArray[123] = "startsWith";
        stringArray[124] = "isVerbose";
        stringArray[125] = "info";
        stringArray[126] = "logger";
        stringArray[127] = "move";
        stringArray[128] = "startsWith";
        stringArray[129] = "isVerbose";
        stringArray[130] = "info";
        stringArray[131] = "logger";
        stringArray[132] = "move";
        stringArray[133] = "startsWith";
        stringArray[134] = "isVerbose";
        stringArray[135] = "info";
        stringArray[136] = "logger";
        stringArray[137] = "move";
        stringArray[138] = "toFile";
        stringArray[139] = "get";
        stringArray[140] = "exists";
        stringArray[141] = "exists";
        stringArray[142] = "get";
        stringArray[143] = "delete";
        stringArray[144] = "get";
        stringArray[145] = "copyDirectoryToDirectory";
        stringArray[146] = "toFile";
        stringArray[147] = "get";
        stringArray[148] = "getMode";
        stringArray[149] = "getUnixMode";
        stringArray[150] = "getEntry";
        stringArray[151] = "name";
        stringArray[152] = "isDirectory";
        stringArray[153] = "DEFAULT_DIR_MODE";
        stringArray[154] = "DEFAULT_FILE_MODE";
        stringArray[155] = "isDirectory";
        stringArray[156] = "DEFAULT_DIR_MODE";
        stringArray[157] = "DEFAULT_FILE_MODE";
        stringArray[158] = "fromMode";
        stringArray[159] = "size";
        stringArray[160] = "setPosixFilePermissions";
        stringArray[161] = "toPath";
        stringArray[162] = "fromMode";
        stringArray[163] = "IS_OS_WINDOWS";
        stringArray[164] = "setReadable";
        stringArray[165] = "contains";
        stringArray[166] = "OWNER_READ";
        stringArray[167] = "setWritable";
        stringArray[168] = "contains";
        stringArray[169] = "OWNER_WRITE";
        stringArray[170] = "setExecutable";
        stringArray[171] = "contains";
        stringArray[172] = "OWNER_EXECUTE";
        stringArray[173] = "setPosixFilePermissions";
        stringArray[174] = "toPath";
        stringArray[175] = "isVerbose";
        stringArray[176] = "info";
        stringArray[177] = "logger";
        stringArray[178] = "<$constructor$>";
        stringArray[179] = "getProperties";
        stringArray[180] = "get";
        stringArray[181] = "<$constructor$>";
        stringArray[182] = "getRelativeDirectory";
        stringArray[183] = "getProperty";
        stringArray[184] = "<$constructor$>";
        stringArray[185] = "getRelativeDirectory";
        stringArray[186] = "getProperty";
        stringArray[187] = "exists";
        stringArray[188] = "isDirectory";
        stringArray[189] = "deleteDir";
        stringArray[190] = "mkdirs";
        stringArray[191] = "createDirectory";
        stringArray[192] = "get";
        stringArray[193] = "copyFileToDirectory";
        stringArray[194] = "toFile";
        stringArray[195] = "get";
        stringArray[196] = "toFile";
        stringArray[197] = "get";
        stringArray[198] = "copyDirectoryToDirectory";
        stringArray[199] = "toFile";
        stringArray[200] = "get";
        stringArray[201] = "toFile";
        stringArray[202] = "get";
        stringArray[203] = "createDirectories";
        stringArray[204] = "get";
        stringArray[205] = "createDirectories";
        stringArray[206] = "get";
        stringArray[207] = "copyDirectoryToDirectory";
        stringArray[208] = "toFile";
        stringArray[209] = "get";
        stringArray[210] = "copyDirectoryToDirectory";
        stringArray[211] = "toFile";
        stringArray[212] = "get";
        stringArray[213] = "copyDirectoryToDirectory";
        stringArray[214] = "toFile";
        stringArray[215] = "get";
        stringArray[216] = "<$constructor$>";
        stringArray[217] = "copyDirectoryToDirectory";
        stringArray[218] = "toFile";
        stringArray[219] = "get";
        stringArray[220] = "<$constructor$>";
        stringArray[221] = "copyFileToDirectory";
        stringArray[222] = "toFile";
        stringArray[223] = "get";
        stringArray[224] = "<$constructor$>";
        stringArray[225] = "copyFileToDirectory";
        stringArray[226] = "toFile";
        stringArray[227] = "get";
        stringArray[228] = "<$constructor$>";
        stringArray[229] = "copyFileToDirectory";
        stringArray[230] = "toFile";
        stringArray[231] = "get";
        stringArray[232] = "<$constructor$>";
        stringArray[233] = "isVerbose";
        stringArray[234] = "info";
        stringArray[235] = "logger";
        stringArray[236] = "isVerbose";
        stringArray[237] = "info";
        stringArray[238] = "logger";
        stringArray[239] = "plus";
        stringArray[240] = "<$constructor$>";
        stringArray[241] = "toFile";
        stringArray[242] = "get";
        stringArray[243] = "toFile";
        stringArray[244] = "get";
        stringArray[245] = "getProperties";
        stringArray[246] = "get";
        stringArray[247] = "<$constructor$>";
        stringArray[248] = "getRelativeDirectory";
        stringArray[249] = "getProperty";
        stringArray[250] = "<$constructor$>";
        stringArray[251] = "getRelativeDirectory";
        stringArray[252] = "getProperty";
        stringArray[253] = "isDirectory";
        stringArray[254] = "mkdirs";
        stringArray[255] = "isDirectory";
        stringArray[256] = "mkdirs";
        stringArray[257] = "isDirectory";
        stringArray[258] = "mkdirs";
        stringArray[259] = "isDirectory";
        stringArray[260] = "mkdirs";
        stringArray[261] = "isDirectory";
        stringArray[262] = "mkdirs";
        stringArray[263] = "copyFile";
        stringArray[264] = "toFile";
        stringArray[265] = "get";
        stringArray[266] = "<$constructor$>";
        stringArray[267] = "copyDirectoryToDirectory";
        stringArray[268] = "toFile";
        stringArray[269] = "get";
        stringArray[270] = "toFile";
        stringArray[271] = "get";
        stringArray[272] = "copyDirectoryToDirectory";
        stringArray[273] = "toFile";
        stringArray[274] = "get";
        stringArray[275] = "<$constructor$>";
        stringArray[276] = "copyDirectoryToDirectory";
        stringArray[277] = "toFile";
        stringArray[278] = "get";
        stringArray[279] = "<$constructor$>";
        stringArray[280] = "copyDirectory";
        stringArray[281] = "toFile";
        stringArray[282] = "get";
        stringArray[283] = "copyDirectory";
        stringArray[284] = "toFile";
        stringArray[285] = "get";
        stringArray[286] = "copyFileToDirectory";
        stringArray[287] = "toFile";
        stringArray[288] = "get";
        stringArray[289] = "<$constructor$>";
        stringArray[290] = "copyFileToDirectory";
        stringArray[291] = "toFile";
        stringArray[292] = "get";
        stringArray[293] = "<$constructor$>";
        stringArray[294] = "copyFileToDirectory";
        stringArray[295] = "toFile";
        stringArray[296] = "get";
        stringArray[297] = "<$constructor$>";
        stringArray[298] = "toFile";
        stringArray[299] = "get";
        stringArray[300] = "each";
        stringArray[301] = "listFiles";
        stringArray[302] = "moveRepository";
        stringArray[303] = "isVerbose";
        stringArray[304] = "info";
        stringArray[305] = "logger";
        stringArray[306] = "isVerbose";
        stringArray[307] = "info";
        stringArray[308] = "logger";
        stringArray[309] = "absolutePath";
        stringArray[310] = "absolutePath";
        stringArray[311] = "getExtension";
        stringArray[312] = "getName";
        stringArray[313] = "equals";
        stringArray[314] = "<$constructor$>";
        stringArray[315] = "<$constructor$>";
        stringArray[316] = "<$constructor$>";
        stringArray[317] = "createArchiveInputStream";
        stringArray[318] = "<$constructor$>";
        stringArray[319] = "<$constructor$>";
        stringArray[320] = "equals";
        stringArray[321] = "<$constructor$>";
        stringArray[322] = "nextEntry";
        stringArray[323] = "and";
        stringArray[324] = "startsWith";
        stringArray[325] = "toLowerCase";
        stringArray[326] = "name";
        stringArray[327] = "indexOf";
        stringArray[328] = "name";
        stringArray[329] = "separator";
        stringArray[330] = "getAt";
        stringArray[331] = "name";
        stringArray[332] = "minus";
        stringArray[333] = "indexOf";
        stringArray[334] = "name";
        stringArray[335] = "separator";
        stringArray[336] = "name";
        stringArray[337] = "isVerbose";
        stringArray[338] = "info";
        stringArray[339] = "logger";
        stringArray[340] = "toFile";
        stringArray[341] = "get";
        stringArray[342] = "getAbsolutePath";
        stringArray[343] = "exists";
        stringArray[344] = "deleteDir";
        stringArray[345] = "mkdirs";
        stringArray[346] = "isVerbose";
        stringArray[347] = "info";
        stringArray[348] = "logger";
        stringArray[349] = "name";
        stringArray[350] = "startsWith";
        stringArray[351] = "name";
        stringArray[352] = "toFile";
        stringArray[353] = "get";
        stringArray[354] = "getAbsolutePath";
        stringArray[355] = "name";
        stringArray[356] = "isDirectory";
        stringArray[357] = "exists";
        stringArray[358] = "mkdirs";
        stringArray[359] = "<$constructor$>";
        stringArray[360] = "plus";
        stringArray[361] = "getAbsolutePath";
        stringArray[362] = "getParentFile";
        stringArray[363] = "exists";
        stringArray[364] = "mkdirs";
        stringArray[365] = "<$constructor$>";
        stringArray[366] = "copy";
        stringArray[367] = "close";
        stringArray[368] = "IS_OS_WINDOWS";
        stringArray[369] = "setPosixPermissions";
        stringArray[370] = "nextEntry";
        stringArray[371] = "<$constructor$>";
        stringArray[372] = "plus";
        stringArray[373] = "getName";
        stringArray[374] = "<$constructor$>";
        stringArray[375] = "isVerbose";
        stringArray[376] = "info";
        stringArray[377] = "logger";
        stringArray[378] = "plus";
        stringArray[379] = "exists";
        stringArray[380] = "<$constructor$>";
        stringArray[381] = "exists";
        stringArray[382] = "mkdirs";
        stringArray[383] = "extract";
        stringArray[384] = "toFile";
        stringArray[385] = "get";
        stringArray[386] = "valid";
        stringArray[387] = "copyState";
        stringArray[388] = "absolutePath";
        stringArray[389] = "moveRepository";
        stringArray[390] = "absolutePath";
        stringArray[391] = "<$constructor$>";
        stringArray[392] = "isVerbose";
        stringArray[393] = "run";
        stringArray[394] = "canonicalPath";
        stringArray[395] = "<$constructor$>";
        stringArray[396] = "<$constructor$>";
        stringArray[397] = "isVerbose";
        stringArray[398] = "info";
        stringArray[399] = "logger";
        stringArray[400] = "hasOption";
        stringArray[401] = "hasOption";
        stringArray[402] = "<$constructor$>";
        stringArray[403] = "hasOption";
        stringArray[404] = "<$constructor$>";
        stringArray[405] = "hasOption";
        stringArray[406] = "<$constructor$>";
        stringArray[407] = "hasOption";
        stringArray[408] = "<$constructor$>";
        stringArray[409] = "hasOption";
        stringArray[410] = "<$constructor$>";
        stringArray[411] = "hasOption";
        stringArray[412] = "<$constructor$>";
        stringArray[413] = "getOptionValue";
        stringArray[414] = "getOptionValue";
        stringArray[415] = "getOptionValue";
        stringArray[416] = "hasOption";
        stringArray[417] = "hasOption";
        stringArray[418] = "getOptionValue";
        stringArray[419] = "toString";
        stringArray[420] = "get";
        stringArray[421] = "notExists";
        stringArray[422] = "get";
        stringArray[423] = "<$constructor$>";
        stringArray[424] = "plus";
        stringArray[425] = "notExists";
        stringArray[426] = "get";
        stringArray[427] = "<$constructor$>";
        stringArray[428] = "plus";
        stringArray[429] = "supportedNiFiMinimumVersion";
        stringArray[430] = "<$constructor$>";
        stringArray[431] = "supportedNiFiMinimumVersion";
        stringArray[432] = "<$constructor$>";
        stringArray[433] = "install";
        stringArray[434] = "getCanonicalPath";
        stringArray[435] = "toFile";
        stringArray[436] = "get";
        stringArray[437] = "hasOption";
        stringArray[438] = "<$constructor$>";
        stringArray[439] = "hasOption";
        stringArray[440] = "<$constructor$>";
        stringArray[441] = "getOptionValue";
        stringArray[442] = "getOptionValue";
        stringArray[443] = "notExists";
        stringArray[444] = "get";
        stringArray[445] = "<$constructor$>";
        stringArray[446] = "plus";
        stringArray[447] = "hasOption";
        stringArray[448] = "getOptionValue";
        stringArray[449] = "toString";
        stringArray[450] = "get";
        stringArray[451] = "supportedNiFiMinimumVersion";
        stringArray[452] = "backup";
        stringArray[453] = "getCanonicalPath";
        stringArray[454] = "toFile";
        stringArray[455] = "get";
        stringArray[456] = "<$constructor$>";
        stringArray[457] = "hasOption";
        stringArray[458] = "hasOption";
        stringArray[459] = "<$constructor$>";
        stringArray[460] = "hasOption";
        stringArray[461] = "<$constructor$>";
        stringArray[462] = "hasOption";
        stringArray[463] = "<$constructor$>";
        stringArray[464] = "hasOption";
        stringArray[465] = "<$constructor$>";
        stringArray[466] = "hasOption";
        stringArray[467] = "<$constructor$>";
        stringArray[468] = "hasOption";
        stringArray[469] = "<$constructor$>";
        stringArray[470] = "getOptionValue";
        stringArray[471] = "getOptionValue";
        stringArray[472] = "getOptionValue";
        stringArray[473] = "notExists";
        stringArray[474] = "get";
        stringArray[475] = "isDirectory";
        stringArray[476] = "get";
        stringArray[477] = "<$constructor$>";
        stringArray[478] = "plus";
        stringArray[479] = "notExists";
        stringArray[480] = "get";
        stringArray[481] = "<$constructor$>";
        stringArray[482] = "plus";
        stringArray[483] = "supportedNiFiMinimumVersion";
        stringArray[484] = "toString";
        stringArray[485] = "get";
        stringArray[486] = "<$constructor$>";
        stringArray[487] = "hasOption";
        stringArray[488] = "getOptionValue";
        stringArray[489] = "toString";
        stringArray[490] = "get";
        stringArray[491] = "restore";
        stringArray[492] = "getCanonicalPath";
        stringArray[493] = "toFile";
        stringArray[494] = "get";
        stringArray[495] = "parse";
        stringArray[496] = "<$constructor$>";
        stringArray[497] = "options";
        stringArray[498] = "hasOption";
        stringArray[499] = "printUsage";
        stringArray[500] = "hasOption";
        stringArray[501] = "hasOption";
        stringArray[502] = "toLowerCase";
        stringArray[503] = "getOptionValue";
        stringArray[504] = "equals";
        stringArray[505] = "parseInstall";
        stringArray[506] = "equals";
        stringArray[507] = "parseBackup";
        stringArray[508] = "equals";
        stringArray[509] = "parseRestore";
        stringArray[510] = "<$constructor$>";
        stringArray[511] = "plus";
        stringArray[512] = "<$constructor$>";
        stringArray[513] = "<$constructor$>";
        stringArray[514] = "parse";
        stringArray[515] = "printUsage";
        stringArray[516] = "getLocalizedMessage";
        stringArray[517] = "exit";
        stringArray[518] = "exit";
        stringArray[519] = "OTHERS_EXECUTE";
        stringArray[520] = "OTHERS_WRITE";
        stringArray[521] = "OTHERS_READ";
        stringArray[522] = "GROUP_EXECUTE";
        stringArray[523] = "GROUP_WRITE";
        stringArray[524] = "GROUP_READ";
        stringArray[525] = "OWNER_EXECUTE";
        stringArray[526] = "OWNER_WRITE";
        stringArray[527] = "OWNER_READ";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[528];
        FileManagerTool.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(FileManagerTool.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = FileManagerTool.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

