/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.admin.notify;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.lang.ref.SoftReference;
import java.nio.file.Paths;
import java.util.Properties;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.properties.NiFiPropertiesLoader;
import org.apache.nifi.toolkit.admin.AbstractAdminTool;
import org.apache.nifi.toolkit.admin.client.ClientFactory;
import org.apache.nifi.toolkit.admin.client.NiFiClientFactory;
import org.apache.nifi.toolkit.admin.client.NiFiClientUtil;
import org.apache.nifi.toolkit.admin.util.AdminUtil;
import org.apache.nifi.util.NiFiBootstrapUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.api.dto.BulletinDTO;
import org.apache.nifi.web.api.entity.BulletinEntity;
import org.apache.nifi.web.security.ProxiedEntitiesUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationTool
extends AbstractAdminTool {
    private static final String DEFAULT_DESCRIPTION = "This tool is used to send notifications (bulletins) to a NiFi cluster. ";
    private static final String HELP_ARG = "help";
    private static final String VERBOSE_ARG = "verbose";
    private static final String BOOTSTRAP_CONF = "bootstrapConf";
    private static final String PROXY_DN = "proxyDn";
    private static final String NIFI_INSTALL_DIR = "nifiInstallDir";
    private static final String NOTIFICATION_MESSAGE = "message";
    private static final String NOTIFICATION_LEVEL = "level";
    private static final String NOTIFICATION_ENDPOINT = "/nifi-api/controller/bulletin";
    private static final String SUPPORTED_MINIMUM_VERSION = "1.2.0";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public NotificationTool() {
        CallSite[] callSiteArray = NotificationTool.$getCallSiteArray();
        Object object = callSiteArray[0].callCurrent((GroovyObject)this, (Object)DEFAULT_DESCRIPTION);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, NotificationTool.class, (GroovyObject)this, (String)"header");
        callSiteArray[1].callCurrent((GroovyObject)this);
    }

    public NotificationTool(String description) {
        CallSite[] callSiteArray = NotificationTool.$getCallSiteArray();
        Object object = callSiteArray[2].callCurrent((GroovyObject)this, (Object)description);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, NotificationTool.class, (GroovyObject)this, (String)"header");
        callSiteArray[3].callCurrent((GroovyObject)this);
    }

    @Override
    protected Logger getLogger() {
        CallSite[] callSiteArray = NotificationTool.$getCallSiteArray();
        return (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(LoggerFactory.class, NotificationTool.class), Logger.class);
    }

    @Override
    protected Options getOptions() {
        CallSite[] callSiteArray = NotificationTool.$getCallSiteArray();
        Options options = (Options)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callConstructor(Options.class), Options.class);
        callSiteArray[6].call((Object)options, callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call(Option.class, (Object)"h"), (Object)HELP_ARG), (Object)"Print help info")));
        callSiteArray[11].call((Object)options, callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call(callSiteArray[15].call(Option.class, (Object)"v"), (Object)VERBOSE_ARG), (Object)"Set mode to verbose (default is false)")));
        callSiteArray[16].call((Object)options, callSiteArray[17].call(callSiteArray[18].call(callSiteArray[19].call(callSiteArray[20].call(callSiteArray[21].call(Option.class, (Object)"p"), (Object)PROXY_DN)), (Object)"User or Proxy DN that has permission to send a notification. User must have view and modify privileges to 'access the controller' in NiFi")));
        callSiteArray[22].call((Object)options, callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].call(callSiteArray[26].call(callSiteArray[27].call(Option.class, (Object)"b"), (Object)BOOTSTRAP_CONF)), (Object)"Existing Bootstrap Configuration file")));
        callSiteArray[28].call((Object)options, callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].call(callSiteArray[32].call(callSiteArray[33].call(Option.class, (Object)"d"), (Object)NIFI_INSTALL_DIR)), (Object)"NiFi Installation Directory")));
        callSiteArray[34].call((Object)options, callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].call(callSiteArray[38].call(callSiteArray[39].call(Option.class, (Object)"m"), (Object)NOTIFICATION_MESSAGE)), (Object)"Notification message for nifi instance or cluster")));
        callSiteArray[40].call((Object)options, callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].call(Option.class, (Object)"l"), (Object)NOTIFICATION_LEVEL), (Object)false)), (Object)"Level for notification bulletin INFO,WARN,ERROR")));
        return options;
    }

    public void notifyCluster(ClientFactory clientFactory, String nifiPropertiesFile, String bootstrapConfFile, String nifiInstallDir, String message, String level, String proxyDN) {
        CallSite[] callSiteArray = NotificationTool.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].callGroovyObjectGetProperty((Object)this))) {
            callSiteArray[48].call(callSiteArray[49].callGroovyObjectGetProperty((Object)this), (Object)"Loading nifi properties for host information");
        }
        String key = ShortTypeHandling.castToString((Object)callSiteArray[50].call(NiFiBootstrapUtils.class, (Object)bootstrapConfFile));
        NiFiProperties niFiProperties = (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].call(callSiteArray[52].call(NiFiPropertiesLoader.class, (Object)key), (Object)nifiPropertiesFile), NiFiProperties.class);
        Client client = (Client)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].call((Object)clientFactory, (Object)niFiProperties, (Object)nifiInstallDir), Client.class);
        String url = ShortTypeHandling.castToString((Object)callSiteArray[54].call(NiFiClientUtil.class, (Object)niFiProperties, (Object)NOTIFICATION_ENDPOINT));
        WebTarget webTarget = (WebTarget)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].call((Object)client, (Object)url), WebTarget.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[56].callGroovyObjectGetProperty((Object)this))) {
            callSiteArray[57].call(callSiteArray[58].callGroovyObjectGetProperty((Object)this), callSiteArray[59].call((Object)"Contacting node at url:", (Object)url));
        }
        BulletinEntity bulletinEntity = (BulletinEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].callConstructor(BulletinEntity.class), BulletinEntity.class);
        BulletinDTO bulletinDTO = (BulletinDTO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].callConstructor(BulletinDTO.class), BulletinDTO.class);
        String string = message;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)bulletinDTO, (String)NOTIFICATION_MESSAGE);
        String string2 = "NOTICE";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)bulletinDTO, (String)"category");
        String string3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[62].call(org.apache.commons.lang3.StringUtils.class, (Object)level)) ? "INFO" : level;
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)bulletinDTO, (String)NOTIFICATION_LEVEL);
        BulletinDTO bulletinDTO2 = bulletinDTO;
        ScriptBytecodeAdapter.setProperty((Object)bulletinDTO2, null, (Object)bulletinEntity, (String)"bulletin");
        Response response = null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[63].call(StringUtils.class, callSiteArray[64].call((Object)niFiProperties, callSiteArray[65].callGetProperty(NiFiProperties.class))))) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[66].call(org.apache.commons.lang3.StringUtils.class, (Object)proxyDN))) {
                throw (Throwable)callSiteArray[67].callConstructor(UnsupportedOperationException.class, (Object)"Proxy DN is required for sending a notification to this node or cluster");
            }
            Object object = callSiteArray[68].call(callSiteArray[69].call(callSiteArray[70].call((Object)webTarget), callSiteArray[71].callGetProperty(ProxiedEntitiesUtils.class), callSiteArray[72].call(ProxiedEntitiesUtils.class, (Object)proxyDN)), callSiteArray[73].call(Entity.class, (Object)bulletinEntity));
            response = (Response)ScriptBytecodeAdapter.castToType((Object)object, Response.class);
        } else {
            Object object = callSiteArray[74].call(callSiteArray[75].call((Object)webTarget), callSiteArray[76].call(Entity.class, (Object)bulletinEntity));
            response = (Response)ScriptBytecodeAdapter.castToType((Object)object, Response.class);
        }
        Integer status = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[77].call((Object)response), Integer.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)status, (Object)200)) {
            if (ScriptBytecodeAdapter.compareEqual((Object)status, (Object)404)) {
                throw (Throwable)callSiteArray[78].callConstructor(RuntimeException.class, (Object)"The notification feature is not supported by each node in the cluster");
            }
            throw (Throwable)callSiteArray[79].callConstructor(RuntimeException.class, callSiteArray[80].call(callSiteArray[81].call(callSiteArray[82].call((Object)"Failed with HTTP error code ", (Object)status), (Object)" with reason: "), callSiteArray[83].call((Object)response, String.class)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(ClientFactory clientFactory, String ... args) throws ParseException, UnsupportedOperationException {
        CallSite[] callSiteArray = NotificationTool.$getCallSiteArray();
        CommandLine commandLine = (CommandLine)ScriptBytecodeAdapter.castToType((Object)callSiteArray[84].call(callSiteArray[85].callConstructor(DefaultParser.class), callSiteArray[86].callGroovyObjectGetProperty((Object)this), (Object)args), CommandLine.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[87].call((Object)commandLine, (Object)HELP_ARG))) {
            callSiteArray[88].callCurrent((GroovyObject)this, null);
            return;
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[89].call((Object)commandLine, (Object)BOOTSTRAP_CONF)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[90].call((Object)commandLine, (Object)NOTIFICATION_MESSAGE)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[91].call((Object)commandLine, (Object)NIFI_INSTALL_DIR))) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[92].call((Object)commandLine, (Object)VERBOSE_ARG))) {
                boolean bl = true;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, NotificationTool.class, (GroovyObject)this, (String)"isVerbose");
            }
            String bootstrapConfFileName = ShortTypeHandling.castToString((Object)callSiteArray[93].call((Object)commandLine, (Object)BOOTSTRAP_CONF));
            File bootstrapConf = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[94].callConstructor(File.class, (Object)bootstrapConfFileName), File.class);
            Properties bootstrapProperties = (Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[95].call(AdminUtil.class, callSiteArray[96].call(Paths.class, (Object)bootstrapConfFileName)), Properties.class);
            String proxyDN = ShortTypeHandling.castToString((Object)callSiteArray[97].call((Object)commandLine, (Object)PROXY_DN));
            String parentPathName = ShortTypeHandling.castToString((Object)callSiteArray[98].call(callSiteArray[99].call(callSiteArray[100].call(callSiteArray[101].call((Object)bootstrapConf)))));
            String nifiConfDir = ShortTypeHandling.castToString((Object)callSiteArray[102].call(AdminUtil.class, callSiteArray[103].call((Object)bootstrapProperties, (Object)"conf.dir"), (Object)parentPathName));
            String nifiLibDir = ShortTypeHandling.castToString((Object)callSiteArray[104].call(AdminUtil.class, callSiteArray[105].call((Object)bootstrapProperties, (Object)"lib.dir"), (Object)parentPathName));
            String nifiPropertiesFileName = ShortTypeHandling.castToString((Object)callSiteArray[106].call(callSiteArray[107].call((Object)nifiConfDir, callSiteArray[108].callGetProperty(File.class)), (Object)"nifi.properties"));
            String notificationMessage = ShortTypeHandling.castToString((Object)callSiteArray[109].call((Object)commandLine, (Object)NOTIFICATION_MESSAGE));
            String notificationLevel = ShortTypeHandling.castToString((Object)callSiteArray[110].call((Object)commandLine, (Object)NOTIFICATION_LEVEL));
            String nifiInstallDir = ShortTypeHandling.castToString((Object)callSiteArray[111].call((Object)commandLine, (Object)NIFI_INSTALL_DIR));
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[112].call(AdminUtil.class, (Object)nifiConfDir, (Object)nifiLibDir, (Object)SUPPORTED_MINIMUM_VERSION))) throw (Throwable)callSiteArray[120].callConstructor(UnsupportedOperationException.class, (Object)"Notification Tool only supports NiFi versions 1.2.0 and above");
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[113].callGroovyObjectGetProperty((Object)this))) {
                callSiteArray[114].call(callSiteArray[115].callGroovyObjectGetProperty((Object)this), (Object)"Attempting to connect with nifi using properties:", (Object)nifiPropertiesFileName);
            }
            callSiteArray[116].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)clientFactory, (Object)nifiPropertiesFileName, (Object)bootstrapConfFileName, (Object)nifiInstallDir, (Object)notificationMessage, (Object)notificationLevel, (Object)proxyDN));
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[117].callGroovyObjectGetProperty((Object)this))) return;
            callSiteArray[118].call(callSiteArray[119].callGroovyObjectGetProperty((Object)this), (Object)"Message sent successfully to NiFi.");
            return;
        } else {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[121].call((Object)commandLine, (Object)BOOTSTRAP_CONF))) {
                throw (Throwable)callSiteArray[122].callConstructor(ParseException.class, (Object)"Missing -b option");
            }
            if (!(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[123].call((Object)commandLine, (Object)NIFI_INSTALL_DIR)))) throw (Throwable)callSiteArray[125].callConstructor(ParseException.class, (Object)"Missing -m option");
            throw (Throwable)callSiteArray[124].callConstructor(ParseException.class, (Object)"Missing -d option");
        }
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = NotificationTool.$getCallSiteArray();
        NotificationTool tool = (NotificationTool)ScriptBytecodeAdapter.castToType((Object)callSiteArray[126].callConstructor(NotificationTool.class), NotificationTool.class);
        ClientFactory clientFactory = (ClientFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[127].callConstructor(NiFiClientFactory.class), ClientFactory.class);
        try {
            callSiteArray[128].call((Object)tool, (Object)clientFactory, (Object)args);
        }
        catch (Exception e) {
            callSiteArray[129].call((Object)tool, callSiteArray[130].callGetProperty((Object)e));
            callSiteArray[131].call(System.class, (Object)1);
        }
        callSiteArray[132].call(System.class, (Object)0);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != NotificationTool.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "buildHeader";
        stringArray[1] = "setup";
        stringArray[2] = "buildHeader";
        stringArray[3] = "setup";
        stringArray[4] = "getLogger";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "addOption";
        stringArray[7] = "build";
        stringArray[8] = "desc";
        stringArray[9] = "longOpt";
        stringArray[10] = "builder";
        stringArray[11] = "addOption";
        stringArray[12] = "build";
        stringArray[13] = "desc";
        stringArray[14] = "longOpt";
        stringArray[15] = "builder";
        stringArray[16] = "addOption";
        stringArray[17] = "build";
        stringArray[18] = "desc";
        stringArray[19] = "hasArg";
        stringArray[20] = "longOpt";
        stringArray[21] = "builder";
        stringArray[22] = "addOption";
        stringArray[23] = "build";
        stringArray[24] = "desc";
        stringArray[25] = "hasArg";
        stringArray[26] = "longOpt";
        stringArray[27] = "builder";
        stringArray[28] = "addOption";
        stringArray[29] = "build";
        stringArray[30] = "desc";
        stringArray[31] = "hasArg";
        stringArray[32] = "longOpt";
        stringArray[33] = "builder";
        stringArray[34] = "addOption";
        stringArray[35] = "build";
        stringArray[36] = "desc";
        stringArray[37] = "hasArg";
        stringArray[38] = "longOpt";
        stringArray[39] = "builder";
        stringArray[40] = "addOption";
        stringArray[41] = "build";
        stringArray[42] = "desc";
        stringArray[43] = "hasArg";
        stringArray[44] = "required";
        stringArray[45] = "longOpt";
        stringArray[46] = "builder";
        stringArray[47] = "isVerbose";
        stringArray[48] = "info";
        stringArray[49] = "logger";
        stringArray[50] = "extractKeyFromBootstrapFile";
        stringArray[51] = "load";
        stringArray[52] = "withKey";
        stringArray[53] = "getClient";
        stringArray[54] = "getUrl";
        stringArray[55] = "target";
        stringArray[56] = "isVerbose";
        stringArray[57] = "info";
        stringArray[58] = "logger";
        stringArray[59] = "plus";
        stringArray[60] = "<$constructor$>";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "isEmpty";
        stringArray[63] = "isEmpty";
        stringArray[64] = "getProperty";
        stringArray[65] = "WEB_HTTPS_PORT";
        stringArray[66] = "isEmpty";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "post";
        stringArray[69] = "header";
        stringArray[70] = "request";
        stringArray[71] = "PROXY_ENTITIES_CHAIN";
        stringArray[72] = "formatProxyDn";
        stringArray[73] = "json";
        stringArray[74] = "post";
        stringArray[75] = "request";
        stringArray[76] = "json";
        stringArray[77] = "getStatus";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "plus";
        stringArray[81] = "plus";
        stringArray[82] = "plus";
        stringArray[83] = "readEntity";
        stringArray[84] = "parse";
        stringArray[85] = "<$constructor$>";
        stringArray[86] = "options";
        stringArray[87] = "hasOption";
        stringArray[88] = "printUsage";
        stringArray[89] = "hasOption";
        stringArray[90] = "hasOption";
        stringArray[91] = "hasOption";
        stringArray[92] = "hasOption";
        stringArray[93] = "getOptionValue";
        stringArray[94] = "<$constructor$>";
        stringArray[95] = "getBootstrapConf";
        stringArray[96] = "get";
        stringArray[97] = "getOptionValue";
        stringArray[98] = "getCanonicalPath";
        stringArray[99] = "getParentFile";
        stringArray[100] = "getParentFile";
        stringArray[101] = "getCanonicalFile";
        stringArray[102] = "getRelativeDirectory";
        stringArray[103] = "getProperty";
        stringArray[104] = "getRelativeDirectory";
        stringArray[105] = "getProperty";
        stringArray[106] = "plus";
        stringArray[107] = "plus";
        stringArray[108] = "separator";
        stringArray[109] = "getOptionValue";
        stringArray[110] = "getOptionValue";
        stringArray[111] = "getOptionValue";
        stringArray[112] = "supportedNiFiMinimumVersion";
        stringArray[113] = "isVerbose";
        stringArray[114] = "info";
        stringArray[115] = "logger";
        stringArray[116] = "notifyCluster";
        stringArray[117] = "isVerbose";
        stringArray[118] = "info";
        stringArray[119] = "logger";
        stringArray[120] = "<$constructor$>";
        stringArray[121] = "hasOption";
        stringArray[122] = "<$constructor$>";
        stringArray[123] = "hasOption";
        stringArray[124] = "<$constructor$>";
        stringArray[125] = "<$constructor$>";
        stringArray[126] = "<$constructor$>";
        stringArray[127] = "<$constructor$>";
        stringArray[128] = "parse";
        stringArray[129] = "printUsage";
        stringArray[130] = NOTIFICATION_MESSAGE;
        stringArray[131] = "exit";
        stringArray[132] = "exit";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[133];
        NotificationTool.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(NotificationTool.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = NotificationTool.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

