/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ControllerClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.RequestConfig;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.entity.ClusterEntity;
import org.apache.nifi.web.api.entity.ControllerConfigurationEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientsEntity;
import org.apache.nifi.web.api.entity.NodeEntity;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;

public class JerseyControllerClient
extends AbstractJerseyClient
implements ControllerClient {
    private final WebTarget controllerTarget;

    public JerseyControllerClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyControllerClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.controllerTarget = baseTarget.path("/controller");
    }

    @Override
    public FlowRegistryClientsEntity getRegistryClients() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving registry clients", () -> {
            WebTarget target = this.controllerTarget.path("registry-clients");
            return (FlowRegistryClientsEntity)this.getRequestBuilder(target).get(FlowRegistryClientsEntity.class);
        });
    }

    @Override
    public FlowRegistryClientEntity getRegistryClient(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Registry client id cannot be null");
        }
        WebTarget target = this.controllerTarget.path("registry-clients/{id}").resolveTemplate("id", (Object)id);
        return (FlowRegistryClientEntity)this.getRequestBuilder(target).get(FlowRegistryClientEntity.class);
    }

    @Override
    public FlowRegistryClientEntity createRegistryClient(FlowRegistryClientEntity registryClient) throws NiFiClientException, IOException {
        if (registryClient == null) {
            throw new IllegalArgumentException("Registry client entity cannot be null");
        }
        return this.executeAction("Error creating registry client", () -> {
            WebTarget target = this.controllerTarget.path("registry-clients");
            return (FlowRegistryClientEntity)this.getRequestBuilder(target).post(Entity.entity((Object)registryClient, (String)"application/json"), FlowRegistryClientEntity.class);
        });
    }

    @Override
    public FlowRegistryClientEntity updateRegistryClient(FlowRegistryClientEntity registryClient) throws NiFiClientException, IOException {
        if (registryClient == null) {
            throw new IllegalArgumentException("Registry client entity cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)registryClient.getId())) {
            throw new IllegalArgumentException("Registry client entity must contain an id");
        }
        return this.executeAction("Error updating registry client", () -> {
            WebTarget target = this.controllerTarget.path("registry-clients/{id}").resolveTemplate("id", (Object)registryClient.getId());
            return (FlowRegistryClientEntity)this.getRequestBuilder(target).put(Entity.entity((Object)registryClient, (String)"application/json"), FlowRegistryClientEntity.class);
        });
    }

    @Override
    public NodeEntity deleteNode(String nodeId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        return this.executeAction("Error deleting node", () -> {
            WebTarget target = this.controllerTarget.path("cluster/nodes/" + nodeId);
            return (NodeEntity)this.getRequestBuilder(target).delete(NodeEntity.class);
        });
    }

    @Override
    public NodeEntity connectNode(String nodeId, NodeEntity nodeEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        if (nodeEntity == null) {
            throw new IllegalArgumentException("Node entity cannot be null");
        }
        return this.executeAction("Error connecting node", () -> {
            WebTarget target = this.controllerTarget.path("cluster/nodes/" + nodeId);
            return (NodeEntity)this.getRequestBuilder(target).put(Entity.entity((Object)nodeEntity, (String)"application/json"), NodeEntity.class);
        });
    }

    @Override
    public NodeEntity offloadNode(String nodeId, NodeEntity nodeEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        if (nodeEntity == null) {
            throw new IllegalArgumentException("Node entity cannot be null");
        }
        return this.executeAction("Error offloading node", () -> {
            WebTarget target = this.controllerTarget.path("cluster/nodes/" + nodeId);
            return (NodeEntity)this.getRequestBuilder(target).put(Entity.entity((Object)nodeEntity, (String)"application/json"), NodeEntity.class);
        });
    }

    @Override
    public NodeEntity disconnectNode(String nodeId, NodeEntity nodeEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        if (nodeEntity == null) {
            throw new IllegalArgumentException("Node entity cannot be null");
        }
        return this.executeAction("Error disconnecting node", () -> {
            WebTarget target = this.controllerTarget.path("cluster/nodes/" + nodeId);
            return (NodeEntity)this.getRequestBuilder(target).put(Entity.entity((Object)nodeEntity, (String)"application/json"), NodeEntity.class);
        });
    }

    @Override
    public NodeEntity getNode(String nodeId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        return this.executeAction("Error retrieving node status", () -> {
            WebTarget target = this.controllerTarget.path("cluster/nodes/" + nodeId);
            return (NodeEntity)this.getRequestBuilder(target).get(NodeEntity.class);
        });
    }

    @Override
    public ClusterEntity getNodes() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving node status", () -> {
            WebTarget target = this.controllerTarget.path("cluster");
            return (ClusterEntity)this.getRequestBuilder(target).get(ClusterEntity.class);
        });
    }

    @Override
    public ControllerServiceEntity createControllerService(ControllerServiceEntity controllerService) throws NiFiClientException, IOException {
        if (controllerService == null) {
            throw new IllegalArgumentException("Controller service entity cannot be null");
        }
        return this.executeAction("Error creating controller service", () -> {
            WebTarget target = this.controllerTarget.path("controller-services");
            return (ControllerServiceEntity)this.getRequestBuilder(target).post(Entity.entity((Object)controllerService, (String)"application/json"), ControllerServiceEntity.class);
        });
    }

    @Override
    public ReportingTaskEntity createReportingTask(ReportingTaskEntity reportingTask) throws NiFiClientException, IOException {
        if (reportingTask == null) {
            throw new IllegalArgumentException("Reporting task entity cannot be null");
        }
        return this.executeAction("Error creating reporting task", () -> {
            WebTarget target = this.controllerTarget.path("reporting-tasks");
            return (ReportingTaskEntity)this.getRequestBuilder(target).post(Entity.entity((Object)reportingTask, (String)"application/json"), ReportingTaskEntity.class);
        });
    }

    @Override
    public ParameterProviderEntity createParamProvider(ParameterProviderEntity paramProvider) throws NiFiClientException, IOException {
        if (paramProvider == null) {
            throw new IllegalArgumentException("Parameter provider cannot be null or blank");
        }
        return this.executeAction("Error creating parameter provider", () -> {
            WebTarget target = this.controllerTarget.path("parameter-providers");
            return (ParameterProviderEntity)this.getRequestBuilder(target).post(Entity.entity((Object)paramProvider, (String)"application/json"), ParameterProviderEntity.class);
        });
    }

    @Override
    public ControllerConfigurationEntity getControllerConfiguration() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving controller configuration", () -> {
            WebTarget target = this.controllerTarget.path("config");
            return (ControllerConfigurationEntity)this.getRequestBuilder(target).get(ControllerConfigurationEntity.class);
        });
    }

    @Override
    public ControllerConfigurationEntity updateControllerConfiguration(ControllerConfigurationEntity controllerConfiguration) throws NiFiClientException, IOException {
        if (controllerConfiguration == null || controllerConfiguration.getComponent() == null) {
            throw new IllegalArgumentException("Controller configuration must be specified");
        }
        if (controllerConfiguration.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        return this.executeAction("Error updating controller configuration", () -> {
            WebTarget target = this.controllerTarget.path("config");
            return (ControllerConfigurationEntity)this.getRequestBuilder(target).put(Entity.entity((Object)controllerConfiguration, (String)"application/json"), ControllerConfigurationEntity.class);
        });
    }
}

