/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.kafkamigrator.descriptor;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.toolkit.kafkamigrator.descriptor.KafkaProcessorType;
import org.apache.nifi.toolkit.kafkamigrator.descriptor.PropertyXpathDescriptor;

public class TemplatePropertyXpathDescriptor
implements PropertyXpathDescriptor {
    private static final Map<String, String> CONSUME_TRANSACTION_PROPERTIES = new HashMap<String, String>();
    private static final Map<String, String> PUBLISH_TRANSACTION_PROPERTIES;
    private static final Map<KafkaProcessorType, Map<String, String>> TRANSACTION_PROPERTIES;
    private final KafkaProcessorType processorType;

    public TemplatePropertyXpathDescriptor(KafkaProcessorType processorType) {
        this.processorType = processorType;
    }

    @Override
    public String getXpathForProperties() {
        return "entry";
    }

    @Override
    public String getPropertyKeyTagName() {
        return "key";
    }

    @Override
    public String getPropertyTagName() {
        return "entry";
    }

    @Override
    public String getXpathForTransactionProperty() {
        return TRANSACTION_PROPERTIES.get((Object)this.processorType).get("xpathForTransactionProperty");
    }

    @Override
    public String getTransactionTagName() {
        return TRANSACTION_PROPERTIES.get((Object)this.processorType).get("transactionTagName");
    }

    static {
        CONSUME_TRANSACTION_PROPERTIES.put("xpathForTransactionProperty", "entry[key=\"honor-transactions\"]/value");
        CONSUME_TRANSACTION_PROPERTIES.put("transactionTagName", "honor-transactions");
        PUBLISH_TRANSACTION_PROPERTIES = new HashMap<String, String>();
        PUBLISH_TRANSACTION_PROPERTIES.put("xpathForTransactionProperty", "entry[key=\"use-transactions\"]/value");
        PUBLISH_TRANSACTION_PROPERTIES.put("transactionTagName", "use-transactions");
        TRANSACTION_PROPERTIES = new HashMap<KafkaProcessorType, Map<String, String>>();
        TRANSACTION_PROPERTIES.put(KafkaProcessorType.CONSUME, CONSUME_TRANSACTION_PROPERTIES);
        TRANSACTION_PROPERTIES.put(KafkaProcessorType.PUBLISH, PUBLISH_TRANSACTION_PROPERTIES);
    }
}

