/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.util;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import org.apache.olingo.odata2.api.ep.EntityProviderException;

public class JsonUtils {
    public static String createODataContextValueForTombstone(String entitySetName) {
        return "$metadata#" + entitySetName + "/$deletedEntity";
    }

    public static int startJson(JsonReader reader) throws EntityProviderException {
        try {
            JsonToken token = reader.peek();
            int openJsonObjects = 0;
            if (JsonToken.BEGIN_OBJECT == token) {
                String name;
                reader.beginObject();
                ++openJsonObjects;
                token = reader.peek();
                if (JsonToken.NAME == token && !("d".equals(name = reader.nextName()) ^ "results".equals(name))) {
                    throw new EntityProviderException(EntityProviderException.COMMON, name + " not expected, only d or results");
                }
                token = reader.peek();
                if (JsonToken.BEGIN_OBJECT == token) {
                    reader.beginObject();
                    ++openJsonObjects;
                } else if (JsonToken.BEGIN_ARRAY == token) {
                    throw new EntityProviderException(EntityProviderException.COMMON, "Array not expected");
                }
            }
            return openJsonObjects;
        }
        catch (IOException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    public static boolean endJson(JsonReader reader, int openJsonObjects) throws IOException, EntityProviderException {
        for (int closedJsonObjects = 0; closedJsonObjects < openJsonObjects; ++closedJsonObjects) {
            reader.endObject();
        }
        return reader.peek() == JsonToken.END_DOCUMENT;
    }
}

