/*
 * Decompiled with CFR 0.152.
 */
package opennlp.morfologik.builder;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Properties;
import morfologik.stemming.DictionaryMetadata;
import morfologik.stemming.EncoderType;
import morfologik.tools.DictCompile;

public class MorfologikDictionaryBuilder {
    public Path build(Path input, boolean overwrite, boolean validate, boolean acceptBom, boolean acceptCr, boolean ignoreEmpty) throws Exception {
        DictCompile compiler = new DictCompile(input, overwrite, validate, acceptBom, acceptCr, ignoreEmpty);
        compiler.call();
        Path metadataPath = DictionaryMetadata.getExpectedMetadataLocation((Path)input);
        return metadataPath.resolveSibling(metadataPath.getFileName().toString().replaceAll("\\.info$", ".dict"));
    }

    public Path build(Path input) throws Exception {
        return this.build(input, true, true, false, false, false);
    }

    Properties createProperties(Charset encoding, String separator, EncoderType encoderType) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("fsa.dict.separator", separator);
        properties.setProperty("fsa.dict.encoding", encoding.name());
        properties.setProperty("fsa.dict.encoder", encoderType.name());
        return properties;
    }
}

