/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.common.naming.TopicVersion;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations about brokers"})
public class CmdBrokers
extends CmdBase {
    public CmdBrokers(Supplier<PulsarAdmin> admin) {
        super("brokers", admin);
        this.addCommand("list", new List());
        this.addCommand("leader-broker", new LeaderBroker());
        this.addCommand("namespaces", new Namespaces());
        this.addCommand("update-dynamic-config", new UpdateConfigurationCmd());
        this.addCommand("delete-dynamic-config", new DeleteConfigurationCmd());
        this.addCommand("list-dynamic-config", new GetUpdatableConfigCmd());
        this.addCommand("get-all-dynamic-config", new GetAllConfigurationsCmd());
        this.addCommand("get-internal-config", new GetInternalConfigurationCmd());
        this.addCommand("get-runtime-config", new GetRuntimeConfigCmd());
        this.addCommand("healthcheck", new HealthcheckCmd());
        this.addCommand("backlog-quota-check", new BacklogQuotaCheckCmd());
        this.addCommand("version", new PulsarVersion());
        this.addCommand("shutdown", new ShutDownBrokerGracefully());
    }

    @CommandLine.Command(description={"List active brokers of the cluster"})
    private class List
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        private String cluster;

        private List() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.getAdmin().brokers().getActiveBrokers(this.cluster));
        }
    }

    @CommandLine.Command(description={"Get the information of the leader broker"})
    private class LeaderBroker
    extends CliCommand {
        private LeaderBroker() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.getAdmin().brokers().getLeaderBroker());
        }
    }

    @CommandLine.Command(description={"List namespaces owned by the broker"})
    private class Namespaces
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        private String cluster;
        @CommandLine.Option(names={"-u", "--url"}, description={"broker-url"}, required=true)
        private String brokerUrl;

        private Namespaces() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.getAdmin().brokers().getOwnedNamespaces(this.cluster, this.brokerUrl));
        }
    }

    @CommandLine.Command(description={"Update dynamic-serviceConfiguration of broker"})
    private class UpdateConfigurationCmd
    extends CliCommand {
        @CommandLine.Option(names={"-c", "--config"}, description={"service-configuration name"}, required=true)
        private String configName;
        @CommandLine.Option(names={"-v", "--value"}, description={"service-configuration value"}, required=true)
        private String configValue;

        private UpdateConfigurationCmd() {
        }

        @Override
        void run() throws Exception {
            CmdBrokers.this.getAdmin().brokers().updateDynamicConfiguration(this.configName, this.configValue);
        }
    }

    @CommandLine.Command(description={"Delete dynamic-serviceConfiguration of broker"})
    private class DeleteConfigurationCmd
    extends CliCommand {
        @CommandLine.Option(names={"-c", "--config"}, description={"service-configuration name"}, required=true)
        private String configName;

        private DeleteConfigurationCmd() {
        }

        @Override
        void run() throws Exception {
            CmdBrokers.this.getAdmin().brokers().deleteDynamicConfiguration(this.configName);
        }
    }

    @CommandLine.Command(description={"Get list of updatable configuration name"})
    private class GetUpdatableConfigCmd
    extends CliCommand {
        private GetUpdatableConfigCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.getAdmin().brokers().getDynamicConfigurationNames());
        }
    }

    @CommandLine.Command(description={"Get all overridden dynamic-configuration values"})
    private class GetAllConfigurationsCmd
    extends CliCommand {
        private GetAllConfigurationsCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.getAdmin().brokers().getAllDynamicConfigurations());
        }
    }

    @CommandLine.Command(description={"Get internal configuration information"})
    private class GetInternalConfigurationCmd
    extends CliCommand {
        private GetInternalConfigurationCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.getAdmin().brokers().getInternalConfigurationData());
        }
    }

    @CommandLine.Command(description={"Get runtime configuration values"})
    private class GetRuntimeConfigCmd
    extends CliCommand {
        private GetRuntimeConfigCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.getAdmin().brokers().getRuntimeConfigurations());
        }
    }

    @CommandLine.Command(description={"Run a health check against the broker"})
    private class HealthcheckCmd
    extends CliCommand {
        @CommandLine.Option(names={"-tv", "--topic-version"}, description={"topic version V1 is default"})
        private TopicVersion topicVersion;

        private HealthcheckCmd() {
        }

        @Override
        void run() throws Exception {
            CmdBrokers.this.getAdmin().brokers().healthcheck(this.topicVersion);
            System.out.println("ok");
        }
    }

    @CommandLine.Command(description={"Manually trigger backlogQuotaCheck"})
    private class BacklogQuotaCheckCmd
    extends CliCommand {
        private BacklogQuotaCheckCmd() {
        }

        @Override
        void run() throws Exception {
            CmdBrokers.this.getAdmin().brokers().backlogQuotaCheckAsync();
            System.out.println("ok");
        }
    }

    @CommandLine.Command(description={"Get the version of the currently connected broker"})
    private class PulsarVersion
    extends CliCommand {
        private PulsarVersion() {
        }

        @Override
        void run() throws Exception {
            System.out.println(CmdBrokers.this.getAdmin().brokers().getVersion());
        }
    }

    @CommandLine.Command(description={"Shutdown broker gracefully."})
    private class ShutDownBrokerGracefully
    extends CliCommand {
        @CommandLine.Option(names={"--max-concurrent-unload-per-sec", "-m"}, description={"Max concurrent unload per second, if the value absent(value=0) means no concurrent limitation"})
        private int maxConcurrentUnloadPerSec;
        @CommandLine.Option(names={"--forced-terminate-topic", "-f"}, description={"Force terminate all topics on Broker"})
        private boolean forcedTerminateTopic;

        private ShutDownBrokerGracefully() {
        }

        @Override
        void run() throws Exception {
            CmdBrokers.this.sync(() -> CmdBrokers.this.getAdmin().brokers().shutDownBrokerGracefully(this.maxConcurrentUnloadPerSec, this.forcedTerminateTopic));
            System.out.println("Successfully shutdown broker gracefully");
        }
    }
}

