/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import lombok.Generated;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.HandlerState;
import org.apache.pulsar.common.util.Backoff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHandler {
    private static final AtomicReferenceFieldUpdater<ConnectionHandler, ClientCnx> CLIENT_CNX_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ConnectionHandler.class, ClientCnx.class, "clientCnx");
    private volatile ClientCnx clientCnx = null;
    private volatile int maxMessageSize = 0x500000;
    protected final HandlerState state;
    protected final Backoff backoff;
    private static final AtomicLongFieldUpdater<ConnectionHandler> EPOCH_UPDATER = AtomicLongFieldUpdater.newUpdater(ConnectionHandler.class, "epoch");
    private volatile long epoch = -1L;
    protected volatile long lastConnectionClosedTimestamp = 0L;
    private final AtomicBoolean duringConnect = new AtomicBoolean(false);
    protected final int randomKeyForSelectConnection;
    private volatile Boolean useProxy;
    protected Connection connection;
    private static final Logger log = LoggerFactory.getLogger(ConnectionHandler.class);

    protected ConnectionHandler(HandlerState state, Backoff backoff, Connection connection) {
        this.state = state;
        this.randomKeyForSelectConnection = state.client.getCnxPool().genRandomKeyToSelectCon();
        this.connection = connection;
        this.backoff = backoff;
        CLIENT_CNX_UPDATER.set(this, null);
    }

    protected void grabCnx() {
        this.grabCnx(Optional.empty());
    }

    protected void grabCnx(Optional<URI> hostURI) {
        if (!this.duringConnect.compareAndSet(false, true)) {
            log.info("[{}] [{}] Skip grabbing the connection since there is a pending connection", (Object)this.state.topic, (Object)this.state.getHandlerName());
            return;
        }
        if (CLIENT_CNX_UPDATER.get(this) != null) {
            log.warn("[{}] [{}] Client cnx already set, ignoring reconnection request", (Object)this.state.topic, (Object)this.state.getHandlerName());
            return;
        }
        if (!this.isValidStateForReconnection()) {
            log.info("[{}] [{}] Ignoring reconnection request (state: {})", new Object[]{this.state.topic, this.state.getHandlerName(), this.state.getState()});
            return;
        }
        try {
            CompletionStage<ClientCnx> cnxFuture;
            if (hostURI.isPresent() && this.useProxy != null) {
                URI uri = hostURI.get();
                InetSocketAddress address = InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort());
                cnxFuture = this.useProxy.booleanValue() ? this.state.client.getProxyConnection(address, this.randomKeyForSelectConnection) : this.state.client.getConnection(address, address, this.randomKeyForSelectConnection);
            } else if (this.state.redirectedClusterURI != null) {
                if (this.state.topic == null) {
                    InetSocketAddress address = InetSocketAddress.createUnresolved(this.state.redirectedClusterURI.getHost(), this.state.redirectedClusterURI.getPort());
                    cnxFuture = this.state.client.getConnection(address, address, this.randomKeyForSelectConnection);
                } else {
                    cnxFuture = this.state.client.getConnection(this.state.topic, this.state.redirectedClusterURI.toString());
                }
            } else {
                cnxFuture = this.state.topic == null ? this.state.client.getConnectionToServiceUrl() : this.state.client.getConnection(this.state.topic, this.randomKeyForSelectConnection).thenApply(connectionResult -> {
                    this.useProxy = (Boolean)connectionResult.getRight();
                    return (ClientCnx)((Object)((Object)connectionResult.getLeft()));
                });
            }
            ((CompletableFuture)((CompletableFuture)cnxFuture.thenCompose(cnx -> this.connection.connectionOpened((ClientCnx)((Object)cnx)))).thenAccept(__ -> this.duringConnect.set(false))).exceptionally(this::handleConnectionError);
        }
        catch (Throwable t) {
            log.warn("[{}] [{}] Exception thrown while getting connection: ", new Object[]{this.state.topic, this.state.getHandlerName(), t});
            this.reconnectLater(t);
        }
    }

    private Void handleConnectionError(Throwable exception) {
        boolean toRetry = true;
        try {
            log.warn("[{}] [{}] Error connecting to broker: {}", new Object[]{this.state.topic, this.state.getHandlerName(), exception.getMessage()});
            toRetry = exception instanceof PulsarClientException ? this.connection.connectionFailed((PulsarClientException)exception) : (exception.getCause() instanceof PulsarClientException ? this.connection.connectionFailed((PulsarClientException)exception.getCause()) : this.connection.connectionFailed(new PulsarClientException(exception)));
        }
        catch (Throwable throwable) {
            log.error("[{}] [{}] Unexpected exception after the connection", new Object[]{this.state.topic, this.state.getHandlerName(), throwable});
        }
        if (toRetry) {
            this.reconnectLater(exception);
        }
        return null;
    }

    void reconnectLater(Throwable exception) {
        CLIENT_CNX_UPDATER.set(this, null);
        this.duringConnect.set(false);
        if (!this.isValidStateForReconnection()) {
            log.info("[{}] [{}] Ignoring reconnection request (state: {})", new Object[]{this.state.topic, this.state.getHandlerName(), this.state.getState()});
            return;
        }
        long delayMs = this.backoff.next();
        log.warn("[{}] [{}] Could not get connection to broker: {} -- Will try again in {} s", new Object[]{this.state.topic, this.state.getHandlerName(), exception.getMessage(), (double)delayMs / 1000.0});
        if (this.state.changeToConnecting()) {
            this.state.client.timer().newTimeout(timeout -> {
                log.info("[{}] [{}] Reconnecting after connection was closed", (Object)this.state.topic, (Object)this.state.getHandlerName());
                this.grabCnx();
            }, delayMs, TimeUnit.MILLISECONDS);
        } else {
            log.info("[{}] [{}] Ignoring reconnection request (state: {})", new Object[]{this.state.topic, this.state.getHandlerName(), this.state.getState()});
        }
    }

    public void connectionClosed(ClientCnx cnx) {
        this.connectionClosed(cnx, Optional.empty(), Optional.empty());
    }

    public void connectionClosed(ClientCnx cnx, Optional<Long> initialConnectionDelayMs, Optional<URI> hostUrl) {
        this.lastConnectionClosedTimestamp = System.currentTimeMillis();
        this.duringConnect.set(false);
        this.state.client.getCnxPool().releaseConnection(cnx);
        if (CLIENT_CNX_UPDATER.compareAndSet(this, cnx, null)) {
            if (!this.state.changeToConnecting()) {
                log.info("[{}] [{}] Ignoring reconnection request (state: {})", new Object[]{this.state.topic, this.state.getHandlerName(), this.state.getState()});
                return;
            }
            long delayMs = initialConnectionDelayMs.orElse(this.backoff.next());
            log.info("[{}] [{}] Closed connection {} -- Will try again in {} s, hostUrl: {}", new Object[]{this.state.topic, this.state.getHandlerName(), cnx.channel(), (double)delayMs / 1000.0, hostUrl.orElse(null)});
            this.state.client.timer().newTimeout(timeout -> {
                log.info("[{}] [{}] Reconnecting after {} s timeout, hostUrl: {}", new Object[]{this.state.topic, this.state.getHandlerName(), (double)delayMs / 1000.0, hostUrl.orElse(null)});
                this.grabCnx(hostUrl);
            }, delayMs, TimeUnit.MILLISECONDS);
        }
    }

    protected void resetBackoff() {
        this.backoff.reset();
    }

    public ClientCnx cnx() {
        return CLIENT_CNX_UPDATER.get(this);
    }

    protected void setClientCnx(ClientCnx clientCnx) {
        CLIENT_CNX_UPDATER.set(this, clientCnx);
    }

    protected long switchClientCnx(ClientCnx clientCnx) {
        this.setClientCnx(clientCnx);
        return EPOCH_UPDATER.incrementAndGet(this);
    }

    @VisibleForTesting
    public boolean isValidStateForReconnection() {
        HandlerState.State state = this.state.getState();
        switch (state) {
            case Uninitialized: 
            case Connecting: 
            case RegisteringSchema: 
            case Ready: {
                return true;
            }
            case Closing: 
            case Closed: 
            case Failed: 
            case ProducerFenced: 
            case Terminated: {
                return false;
            }
        }
        return false;
    }

    public long getEpoch() {
        return this.epoch;
    }

    @Generated
    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @Generated
    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    static interface Connection {
        public CompletableFuture<Void> connectionOpened(ClientCnx var1);

        default public boolean connectionFailed(PulsarClientException e) {
            return true;
        }
    }
}

