/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.qpid.server.management.plugin.ManagementException;

public class ConverterHelper {
    private static final Pattern CONTEXT_VARIABLE_PATTERN = Pattern.compile("\\$\\{[\\w+.\\-:]+}");

    private ConverterHelper() {
    }

    public static long toLong(Object attributeValue) {
        long value;
        if (attributeValue instanceof Number) {
            value = ((Number)attributeValue).longValue();
        } else if (attributeValue instanceof String) {
            try {
                value = Long.parseLong((String)attributeValue);
            }
            catch (Exception e) {
                value = 0L;
            }
        } else {
            value = 0L;
        }
        return value;
    }

    public static boolean toBoolean(Object attributeValue) {
        boolean value;
        if (attributeValue instanceof Boolean) {
            value = (Boolean)attributeValue;
        } else {
            if (attributeValue instanceof String) {
                return Boolean.parseBoolean((String)attributeValue);
            }
            value = false;
        }
        return value;
    }

    public static int toInt(Object value) {
        int result;
        if (value instanceof Number) {
            result = ((Number)value).intValue();
        } else if (value instanceof String) {
            try {
                result = Integer.parseInt(String.valueOf(value));
            }
            catch (RuntimeException e) {
                result = 0;
            }
        } else {
            result = 0;
        }
        return result;
    }

    public static boolean isContextVariable(Object value) {
        return value != null && CONTEXT_VARIABLE_PATTERN.matcher(String.valueOf(value)).matches();
    }

    public static String encode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw ManagementException.createInternalServerErrorManagementException("UTF8 encoding is unsupported", e);
        }
    }

    public static String getParameter(String name, Map<String, List<String>> parameters) {
        List<String> values = parameters.get(name);
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    public static int getIntParameterFromRequest(Map<String, List<String>> parameters, String parameterName, int defaultValue) {
        int intValue = defaultValue;
        String stringValue = ConverterHelper.getParameter(parameterName, parameters);
        if (stringValue != null) {
            try {
                intValue = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return intValue;
    }
}

