/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseEntry;

public class BooleanBinding
extends TupleBinding<Boolean> {
    private static final int BOOLEAN_SIZE = 1;

    @Override
    public Boolean entryToObject(TupleInput input) {
        return input.readBoolean();
    }

    @Override
    public void objectToEntry(Boolean object, TupleOutput output) {
        output.writeBoolean(object);
    }

    @Override
    protected TupleOutput getTupleOutput(Boolean object) {
        return BooleanBinding.sizedOutput();
    }

    public static boolean entryToBoolean(DatabaseEntry entry) {
        return BooleanBinding.entryToInput(entry).readBoolean();
    }

    public static void booleanToEntry(boolean val, DatabaseEntry entry) {
        BooleanBinding.outputToEntry(BooleanBinding.sizedOutput().writeBoolean(val), entry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[1]);
    }
}

