/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.txn;

import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.rep.ReplicaConsistencyException;
import com.sleepycat.je.rep.ReplicaWriteException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.txn.ReadonlyTxn;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.ThreadLocker;

public class ReplicaThreadLocker
extends ThreadLocker {
    private final RepImpl repImpl;

    public ReplicaThreadLocker(RepImpl repImpl) {
        super(repImpl);
        this.repImpl = repImpl;
    }

    @Override
    public ThreadLocker newEmptyThreadLockerClone() {
        return new ReplicaThreadLocker(this.repImpl);
    }

    @Override
    public LockResult lockInternal(long lsn, LockType lockType, boolean noWait, boolean jumpAheadOfWaiters, DatabaseImpl database) {
        if (lockType.isWriteLock() && !database.allowReplicaWrite()) {
            this.disallowReplicaWrite();
        }
        return super.lockInternal(lsn, lockType, noWait, jumpAheadOfWaiters, database);
    }

    @Override
    public void preLogWithoutLock(DatabaseImpl database) {
        if (!database.allowReplicaWrite()) {
            this.disallowReplicaWrite();
        }
        super.preLogWithoutLock(database);
    }

    @Override
    public void disallowReplicaWrite() {
        throw new ReplicaWriteException(this, this.repImpl.getStateChangeEvent());
    }

    @Override
    public void openCursorHook(DatabaseImpl dbImpl) throws ReplicaConsistencyException {
        if (!dbImpl.isReplicated()) {
            return;
        }
        ReadonlyTxn.checkConsistency(this.repImpl, this.repImpl.getDefaultConsistencyPolicy());
    }
}

