# Limitations

## Use with the Legacy Loader API

The dgrid package was designed primarily with AMD in mind; as such, it has been
tested primarily using the `require` and `define` APIs available in Dojo 1.7+.
Use with the legacy `dojo.require` API is discouraged, and not officially supported.

## Reuse of Column Definitions

Reusing a single column definition object between multiple grids (e.g.
`var cols = {...}, gridA = new Grid({ columns: cols }), gridB = new Grid({ columns: cols })`)
is *not* supported, and will not function properly. Always create a fresh `columns`
object for every grid you instantiate.

If multiple grids in a single page are likely to use the same column structure,
in order to avoid code repetition, you can create a function which returns
the structure, but creates it every time it is called.  For example:

```js
function getColumns () {
    return {
        col1: { label: 'Column 1', editor: 'text', editOn: 'dblclick' },
        col2: { label: 'Column 2', sortable: false },
        // ...
    };
}

var grid = new Grid({
    columns: getColumns(),
    // ...
}, 'grid');
var secondGrid = new Grid({
    columns: getColumns(),
    // ...
}, 'secondGrid');
```

## Column Definitions: Coexistence of formatter and renderCell

The default `renderCell` logic is specifically written in such a way as to honor any
`formatter` that is defined on the column definition.

If a custom `renderCell` function is specified, however, it will override the
default logic which is responsible for honoring `formatter`, and thus the custom
`renderCell` logic will take precedence.

## Tree: Duplicate items at multiple levels not supported

In rare cases it may be possible for hierarchical store structures to contain
references to the same item under multiple distinct parents.  dgrid 0.3 had partial
support for this since version 0.3.2, but it was never complete support in that
some operations became limited to the top level.  Fully supporting this would
require adding complexity to both implementation and public APIs, so instead
we have elected to remove it as of dgrid 0.4.  All store items should always contain
unique IDs - if necessary, unique IDs can be generated by composing several
other fields together (e.g. parent and child IDs).
