/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.metadata;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.config.ConfigRocksDBStorage;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;
import org.rocksdb.RocksIterator;

public class RocksDBConfigToJsonCommand
implements SubCommand {
    private static final String TOPICS_JSON_CONFIG = "topics";
    private static final String SUBSCRIPTION_GROUP_JSON_CONFIG = "subscriptionGroups";
    private static final String CONSUMER_OFFSETS_JSON_CONFIG = "consumerOffsets";

    @Override
    public String commandName() {
        return "rocksDBConfigToJson";
    }

    @Override
    public String commandDesc() {
        return "Convert RocksDB kv config (topics/subscriptionGroups/consumerOffsets) to json";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option pathOption = new Option("p", "configPath", true, "Absolute path to the metadata config directory");
        pathOption.setRequired(true);
        options.addOption(pathOption);
        Option configTypeOption = new Option("t", "configType", true, "Name of kv config, e.g. topics/subscriptionGroups/consumerOffsets");
        configTypeOption.setRequired(true);
        options.addOption(configTypeOption);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        String path = commandLine.getOptionValue("configPath").trim();
        if (StringUtils.isEmpty((CharSequence)path) || !new File(path).exists()) {
            System.out.print("Rocksdb path is invalid.\n");
            return;
        }
        String configType = commandLine.getOptionValue("configType").trim();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + configType;
        if (CONSUMER_OFFSETS_JSON_CONFIG.equalsIgnoreCase(configType)) {
            this.printConsumerOffsets(path);
            return;
        }
        ConfigRocksDBStorage configRocksDBStorage = new ConfigRocksDBStorage(path, true);
        configRocksDBStorage.start();
        RocksIterator iterator = configRocksDBStorage.iterator();
        try {
            HashMap<String, JSONObject> configMap = new HashMap<String, JSONObject>();
            JSONObject configTable = new JSONObject();
            iterator.seekToFirst();
            while (iterator.isValid()) {
                byte[] key = iterator.key();
                byte[] value = iterator.value();
                String name = new String(key, DataConverter.CHARSET_UTF8);
                String config = new String(value, DataConverter.CHARSET_UTF8);
                JSONObject jsonObject = JSONObject.parseObject((String)config);
                configTable.put(name, (Object)jsonObject);
                iterator.next();
            }
            byte[] kvDataVersion = configRocksDBStorage.getKvDataVersion();
            if (kvDataVersion != null) {
                configMap.put("dataVersion", JSONObject.parseObject((String)new String(kvDataVersion, DataConverter.CHARSET_UTF8)));
            }
            if (TOPICS_JSON_CONFIG.equalsIgnoreCase(configType)) {
                configMap.put("topicConfigTable", configTable);
            }
            if (SUBSCRIPTION_GROUP_JSON_CONFIG.equalsIgnoreCase(configType)) {
                configMap.put("subscriptionGroupTable", configTable);
            }
            System.out.print(JSONObject.toJSONString(configMap, (boolean)true) + "\n");
        }
        catch (Exception e) {
            System.out.print("Error occurred while converting RocksDB kv config to json, configType=" + configType + ", " + e.getMessage() + "\n");
        }
        finally {
            configRocksDBStorage.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printConsumerOffsets(String path) {
        ConfigRocksDBStorage configRocksDBStorage = new ConfigRocksDBStorage(path, true);
        configRocksDBStorage.start();
        RocksIterator iterator = configRocksDBStorage.iterator();
        try {
            HashMap<String, JSONObject> configMap = new HashMap<String, JSONObject>();
            JSONObject configTable = new JSONObject();
            iterator.seekToFirst();
            while (iterator.isValid()) {
                byte[] key = iterator.key();
                byte[] value = iterator.value();
                String name = new String(key, DataConverter.CHARSET_UTF8);
                String config = new String(value, DataConverter.CHARSET_UTF8);
                RocksDBOffsetSerializeWrapper jsonObject = (RocksDBOffsetSerializeWrapper)JSONObject.parseObject((String)config, RocksDBOffsetSerializeWrapper.class);
                configTable.put(name, jsonObject.getOffsetTable());
                iterator.next();
            }
            configMap.put("offsetTable", configTable);
            System.out.print(JSONObject.toJSONString(configMap, (boolean)true) + "\n");
        }
        catch (Exception e) {
            System.out.print("Error occurred while converting RocksDB kv config to json, configType=consumerOffsets, " + e.getMessage() + "\n");
        }
        finally {
            configRocksDBStorage.shutdown();
        }
    }

    static class RocksDBOffsetSerializeWrapper {
        private ConcurrentMap<Integer, Long> offsetTable = new ConcurrentHashMap<Integer, Long>(16);

        RocksDBOffsetSerializeWrapper() {
        }

        public ConcurrentMap<Integer, Long> getOffsetTable() {
            return this.offsetTable;
        }

        public void setOffsetTable(ConcurrentMap<Integer, Long> offsetTable) {
            this.offsetTable = offsetTable;
        }
    }
}

