/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.portrayal;

import java.util.List;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.internal.shared.Numerics;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Matrix;

final class CanvasExtent
extends GridExtent {
    private static final long serialVersionUID = 195789629521760720L;
    private final double[] pointOfInterest;

    private CanvasExtent(DimensionNameType[] axisTypes, long[] lower, long[] upper, double[] pointOfInterest) {
        super(axisTypes, lower, upper, false);
        this.pointOfInterest = pointOfInterest;
    }

    public double[] getPointOfInterest(PixelInCell anchor) {
        return (double[])this.pointOfInterest.clone();
    }

    static GridExtent create(GeneralEnvelope bounds, DirectPosition poi, DimensionNameType[] axisTypes, int agmDim) {
        long[] lower = new long[agmDim];
        long[] upper = new long[agmDim];
        int i = bounds.getDimension();
        while (--i >= 0) {
            lower[i] = (long)Math.floor(bounds.getLower(i));
            upper[i] = (long)Math.ceil(bounds.getUpper(i));
        }
        if (poi == null) {
            return new GridExtent(axisTypes, lower, upper, false);
        }
        double[] c = new double[agmDim];
        int i2 = poi.getDimension();
        while (--i2 >= 0) {
            c[i2] = poi.getOrdinate(i2);
        }
        return new CanvasExtent(axisTypes, lower, upper, c);
    }

    static long findSupplementalDimensions(CoordinateReferenceSystem crs, Matrix derivative, List<CoordinateReferenceSystem> addTo) {
        int srcDim = Math.min(derivative.getNumCol(), 64);
        int dstDim = derivative.getNumRow();
        long mask = 0L;
        block0: for (int j = 0; j < dstDim; ++j) {
            for (int i = 0; i < srcDim; ++i) {
                if (derivative.getElement(j, i) == 0.0) continue;
                mask |= 1L << i;
                continue block0;
            }
        }
        mask ^= Numerics.bitmask((int)srcDim) - 1L;
        long supplementalDimensions = 0L;
        while (mask != 0L) {
            int lower = Long.numberOfTrailingZeros(mask);
            int upper = Long.numberOfTrailingZeros(mask + (1L << lower));
            long clear = -(1L << upper);
            CoordinateReferenceSystem component = CRS.getComponentAt((CoordinateReferenceSystem)crs, (int)lower, (int)upper);
            if (component != null) {
                addTo.add(component);
                supplementalDimensions |= mask & (clear ^ 0xFFFFFFFFFFFFFFFFL);
            }
            mask &= clear;
        }
        return supplementalDimensions;
    }

    static LinearTransform createGridToCRS(Matrix displayToObjective, DirectPosition pointOfInterest, long supplementalDimensions) {
        int j;
        int srcDim = displayToObjective.getNumCol();
        int tgtDim = displayToObjective.getNumRow();
        int agmDim = tgtDim + Long.bitCount(supplementalDimensions);
        MatrixSIS gridToCRS = Matrices.createZero((int)(agmDim + 1), (int)(agmDim + 1));
        for (j = 0; j < tgtDim; ++j) {
            for (int i = 0; i < srcDim; ++i) {
                gridToCRS.setElement(j, i, displayToObjective.getElement(j, i));
            }
        }
        while (supplementalDimensions != 0L) {
            int n = Long.numberOfTrailingZeros(supplementalDimensions);
            gridToCRS.setElement(j, j, Double.NaN);
            gridToCRS.setElement(j++, agmDim, pointOfInterest.getOrdinate(n));
            supplementalDimensions &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return MathTransforms.linear((Matrix)gridToCRS);
    }

    static DimensionNameType[] suggestAxisTypes(CoordinateReferenceSystem crs, int displayDimension) {
        CoordinateSystem cs;
        if (crs != null && (cs = crs.getCoordinateSystem()) != null) {
            int i = cs.getDimension();
            DimensionNameType[] axisTypes = new DimensionNameType[i];
            while (--i >= displayDimension) {
                AxisDirection dir = AxisDirections.absolute((AxisDirection)cs.getAxis(i).getDirection());
                if (dir == AxisDirection.FUTURE) {
                    axisTypes[i] = DimensionNameType.TIME;
                    continue;
                }
                if (dir != AxisDirection.UP) continue;
                axisTypes[i] = DimensionNameType.VERTICAL;
            }
            return axisTypes;
        }
        return new DimensionNameType[displayDimension];
    }
}

