/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.lang.reflect.Array;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.metadata.sql.internal.shared.SQLBuilder;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.Relation;
import org.apache.sis.storage.sql.feature.Resources;
import org.apache.sis.storage.sql.feature.Table;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.WeakValueHashMap;

final class FeatureAdapter {
    private static final FeatureAdapter[] EMPTY = new FeatureAdapter[0];
    private final DefaultFeatureType featureType;
    private final Column[] attributes;
    final String[] associationNames;
    final String deferredAssociation;
    final FeatureAdapter[] dependencies;
    final int importCount;
    private final int[][] foreignerKeyIndices;
    final WeakValueHashMap<?, Object> instances;
    private final Class<?> keyComponentClass;
    final String sql;

    FeatureAdapter(Table table, DatabaseMetaData metadata) throws SQLException, InternalDataStoreException {
        this(table, metadata, new ArrayList<Relation>(), null);
    }

    private FeatureAdapter(Table table, DatabaseMetaData metadata, List<Relation> following, Relation noFollow) throws SQLException, InternalDataStoreException {
        this.featureType = table.featureType;
        this.attributes = table.attributes;
        this.keyComponentClass = table.primaryKey != null ? table.primaryKey.valueClass.getComponentType() : null;
        HashMap<String, Integer> columnIndices = new HashMap<String, Integer>();
        SQLBuilder sql = new SQLBuilder(table.database);
        sql.setCatalogAndSchema(metadata.getConnection());
        sql.append("SELECT ");
        for (Column column : this.attributes) {
            String function = null;
            if (column.getGeometryType().isPresent()) {
                function = table.database.getGeometryEncodingFunction(column);
            }
            FeatureAdapter.appendColumn(sql, table.database, function, column.label, columnIndices);
        }
        int count = table.importedKeys.length + table.exportedKeys.length;
        if (count == 0) {
            this.importCount = 0;
            this.dependencies = EMPTY;
            this.associationNames = null;
            this.foreignerKeyIndices = null;
            this.deferredAssociation = null;
        } else {
            String deferredAssociation = null;
            Object[] dependencies = new FeatureAdapter[count];
            Object[] associationNames = new String[count];
            int[][] foreignerKeyIndices = new int[count][];
            count = 0;
            for (Relation dependency : table.importedKeys) {
                if (dependency.excluded) continue;
                if (dependency != noFollow) {
                    dependency.startFollowing(following);
                    associationNames[count] = dependency.getPropertyName();
                    foreignerKeyIndices[count] = FeatureAdapter.getColumnIndices(sql, dependency, columnIndices);
                    dependencies[count] = new FeatureAdapter(dependency.getSearchTable(), metadata, following, noFollow);
                    dependency.endFollowing(following);
                    ++count;
                    continue;
                }
                deferredAssociation = dependency.getPropertyName();
            }
            this.importCount = count;
            for (Relation dependency : table.exportedKeys) {
                if (dependency.excluded) continue;
                dependency.startFollowing(following);
                Table foreigner = dependency.getSearchTable();
                Relation inverse = foreigner.getInverseOf(dependency, table.name);
                associationNames[count] = dependency.getPropertyName();
                foreignerKeyIndices[count] = FeatureAdapter.getColumnIndices(sql, dependency, columnIndices);
                dependencies[count] = new FeatureAdapter(foreigner, metadata, following, inverse);
                dependency.endFollowing(following);
                ++count;
            }
            if (count != 0) {
                this.dependencies = (FeatureAdapter[])ArraysExt.resize((Object[])dependencies, (int)count);
                this.associationNames = (String[])ArraysExt.resize((Object[])associationNames, (int)count);
                this.foreignerKeyIndices = (int[][])ArraysExt.resize((Object[])foreignerKeyIndices, (int)count);
            } else {
                this.dependencies = EMPTY;
                this.associationNames = null;
                this.foreignerKeyIndices = null;
            }
            this.deferredAssociation = deferredAssociation;
        }
        table.appendFromClause(sql);
        if (following.isEmpty()) {
            this.instances = null;
        } else {
            Relation componentOf = following.get(following.size() - 1);
            String separator = " WHERE ";
            for (String primaryKey : componentOf.getSearchColumns()) {
                sql.append(separator).appendIdentifier(primaryKey).append("=?");
                separator = " AND ";
            }
            this.instances = componentOf.useFullKey() ? table.instanceForPrimaryKeys() : new WeakValueHashMap(Object.class);
        }
        this.sql = sql.toString();
    }

    private static int appendColumn(SQLBuilder sql, Database<?> database, String function, String column, Map<String, Integer> columnIndices) throws InternalDataStoreException {
        int columnCount = columnIndices.size();
        if (columnCount != 0) {
            sql.append(", ");
        }
        if (function != null) {
            sql.appendIdentifier(database.catalogOfSpatialTables, database.schemaOfSpatialTables, function, false).append('(');
        }
        sql.appendIdentifier(column);
        if (function != null) {
            sql.append(')');
        }
        if (columnIndices.put(column, ++columnCount) == null) {
            return columnCount;
        }
        throw new InternalDataStoreException(Resources.format((short)5, column));
    }

    private static int[] getColumnIndices(SQLBuilder sql, Relation dependency, Map<String, Integer> columnIndices) throws InternalDataStoreException {
        Collection<String> columns = dependency.getOwnerColumns();
        int i = 0;
        int[] indices = new int[columns.size()];
        for (String column : columns) {
            Integer pos = columnIndices.get(column);
            indices[i++] = pos != null ? pos : FeatureAdapter.appendColumn(sql, null, null, column, columnIndices);
        }
        return indices;
    }

    final AbstractFeature createFeature(InfoStatements stmts, ResultSet result) throws Exception {
        AbstractFeature feature = this.featureType.newInstance();
        for (int i = 0; i < this.attributes.length; ++i) {
            Column column = this.attributes[i];
            Object value = column.valueGetter.getValue(stmts, result, i + 1);
            if (value == null) continue;
            feature.setPropertyValue(column.getPropertyName(), value);
        }
        return feature;
    }

    final Object getCacheKey(ResultSet result, int dependency) throws SQLException {
        int[] columnIndices = this.foreignerKeyIndices[dependency];
        int n = columnIndices.length;
        Object keys = n > 1 ? Array.newInstance(this.dependencies[dependency].keyComponentClass, n) : null;
        Object key = null;
        for (int p = 0; p < n; ++p) {
            key = result.getObject(columnIndices[p]);
            if (keys != null) {
                Array.set(keys, p, key);
            }
            if (key != null) continue;
            return null;
        }
        return keys != null ? keys : key;
    }

    final void setForeignerKeys(ResultSet source, PreparedStatement target, int dependency) throws SQLException {
        int[] columnIndices = this.foreignerKeyIndices[dependency];
        int p = 0;
        while (p < columnIndices.length) {
            Object k = source.getObject(columnIndices[p]);
            target.setObject(++p, k);
        }
    }
}

