/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.sis.storage.sql.SQLStoreProvider;
import org.apache.sis.storage.sql.feature.Analyzer;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.internal.shared.Strings;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;

public class TableReference {
    public final String catalog;
    public final String schema;
    public final String table;
    final String freeText;

    TableReference(String catalog, String schema, String table, String freeText) {
        this.catalog = catalog;
        this.schema = schema;
        this.table = table;
        this.freeText = Strings.trimOrNull((String)freeText);
    }

    TableReference(GenericName name, String comments) {
        String[] names = TableReference.splitName(name);
        this.catalog = names[2];
        this.schema = names[1];
        this.table = names[0];
        this.freeText = Strings.trimOrNull((String)comments);
    }

    static String[] splitName(GenericName name) {
        Object[] parts = (String[])name.getParsedNames().stream().map(LocalName::toString).toArray(String[]::new);
        ArraysExt.reverse((Object[])parts);
        return (String[])ArraysExt.resize((Object[])parts, (int)3);
    }

    final GenericName getName(Analyzer analyzer) {
        return analyzer.nameFactory.createLocalName(analyzer.namespace(Strings.trimOrNull((String)this.catalog), Strings.trimOrNull((String)this.schema)), (CharSequence)this.table);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof TableReference) {
            TableReference other = (TableReference)obj;
            return this.table.equals(other.table) && Objects.equals(this.schema, other.schema) && Objects.equals(this.catalog, other.catalog);
        }
        return false;
    }

    public final int hashCode() {
        return this.table.hashCode() + 31 * Objects.hashCode(this.schema) + 37 * Objects.hashCode(this.catalog);
    }

    static TreeTable.Node newChild(TreeTable.Node parent, String name) {
        TreeTable.Node child = parent.newChild();
        child.setValue(TableColumn.NAME, (Object)name);
        return child;
    }

    static String toString(Object owner, Consumer<TreeTable.Node> appender) {
        DefaultTreeTable table = new DefaultTreeTable(new TableColumn[]{TableColumn.NAME});
        TreeTable.Node root = table.getRoot();
        root.setValue(TableColumn.NAME, (Object)owner.getClass().getSimpleName());
        appender.accept(root);
        return table.toString();
    }

    public String toString() {
        return SQLStoreProvider.createTableName(Strings.trimOrNull((String)this.catalog), Strings.trimOrNull((String)this.schema), this.table).toString();
    }
}

