/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.stream;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.sis.filter.base.WarningEvent;
import org.apache.sis.util.stream.BaseStreamWrapper;

public abstract class StreamWrapper<T>
extends BaseStreamWrapper<T, Stream<T>>
implements Stream<T> {
    Stream<T> source;
    public Consumer<WarningEvent> listener;

    StreamWrapper() {
    }

    protected StreamWrapper(Stream<T> source) {
        super(source);
        this.source = source;
    }

    @Override
    protected final Stream<T> source() {
        if (this.source != null) {
            return this.source;
        }
        throw this.inactive();
    }

    protected final Stream<T> delegate() {
        BaseStream s = this.source();
        this.source = null;
        return s;
    }

    private Stream<T> update(Stream<T> result) {
        if (this.source == null) {
            return result;
        }
        this.source = result;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <V> V execute(Supplier<V> action) {
        if (this.listener == null) {
            return action.get();
        }
        ThreadLocal context = WarningEvent.LISTENER;
        Consumer old = (Consumer)context.get();
        try {
            context.set(this.listener);
            V v = action.get();
            return v;
        }
        finally {
            context.set(old);
        }
    }

    @Override
    public Stream<T> parallel() {
        return this.execute(() -> this.update((Stream)this.source().parallel()));
    }

    @Override
    public Stream<T> sequential() {
        return this.execute(() -> this.update((Stream)this.source().sequential()));
    }

    @Override
    public Stream<T> unordered() {
        return this.execute(() -> this.update((Stream)this.source().unordered()));
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        return this.execute(() -> this.update(this.source().filter(predicate)));
    }

    @Override
    public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
        return this.execute(() -> this.delegate().map(mapper));
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.execute(() -> this.delegate().mapToInt(mapper));
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.execute(() -> this.delegate().mapToLong(mapper));
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.execute(() -> this.delegate().mapToDouble(mapper));
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return this.execute(() -> this.delegate().flatMap(mapper));
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.execute(() -> this.delegate().flatMapToInt(mapper));
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.execute(() -> this.delegate().flatMapToLong(mapper));
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.execute(() -> this.delegate().flatMapToDouble(mapper));
    }

    @Override
    public Stream<T> distinct() {
        return this.execute(() -> this.update(this.source().distinct()));
    }

    @Override
    public Stream<T> sorted() {
        return this.execute(() -> this.update(this.source().sorted()));
    }

    @Override
    public Stream<T> sorted(Comparator<? super T> comparator) {
        return this.execute(() -> this.update(this.source().sorted(comparator)));
    }

    @Override
    public Stream<T> peek(Consumer<? super T> action) {
        return this.execute(() -> this.update(this.source().peek(action)));
    }

    @Override
    public Stream<T> limit(long maxSize) {
        return this.execute(() -> this.update(this.source().limit(maxSize)));
    }

    @Override
    public Stream<T> skip(long n) {
        return this.execute(() -> this.update(this.source().skip(n)));
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.execute(() -> {
            this.source().forEach(action);
            return null;
        });
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.execute(() -> {
            this.source().forEachOrdered(action);
            return null;
        });
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return (T)this.execute(() -> this.source().reduce(identity, accumulator));
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.execute(() -> this.source().reduce(accumulator));
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return (U)this.execute(() -> this.source().reduce(identity, accumulator, combiner));
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return (R)this.execute(() -> this.source().collect(supplier, accumulator, combiner));
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return (R)this.execute(() -> this.source().collect(collector));
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.execute(() -> this.source().min(comparator));
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.execute(() -> this.source().max(comparator));
    }

    @Override
    public long count() {
        return this.execute(() -> this.source().count());
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.execute(() -> this.source().anyMatch(predicate));
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.execute(() -> this.source().allMatch(predicate));
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.execute(() -> this.source().noneMatch(predicate));
    }

    @Override
    public Optional<T> findFirst() {
        return this.execute(() -> this.source().findFirst());
    }

    @Override
    public Optional<T> findAny() {
        return this.execute(() -> this.source().findAny());
    }

    @Override
    public Iterator<T> iterator() {
        return this.execute(() -> this.source().iterator());
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.execute(() -> this.source().spliterator());
    }

    @Override
    public Object[] toArray() {
        return this.execute(() -> this.source().toArray());
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.execute(() -> this.source().toArray(generator));
    }

    @Override
    public Stream<T> onClose(Runnable closeHandler) {
        return this.execute(() -> this.update((Stream)this.source().onClose(closeHandler)));
    }
}

