/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.xing.oauth.impl;

import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.auth.xing.api.XingUser;
import org.apache.sling.auth.xing.oauth.XingOauthUserManager;
import org.apache.sling.auth.xing.oauth.XingOauthUtil;
import org.apache.sling.auth.xing.oauth.impl.XingOauthAuthenticationPlugin;
import org.apache.sling.jcr.jackrabbit.server.security.AuthenticationPlugin;
import org.apache.sling.jcr.jackrabbit.server.security.LoginModulePlugin;
import org.scribe.model.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Apache Sling Authentication XING OAuth \u201cLogin Module Plugin\u201d", description="Login Module Plugin for Sling Authentication XING OAuth", immediate=true, metatype=true)
@Service
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"Login Module Plugin for Sling Authentication XING OAuth"}), @Property(name="service.ranking", intValue={0}, propertyPrivate=false)})
public class XingOauthLoginModulePlugin
implements LoginModulePlugin {
    @Reference
    private XingOauthUserManager xingOauthUserManager;
    private final Logger logger = LoggerFactory.getLogger(XingOauthLoginModulePlugin.class);

    public boolean canHandle(Credentials credentials) {
        this.logger.debug("canHandle({})", (Object)credentials);
        Token accessToken = XingOauthUtil.getAccessToken(credentials);
        XingUser xingUser = XingOauthUtil.getXingUser(credentials);
        this.logger.debug("access token: {}, xing user: {}", (Object)accessToken, (Object)xingUser);
        return accessToken != null && xingUser != null;
    }

    public void doInit(CallbackHandler callbackHandler, Session session, Map map) throws LoginException {
        this.logger.debug("doInit({}, {}, {})", new Object[]{callbackHandler, session, map});
    }

    public Principal getPrincipal(Credentials credentials) {
        this.logger.debug("getPrincipal({})", (Object)credentials);
        try {
            User user = this.xingOauthUserManager.getUser(credentials);
            if (user == null && this.xingOauthUserManager.autoCreate()) {
                user = this.xingOauthUserManager.createUser(credentials);
            }
            if (user != null) {
                return user.getPrincipal();
            }
        }
        catch (RepositoryException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void addPrincipals(Set set) {
        this.logger.debug("addPrincipals({})", (Object)set);
    }

    public AuthenticationPlugin getAuthentication(Principal principal, Credentials credentials) throws RepositoryException {
        this.logger.debug("getAuthentication({}, {})", (Object)principal, (Object)credentials);
        return new XingOauthAuthenticationPlugin(this.xingOauthUserManager);
    }

    public int impersonate(Principal principal, Credentials credentials) throws RepositoryException, FailedLoginException {
        this.logger.debug("impersonate({}, {})", (Object)principal, (Object)credentials);
        return 0;
    }

    protected void bindXingOauthUserManager(XingOauthUserManager xingOauthUserManager) {
        this.xingOauthUserManager = xingOauthUserManager;
    }

    protected void unbindXingOauthUserManager(XingOauthUserManager xingOauthUserManager) {
        if (this.xingOauthUserManager == xingOauthUserManager) {
            this.xingOauthUserManager = null;
        }
    }
}

