/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.extensions.gwt.user.server.rpc;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Bundle;

public class SlingRemoteServiceServlet
extends RemoteServiceServlet {
    private Bundle bundle;
    private ClassLoader classLoader;

    public String processCall(String payload) throws SerializationException {
        String result;
        if (this.classLoader != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            result = super.processCall(payload);
            Thread.currentThread().setContextClassLoader(old);
        } else {
            result = super.processCall(payload);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        String contextPath = request.getContextPath();
        String modulePath = null;
        if (moduleBaseURL != null) {
            try {
                modulePath = new URL(moduleBaseURL).getPath();
            }
            catch (MalformedURLException ex) {
                this.getServletContext().log("Malformed moduleBaseURL: " + moduleBaseURL, (Throwable)ex);
            }
        }
        SerializationPolicy serializationPolicy = null;
        if (modulePath == null || !modulePath.startsWith(contextPath)) {
            String message = "ERROR: The module path requested, " + modulePath + ", is not in the same web application as this servlet, " + contextPath + ".  Your module may not be properly configured or your client and server code maybe out of date.";
            this.getServletContext().log(message);
        } else {
            String contextRelativePath = modulePath.substring(contextPath.length());
            String serializationPolicyFilePath = SerializationPolicyLoader.getSerializationPolicyFileName(contextRelativePath + strongName);
            InputStream is = null;
            if (this.bundle != null) {
                try {
                    is = this.bundle.getResource(serializationPolicyFilePath).openStream();
                }
                catch (IOException e) {}
            } else {
                is = this.getServletContext().getResourceAsStream(serializationPolicyFilePath);
            }
            try {
                if (is != null) {
                    try {
                        serializationPolicy = SerializationPolicyLoader.loadFromStream(is, null);
                    }
                    catch (ParseException e) {
                        this.getServletContext().log("ERROR: Failed to parse the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                    }
                    catch (IOException e) {
                        this.getServletContext().log("ERROR: Could not read the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                    }
                } else {
                    String message = "ERROR: The serialization policy file '" + serializationPolicyFilePath + "' was not found; did you forget to include it in this deployment?";
                    this.getServletContext().log(message);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return serializationPolicy;
    }

    protected void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    protected void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

