/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.sling.servlets.annotations.testservletfilters;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.servlets.annotations.SlingServletFilter;
import org.apache.sling.servlets.annotations.SlingServletFilterScope;
import org.osgi.service.component.annotations.Component;

@Component
@SlingServletFilter(scope=SlingServletFilterScope.REQUEST)
public class SimpleServletFilter implements Filter {

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
       chain.doFilter(request, response);
       if ((request instanceof SlingHttpServletRequest) && (response instanceof SlingHttpServletResponse)) {
            afterDoFilter((SlingHttpServletRequest) request, (SlingHttpServletResponse) response, chain);
       } else {
           throw new ServletException("Not a Sling HTTP request/response");
       }
    }

    private void afterDoFilter(SlingHttpServletRequest request, SlingHttpServletResponse response, FilterChain chain) {
        if (request.getRequestURI().endsWith("simplefilter")) {
            // increase status by 1
            response.setStatus(response.getStatus()+1);
        }
    }
    
    @Override
    public void destroy() {
    }

}
