/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.config.annotations;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.sling.testing.mock.osgi.config.annotations.ConfigCollection;
import org.apache.sling.testing.mock.osgi.config.annotations.TypedConfig;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.quality.Strictness;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.component.propertytypes.ServiceVendor;

public class ConfigCollectionTest {
    private <T> TypedConfig<T> newMockEntry(@NotNull Class<T> configType, @NotNull T config) {
        TypedConfig mocked = (TypedConfig)Mockito.mock(TypedConfig.class, (MockSettings)Mockito.withSettings().strictness(Strictness.LENIENT));
        ((TypedConfig)Mockito.doReturn(configType).when((Object)mocked)).getType();
        ((TypedConfig)Mockito.doReturn(config).when((Object)mocked)).getConfig();
        ((TypedConfig)Mockito.doCallRealMethod().when((Object)mocked)).stream((Class)ArgumentMatchers.any(Class.class));
        ((TypedConfig)Mockito.doCallRealMethod().when((Object)mocked)).configStream((Class)ArgumentMatchers.any(Class.class));
        return mocked;
    }

    private ConfigCollection newMockConfigCollection(@NotNull Supplier<Stream<TypedConfig<?>>> entryStreamSupplier) {
        ConfigCollection mocked = (ConfigCollection)Mockito.mock(ConfigCollection.class, (MockSettings)Mockito.withSettings().strictness(Strictness.LENIENT));
        ((ConfigCollection)Mockito.doCallRealMethod().when((Object)mocked)).stream((Class)ArgumentMatchers.any(Class.class));
        ((ConfigCollection)Mockito.doCallRealMethod().when((Object)mocked)).configStream((Class)ArgumentMatchers.any(Class.class));
        ((ConfigCollection)Mockito.doAnswer(call -> entryStreamSupplier.get()).when((Object)mocked)).stream();
        return mocked;
    }

    @Test
    public void entryStream() {
        ServiceRanking serviceRanking = (ServiceRanking)Mockito.mock(ServiceRanking.class);
        ServiceVendor serviceVendor = (ServiceVendor)Mockito.mock(ServiceVendor.class);
        TypedConfig<ServiceRanking> serviceRankingEntry = this.newMockEntry(ServiceRanking.class, serviceRanking);
        Assert.assertSame(serviceRankingEntry, serviceRankingEntry.stream(ServiceRanking.class).findFirst().orElseThrow());
        Assert.assertEquals((long)1L, (long)serviceRankingEntry.stream(ServiceRanking.class).count());
        Assert.assertEquals((long)0L, (long)serviceRankingEntry.stream(ServiceVendor.class).count());
        Assert.assertSame((Object)serviceRanking, serviceRankingEntry.configStream(ServiceRanking.class).findFirst().orElseThrow());
        Assert.assertEquals((long)1L, (long)serviceRankingEntry.configStream(ServiceRanking.class).count());
        Assert.assertEquals((long)0L, (long)serviceRankingEntry.configStream(ServiceVendor.class).count());
        TypedConfig<ServiceVendor> serviceVendorEntry = this.newMockEntry(ServiceVendor.class, serviceVendor);
        Assert.assertSame(serviceVendorEntry, serviceVendorEntry.stream(ServiceVendor.class).findFirst().orElseThrow());
        Assert.assertEquals((long)1L, (long)serviceVendorEntry.stream(ServiceVendor.class).count());
        Assert.assertEquals((long)0L, (long)serviceVendorEntry.stream(ServiceRanking.class).count());
        Assert.assertSame((Object)serviceVendor, serviceVendorEntry.configStream(ServiceVendor.class).findFirst().orElseThrow());
        Assert.assertEquals((long)1L, (long)serviceVendorEntry.configStream(ServiceVendor.class).count());
        Assert.assertEquals((long)0L, (long)serviceVendorEntry.configStream(ServiceRanking.class).count());
        List<TypedConfig<ServiceVendor>> entries = List.of(serviceRankingEntry, serviceVendorEntry);
        ConfigCollection configCollection = this.newMockConfigCollection(entries::stream);
        Assert.assertArrayEquals((Object[])new TypedConfig[]{serviceRankingEntry}, (Object[])configCollection.stream(ServiceRanking.class).toArray());
        Assert.assertArrayEquals((Object[])new TypedConfig[]{serviceVendorEntry}, (Object[])configCollection.stream(ServiceVendor.class).toArray());
        Assert.assertArrayEquals((Object[])new ServiceRanking[]{serviceRanking}, (Object[])configCollection.configStream(ServiceRanking.class).toArray());
        Assert.assertArrayEquals((Object[])new ServiceVendor[]{serviceVendor}, (Object[])configCollection.configStream(ServiceVendor.class).toArray());
    }
}

