/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.resourceresolver;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.testing.resourceresolver.DefaultMockResourceFactory;
import org.apache.sling.testing.resourceresolver.MockFindResourcesHandler;
import org.apache.sling.testing.resourceresolver.MockQueryResourceHandler;
import org.apache.sling.testing.resourceresolver.MockResourceFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.event.EventAdmin;

public class MockResourceResolverFactoryOptions {
    private MockResourceFactory mockResourceFactory;
    private EventAdmin eventAdmin;
    private String[] searchPaths = new String[]{"/apps/", "/libs/"};
    private boolean mangleNamespacePrefixes;
    private final List<MockFindResourcesHandler> findResourcesHandlers = new ArrayList<MockFindResourcesHandler>();
    private final List<MockQueryResourceHandler> queryResourcesHandlers = new ArrayList<MockQueryResourceHandler>();

    @Nullable
    public EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    @NotNull
    public MockResourceResolverFactoryOptions setEventAdmin(@Nullable EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
        return this;
    }

    public String @NotNull [] getSearchPaths() {
        return this.searchPaths;
    }

    @NotNull
    public MockResourceResolverFactoryOptions setSearchPaths(@NotNull String @Nullable [] searchPaths) {
        if (searchPaths == null) {
            searchPaths = new String[]{};
        }
        this.searchPaths = searchPaths;
        return this;
    }

    public boolean isMangleNamespacePrefixes() {
        return this.mangleNamespacePrefixes;
    }

    @NotNull
    public MockResourceResolverFactoryOptions setMangleNamespacePrefixes(boolean mangleNamespacePrefixes) {
        this.mangleNamespacePrefixes = mangleNamespacePrefixes;
        return this;
    }

    @NotNull
    public MockResourceFactory getMockResourceFactory() {
        if (this.mockResourceFactory == null) {
            this.mockResourceFactory = new DefaultMockResourceFactory();
        }
        return this.mockResourceFactory;
    }

    @NotNull
    public MockResourceResolverFactoryOptions setMockResourceFactory(MockResourceFactory factory) {
        this.mockResourceFactory = factory;
        return this;
    }

    public void addFindResourceHandler(@NotNull MockFindResourcesHandler handler) {
        this.findResourcesHandlers.add(handler);
    }

    @NotNull
    public List<MockFindResourcesHandler> getFindResourcesHandlers() {
        return this.findResourcesHandlers;
    }

    public void addQueryResourceHandlerInternal(@NotNull MockQueryResourceHandler handler) {
        this.queryResourcesHandlers.add(handler);
    }

    @NotNull
    public List<MockQueryResourceHandler> getQueryResourcesHandlers() {
        return this.queryResourcesHandlers;
    }
}

