/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal.providers;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.thumbnails.extension.ThumbnailProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ThumbnailProvider.class}, immediate=true)
public class PdfThumbnailProvider
implements ThumbnailProvider {
    private static final Logger log = LoggerFactory.getLogger(PdfThumbnailProvider.class);

    @Override
    public boolean applies(Resource resource, String metaType) {
        try {
            MimeType mt = new MimeType(metaType);
            return mt.match("application/pdf");
        }
        catch (MimeTypeParseException e) {
            log.warn("Failed to parse mime type", (Throwable)e);
            return false;
        }
    }

    @Override
    public InputStream getThumbnail(Resource resource) throws IOException {
        try (PDDocument document = PDDocument.load((InputStream)((InputStream)resource.adaptTo(InputStream.class)));){
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            BufferedImage bim = pdfRenderer.renderImageWithDPI(0, 300.0f, ImageType.RGB);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bim, "jpeg", os);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
            return byteArrayInputStream;
        }
    }
}

