/*
 * Decompiled with CFR 0.152.
 */
package com.okta.authn.sdk.impl.client;

import com.okta.authn.sdk.client.AuthenticationClient;
import com.okta.authn.sdk.client.AuthenticationClientBuilder;
import com.okta.authn.sdk.impl.client.DefaultAuthenticationClient;
import com.okta.authn.sdk.impl.client.DisabledClientCredentialsResolver;
import com.okta.commons.configcheck.ConfigurationValidator;
import com.okta.commons.http.config.BaseUrlResolver;
import com.okta.commons.http.config.Proxy;
import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Strings;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.impl.api.ClientCredentialsResolver;
import com.okta.sdk.impl.config.ClientConfiguration;
import com.okta.sdk.impl.config.EnvironmentVariablesPropertiesSource;
import com.okta.sdk.impl.config.OptionalPropertiesSource;
import com.okta.sdk.impl.config.PropertiesSource;
import com.okta.sdk.impl.config.ResourcePropertiesSource;
import com.okta.sdk.impl.config.SystemPropertiesSource;
import com.okta.sdk.impl.config.YAMLPropertiesSource;
import com.okta.sdk.impl.io.DefaultResourceFactory;
import com.okta.sdk.impl.io.Resource;
import com.okta.sdk.impl.io.ResourceFactory;
import com.okta.sdk.impl.util.DefaultBaseUrlResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultAuthenticationClientBuilder
implements AuthenticationClientBuilder {
    private static final String ENVVARS_TOKEN = "envvars";
    private static final String SYSPROPS_TOKEN = "sysprops";
    private static final String OKTA_CONFIG_CP = "com/okta/authn/sdk/config/";
    private static final String OKTA_YAML = "okta.yaml";
    private static final String OKTA_PROPERTIES = "okta.properties";
    private static final String USER_HOME = System.getProperty("user.home") + File.separatorChar;
    private static final String[] DEFAULT_OKTA_PROPERTIES_FILE_LOCATIONS = new String[]{"classpath:com/okta/authn/sdk/config/okta.properties", "classpath:com/okta/authn/sdk/config/okta.yaml", "classpath:okta.properties", "classpath:okta.yaml", USER_HOME + ".okta" + File.separatorChar + "okta.yaml", "envvars", "sysprops"};
    private ClientConfiguration clientConfig = new ClientConfiguration();
    private boolean allowNonHttpsForTesting = false;

    public DefaultAuthenticationClientBuilder() {
        this((ResourceFactory)new DefaultResourceFactory());
    }

    /*
     * WARNING - void declaration
     */
    DefaultAuthenticationClientBuilder(ResourceFactory resourceFactory) {
        void var5_7;
        ArrayList<Object> sources = new ArrayList<Object>();
        String[] stringArray = DEFAULT_OKTA_PROPERTIES_FILE_LOCATIONS;
        int n = stringArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            String location = stringArray[var5_7];
            if (ENVVARS_TOKEN.equalsIgnoreCase(location)) {
                sources.add(EnvironmentVariablesPropertiesSource.oktaFilteredPropertiesSource());
            } else if (SYSPROPS_TOKEN.equalsIgnoreCase(location)) {
                sources.add(SystemPropertiesSource.oktaFilteredPropertiesSource());
            } else {
                Resource resource = resourceFactory.createResource(location);
                Object wrappedSource = Strings.endsWithIgnoreCase((String)location, (String)".yaml") ? new YAMLPropertiesSource(resource) : new ResourcePropertiesSource(resource);
                OptionalPropertiesSource propertiesSource = new OptionalPropertiesSource((PropertiesSource)wrappedSource);
                sources.add(propertiesSource);
            }
            ++var5_7;
        }
        LinkedHashMap props = new LinkedHashMap();
        for (PropertiesSource propertiesSource : sources) {
            Map srcProps = propertiesSource.getProperties();
            props.putAll(srcProps);
        }
        if (Strings.hasText((String)((String)props.get("okta.testing.disableHttpsCheck")))) {
            this.allowNonHttpsForTesting = Boolean.valueOf((String)props.get("okta.testing.disableHttpsCheck"));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.orgUrl")))) {
            String baseUrl = (String)props.get("okta.client.orgUrl");
            baseUrl = baseUrl.replace("\\:", ":");
            ConfigurationValidator.assertOrgUrl((String)baseUrl, (boolean)this.allowNonHttpsForTesting);
            this.clientConfig.setBaseUrl(baseUrl);
        }
        if (Strings.hasText((String)((String)props.get("okta.client.connectionTimeout")))) {
            this.clientConfig.setConnectionTimeout(Integer.parseInt((String)props.get("okta.client.connectionTimeout")));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.authenticationScheme")))) {
            this.clientConfig.setAuthenticationScheme(Enum.valueOf(AuthenticationScheme.class, (String)props.get("okta.client.authenticationScheme")));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.proxy.port")))) {
            this.clientConfig.setProxyPort(Integer.parseInt((String)props.get("okta.client.proxy.port")));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.proxy.host")))) {
            this.clientConfig.setProxyHost((String)props.get("okta.client.proxy.host"));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.proxy.username")))) {
            this.clientConfig.setProxyUsername((String)props.get("okta.client.proxy.username"));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.proxy.password")))) {
            this.clientConfig.setProxyPassword((String)props.get("okta.client.proxy.password"));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.requestTimeout")))) {
            this.clientConfig.setRetryMaxElapsed(Integer.parseInt((String)props.get("okta.client.requestTimeout")));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.rateLimit.maxRetries")))) {
            this.clientConfig.setRetryMaxAttempts(Integer.parseInt((String)props.get("okta.client.rateLimit.maxRetries")));
        }
    }

    public AuthenticationClientBuilder setProxy(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy argument cannot be null.");
        }
        this.clientConfig.setProxyHost(proxy.getHost());
        this.clientConfig.setProxyPort(proxy.getPort());
        this.clientConfig.setProxyUsername(proxy.getUsername());
        this.clientConfig.setProxyPassword(proxy.getPassword());
        return this;
    }

    public AuthenticationClientBuilder setConnectionTimeout(int timeout) {
        Assert.isTrue((timeout >= 0 ? 1 : 0) != 0, (String)"Timeout cannot be a negative number.");
        this.clientConfig.setConnectionTimeout(timeout);
        return this;
    }

    public AuthenticationClientBuilder setBaseUrlResolver(BaseUrlResolver baseUrlResolver) {
        Assert.notNull((Object)baseUrlResolver, (String)"baseUrlResolver must not be null");
        this.clientConfig.setBaseUrlResolver(baseUrlResolver);
        return this;
    }

    public AuthenticationClientBuilder setRetryMaxElapsed(int maxElapsed) {
        this.clientConfig.setRetryMaxElapsed(maxElapsed);
        return this;
    }

    public AuthenticationClientBuilder setRetryMaxAttempts(int maxAttempts) {
        this.clientConfig.setRetryMaxAttempts(maxAttempts);
        return this;
    }

    public AuthenticationClient build() {
        if (this.clientConfig.getBaseUrlResolver() == null) {
            Assert.notNull((Object)this.clientConfig.getBaseUrl(), (String)"Okta org url must not be null.");
            this.clientConfig.setBaseUrlResolver((BaseUrlResolver)new DefaultBaseUrlResolver(this.clientConfig.getBaseUrl()));
        }
        this.clientConfig.setClientCredentialsResolver((ClientCredentialsResolver)new DisabledClientCredentialsResolver());
        return new DefaultAuthenticationClient(this.clientConfig);
    }

    public AuthenticationClientBuilder setOrgUrl(String baseUrl) {
        ConfigurationValidator.assertOrgUrl((String)baseUrl, (boolean)this.allowNonHttpsForTesting);
        this.clientConfig.setBaseUrl(baseUrl);
        return this;
    }

    ClientConfiguration getClientConfiguration() {
        return this.clientConfig;
    }
}

