/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.core.persistence.api.dao.AuditConfDAO;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.transaction.annotation.Transactional;

public class AuditAccessor {
    protected final AuditConfDAO auditConfDAO;
    protected final LoggingSystem loggingSystem;

    public AuditAccessor(AuditConfDAO auditConfDAO, LoggingSystem loggingSystem) {
        this.auditConfDAO = auditConfDAO;
        this.loggingSystem = loggingSystem;
    }

    @Transactional
    public void synchronizeLoggingWithAudit() {
        this.auditConfDAO.findAll().forEach(auditConf -> this.loggingSystem.setLogLevel(AuditLoggerName.getAuditEventLoggerName((String)AuthContextUtils.getDomain(), (String)auditConf.getKey()), auditConf.isActive() ? LogLevel.DEBUG : LogLevel.OFF));
    }
}

