/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.logout;

import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.logout.LogoutRequestStatus;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.logout.AbstractLogoutAction;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class LogoutAction
extends AbstractLogoutAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutAction.class);

    public LogoutAction(TicketRegistry ticketRegistry, CasCookieBuilder ticketGrantingTicketCookieGenerator, ArgumentExtractor argumentExtractor, ServicesManager servicesManager, LogoutExecutionPlan logoutExecutionPlan, CasConfigurationProperties casProperties) {
        super(ticketRegistry, ticketGrantingTicketCookieGenerator, argumentExtractor, servicesManager, logoutExecutionPlan, casProperties);
    }

    @Override
    protected Event doInternalExecute(HttpServletRequest request, HttpServletResponse response, RequestContext context) {
        List logoutRequests = WebUtils.getLogoutRequests((RequestContext)context);
        Boolean needFrontSlo = (Boolean)FunctionUtils.doIf((logoutRequests != null ? 1 : 0) != 0, () -> Objects.requireNonNull(logoutRequests).stream().anyMatch(logoutRequest -> logoutRequest.getStatus() == LogoutRequestStatus.NOT_ATTEMPTED), () -> Boolean.FALSE).get();
        this.logoutExecutionPlan.getLogoutRedirectionStrategies().stream().filter(s -> s.supports(context)).forEach(s -> s.handle(context));
        if (needFrontSlo.booleanValue()) {
            LOGGER.trace("Proceeding forward with front-channel single logout");
            return new Event((Object)this, "front");
        }
        LOGGER.trace("Moving forward to finish the logout process");
        return new Event((Object)this, "finish");
    }
}

