/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.tirasa.connid.bundles.scim.common.AbstractSCIMConnector;
import net.tirasa.connid.bundles.scim.common.SCIMConnectorConfiguration;
import net.tirasa.connid.bundles.scim.common.SCIMProvider;
import net.tirasa.connid.bundles.scim.common.dto.BaseResourceReference;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseAttribute;
import net.tirasa.connid.bundles.scim.common.dto.SCIMSchema;
import net.tirasa.connid.bundles.scim.common.dto.SCIMUserAddress;
import net.tirasa.connid.bundles.scim.common.types.AddressCanonicalType;
import net.tirasa.connid.bundles.scim.common.utils.SCIMAttributeUtils;
import net.tirasa.connid.bundles.scim.common.utils.SCIMUtils;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Attribute;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2EnterpriseUser;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Entitlement;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2EntitlementResource;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Group;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Patch;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2PatchImpl;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2PatchOperation;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2User;
import net.tirasa.connid.bundles.scim.v2.service.SCIMv2Client;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.spi.ConnectorClass;

@ConnectorClass(displayNameKey="SCIMv2Connector.connector.display", configurationClass=SCIMConnectorConfiguration.class, messageCatalogPaths={"net.tirasa.connid.bundles.scim.common.Messages"})
public class SCIMv2Connector
extends AbstractSCIMConnector<SCIMv2User, SCIMv2Group, SCIMv2EntitlementResource, SCIMv2Patch, SCIMv2PatchOperation, SCIMv2Client, SCIMv2EnterpriseUser.SCIMv2EnterpriseUserManager> {
    private Schema schema;

    @Override
    protected SCIMv2Client buildSCIMClient(SCIMConnectorConfiguration configuration) {
        return new SCIMv2Client(configuration);
    }

    public Schema schema() {
        LOG.ok("Building SCHEMA definition", new Object[0]);
        if (this.schema == null) {
            this.schema = SCIMAttributeUtils.buildSchema(this.configuration.getCustomAttributesJSON(), this.configuration.getManageComplexEntitlements(), this.configuration.getUseColonOnExtensionAttributes(), SCIMv2Attribute.class);
        }
        return this.schema;
    }

    @Override
    public SCIMv2Client getClient() {
        return (SCIMv2Client)this.client;
    }

    @Override
    protected <T extends SCIMBaseAttribute<T>> SCIMv2User buildNewUserEntity(Optional<SCIMSchema<T>> customSchema) {
        SCIMv2User newUser = new SCIMv2User();
        customSchema.ifPresent(cs -> newUser.getSchemas().add(cs.getId()));
        return newUser;
    }

    @Override
    protected SCIMv2Group buildNewGroupEntity() {
        return new SCIMv2Group();
    }

    @Override
    protected SCIMv2Patch buildMembersGroupPatch(List<SCIMv2User> users, String op) {
        SCIMv2PatchImpl.Builder builder = new SCIMv2PatchImpl.Builder();
        switch (this.provider) {
            case SALESFORCE: 
            case WSO2: {
                builder.operations(CollectionUtil.newSet((Object[])new SCIMv2PatchOperation[]{new SCIMv2PatchOperation.Builder().op(op).path(SCIMProvider.SALESFORCE == this.provider || "remove".equals(op) ? "members" : null).value(CollectionUtil.newMap((Object)"members", users.stream().map(user -> this.buildPatchValue((SCIMv2User)user)).collect(Collectors.toList()))).build()}));
                break;
            }
            default: {
                builder.operations(CollectionUtil.newSet((Object[])new SCIMv2PatchOperation[]{new SCIMv2PatchOperation.Builder().op(op).path("members").value(users.stream().map(user -> this.buildPatchValue((SCIMv2User)user)).collect(Collectors.toList())).build()}));
            }
        }
        return builder.build();
    }

    @Override
    protected void fillGroupPatches(SCIMv2User user, Map<String, SCIMv2Patch> groupPatches, List<String> groupsToAdd, List<String> groupsToRemove) {
        groupsToAdd.forEach(grp -> groupPatches.put((String)grp, (SCIMv2Patch)this.buildMembersGroupPatch((List)Collections.singletonList(user), "add")));
        groupsToRemove.forEach(grp -> groupPatches.put((String)grp, (SCIMv2Patch)this.buildMembersGroupPatch((List)Collections.singletonList(user), "remove")));
    }

    @Override
    protected SCIMv2Patch buildPatchFromGroup(SCIMv2Group group) {
        if (SCIMProvider.AWS == this.provider) {
            group.getMembers().clear();
        }
        if (SCIMProvider.AWS == this.provider || SCIMProvider.EGNYTE == this.provider) {
            group.getSchemas().clear();
            group.setMeta(null);
        }
        return new SCIMv2PatchImpl.Builder().operations(Collections.singleton(new SCIMv2PatchOperation.Builder().op("replace").value(group).build())).build();
    }

    @Override
    protected SCIMv2Patch buildUserPatch(Set<AttributeDelta> modifications, SCIMv2User currentUser, boolean manageGroups) {
        SCIMv2PatchImpl patch = new SCIMv2PatchImpl.Builder().build();
        for (AttributeDelta attrDelta : modifications) {
            if (attrDelta.is(Uid.NAME)) {
                throw new IllegalArgumentException("Changing the id attribute is not supported, nor recommended with patch");
            }
            if (attrDelta.is(Name.NAME) && !CollectionUtil.isEmpty((Collection)attrDelta.getValuesToReplace())) {
                patch.addOperation(new SCIMv2PatchOperation.Builder().op("replace").path("userName").value(attrDelta.getValuesToReplace().get(0)).build());
                continue;
            }
            if (attrDelta.is(OperationalAttributes.PASSWORD_NAME) && !CollectionUtil.isEmpty((Collection)attrDelta.getValuesToReplace())) {
                patch.addOperation(new SCIMv2PatchOperation.Builder().op("replace").path("password").value(SecurityUtil.decrypt((GuardedString)((GuardedString)attrDelta.getValuesToReplace().get(0)))).build());
                continue;
            }
            if (attrDelta.getName().contains("addresses") || attrDelta.is("groups")) continue;
            patch.addOperations(this.buildPatchOperations(attrDelta, null));
        }
        this.buildAddressesPatchOperations(modifications, currentUser).forEach(patch::addOperation);
        if (StringUtil.isNotBlank((String)this.configuration.getCustomAttributesJSON())) {
            this.buildCustomAttributesPatchOperations(modifications, this.configuration.getUseColonOnExtensionAttributes()).forEach(patch::addOperation);
        }
        if (manageGroups) {
            this.buildGroupPatchOperations(modifications).forEach(patch::addOperation);
        }
        return patch;
    }

    @Override
    protected SCIMv2Patch buildGroupPatch(Set<AttributeDelta> modifications) {
        SCIMv2PatchImpl patch = new SCIMv2PatchImpl.Builder().build();
        for (AttributeDelta attrDelta : modifications) {
            if (attrDelta.is(Uid.NAME)) {
                throw new IllegalArgumentException("Changing the id attribute is not supported, nor recommended with patch");
            }
            if (attrDelta.is(Name.NAME) && !CollectionUtil.isEmpty((Collection)attrDelta.getValuesToReplace())) {
                patch.addOperation(new SCIMv2PatchOperation.Builder().op("replace").path("displayName").value(attrDelta.getValuesToReplace().get(0)).build());
                continue;
            }
            if (attrDelta.getName().contains("members")) continue;
            patch.addOperations(this.buildPatchOperations(attrDelta, null));
        }
        ArrayList memberOperations = new ArrayList();
        modifications.stream().filter(mod -> "members".equalsIgnoreCase(mod.getName())).findFirst().ifPresent(mod -> {
            if (!CollectionUtil.isEmpty((Collection)mod.getValuesToRemove())) {
                memberOperations.add(new SCIMv2PatchOperation.Builder().op("remove").path(this.buildFilteredPath(mod.getName(), mod.getValuesToRemove(), "or", "eq")).build());
            }
            if (!CollectionUtil.isEmpty((Collection)mod.getValuesToAdd())) {
                memberOperations.add(new SCIMv2PatchOperation.Builder().op("add").path("members").value(mod.getValuesToAdd().stream().map(vta -> {
                    SCIMv2User user = ((SCIMv2Client)this.client).getUser(vta.toString());
                    BaseResourceReference resRef = null;
                    if (user == null) {
                        LOG.error("Unable to add member {0} to the group, user does not exist", new Object[]{vta});
                    } else {
                        resRef = new BaseResourceReference.Builder().value(user.getId()).ref(this.configuration.getBaseAddress() + "Users/" + user.getId()).display(user.getDisplayName()).build();
                    }
                    return resRef;
                }).filter(Objects::nonNull).collect(Collectors.toList())).build());
            }
            if (!CollectionUtil.isEmpty((Collection)mod.getValuesToReplace())) {
                memberOperations.add(new SCIMv2PatchOperation.Builder().op("replace").path("members").value(mod.getValuesToReplace().stream().map(vtr -> {
                    SCIMv2User user = ((SCIMv2Client)this.client).getUser(vtr.toString());
                    BaseResourceReference resRef = null;
                    if (user == null) {
                        LOG.error("Unable to replace member {0} on the group, user does not exist", new Object[]{vtr});
                    } else {
                        resRef = new BaseResourceReference.Builder().value(user.getId()).ref(this.configuration.getBaseAddress() + "User/" + user.getId()).display(user.getDisplayName()).build();
                    }
                    return resRef;
                }).filter(Objects::nonNull).collect(Collectors.toList())).build());
            }
        });
        patch.getOperations().addAll(memberOperations);
        return patch;
    }

    protected List<SCIMv2PatchOperation> buildCustomAttributesPatchOperations(Set<AttributeDelta> modifications, boolean useColon) {
        ArrayList<SCIMv2PatchOperation> operations = new ArrayList<SCIMv2PatchOperation>();
        SCIMUtils.extractSCIMSchemas(this.configuration.getCustomAttributesJSON(), SCIMv2Attribute.class).ifPresent(scimSchema -> {
            for (SCIMv2Attribute customAttribute : scimSchema.getAttributes()) {
                String extAttrName = ((SCIMv2Attribute)SCIMv2Attribute.class.cast(customAttribute)).getExtensionSchema().concat(useColon ? ":" : ".").concat(customAttribute.getName());
                modifications.stream().filter(mod -> mod.getName().equals(extAttrName)).findFirst().ifPresent(ad -> operations.addAll(this.buildPatchOperations((AttributeDelta)ad, customAttribute)));
            }
        });
        return operations;
    }

    @Override
    protected List<SCIMv2PatchOperation> buildPatchOperations(AttributeDelta currentDelta, SCIMBaseAttribute<?> attributeDefinition) {
        ArrayList<SCIMv2PatchOperation> operations = new ArrayList<SCIMv2PatchOperation>();
        if (CollectionUtil.isEmpty((Collection)currentDelta.getValuesToReplace())) {
            if (!CollectionUtil.isEmpty((Collection)currentDelta.getValuesToAdd())) {
                SCIMv2PatchOperation addPatchOperation = new SCIMv2PatchOperation();
                addPatchOperation.setPath(SCIMAttributeUtils.getBaseAttributeName(currentDelta.getName()));
                addPatchOperation.setOp("add");
                addPatchOperation.setValue(this.buildPatchValue(currentDelta.getName(), currentDelta.getValuesToAdd(), attributeDefinition));
                operations.add(addPatchOperation);
            }
            if (!CollectionUtil.isEmpty((Collection)currentDelta.getValuesToRemove())) {
                SCIMv2PatchOperation removePatchOperation = new SCIMv2PatchOperation();
                removePatchOperation.setOp("remove");
                removePatchOperation.setPath(this.buildFilteredPath(SCIMAttributeUtils.getBaseAttributeName(currentDelta.getName()), currentDelta.getValuesToRemove(), "or", "eq"));
                removePatchOperation.setValue(this.buildPatchValue(currentDelta.getName(), currentDelta.getValuesToRemove(), attributeDefinition));
                operations.add(removePatchOperation);
            }
        } else {
            SCIMv2PatchOperation replacePatchOperation = new SCIMv2PatchOperation();
            replacePatchOperation.setPath(SCIMAttributeUtils.getBaseAttributeName(currentDelta.getName()));
            replacePatchOperation.setOperation("replace");
            replacePatchOperation.setValue(this.buildPatchValue(currentDelta.getName(), currentDelta.getValuesToReplace(), attributeDefinition));
            operations.add(replacePatchOperation);
        }
        return operations;
    }

    @Override
    protected List<SCIMv2PatchOperation> buildGroupPatchOperations(Set<AttributeDelta> modifications) {
        ArrayList<SCIMv2PatchOperation> grpOperations = new ArrayList<SCIMv2PatchOperation>();
        modifications.stream().filter(mod -> "groups".equalsIgnoreCase(mod.getName())).findFirst().ifPresent(mod -> {
            if (!CollectionUtil.isEmpty((Collection)mod.getValuesToRemove())) {
                grpOperations.add(new SCIMv2PatchOperation.Builder().op("remove").path(this.buildFilteredPath(mod.getName(), mod.getValuesToRemove(), "or", "eq")).build());
            }
            if (!CollectionUtil.isEmpty((Collection)mod.getValuesToAdd())) {
                grpOperations.add(new SCIMv2PatchOperation.Builder().op("add").path("groups").value(mod.getValuesToAdd().stream().map(vta -> {
                    SCIMv2Group group = ((SCIMv2Client)this.client).getGroup(vta.toString());
                    BaseResourceReference resRef = null;
                    if (group == null) {
                        LOG.error("Unable to add group {0} to the user, group does not exist", new Object[]{vta});
                    } else {
                        resRef = new BaseResourceReference.Builder().value(group.getId()).ref(this.configuration.getBaseAddress() + "Groups/" + group.getId()).display(group.getDisplayName()).build();
                    }
                    return resRef;
                }).filter(Objects::nonNull).collect(Collectors.toList())).build());
            }
            if (!CollectionUtil.isEmpty((Collection)mod.getValuesToReplace())) {
                grpOperations.add(new SCIMv2PatchOperation.Builder().op("replace").path("groups").value(mod.getValuesToReplace().stream().map(vtr -> {
                    SCIMv2Group group = ((SCIMv2Client)this.client).getGroup(vtr.toString());
                    BaseResourceReference resRef = null;
                    if (group == null) {
                        LOG.error("Unable to replace group {0} to the user, group does not exist", new Object[]{vtr});
                    } else {
                        resRef = new BaseResourceReference.Builder().value(group.getId()).ref(this.configuration.getBaseAddress() + "Groups/" + group.getId()).display(group.getDisplayName()).build();
                    }
                    return resRef;
                }).filter(Objects::nonNull).collect(Collectors.toList())).build());
            }
        });
        return grpOperations;
    }

    @Override
    protected List<SCIMv2PatchOperation> buildAddressesPatchOperations(Set<AttributeDelta> modifications, SCIMv2User currentUser) {
        ArrayList<SCIMv2PatchOperation> patchOperations = new ArrayList<SCIMv2PatchOperation>();
        modifications.stream().filter(mod -> mod.getName().startsWith("addresses") && !CollectionUtil.isEmpty((Collection)mod.getValuesToRemove())).collect(Collectors.toMap(AttributeDelta::getName, AttributeDelta::getValuesToRemove)).forEach((k, v) -> {
            SCIMv2PatchOperation patchOperation = new SCIMv2PatchOperation();
            patchOperation.setPath(this.buildFilteredPath((String)k, (List<Object>)v, "or", "eq"));
            patchOperation.setOp("remove");
            patchOperations.add(patchOperation);
        });
        if (modifications.stream().anyMatch(mod -> mod.getName().startsWith("addresses") && !CollectionUtil.isEmpty((Collection)mod.getValuesToAdd()))) {
            SCIMUserAddress otherAddress;
            SCIMUserAddress workAddress;
            SCIMUserAddress homeAddress;
            SCIMUserAddress defaultAddress = this.buildUserAddress(modifications, null, false);
            if (!defaultAddress.isEmpty()) {
                SCIMv2PatchOperation patchOperation = new SCIMv2PatchOperation();
                patchOperation.setPath("addresses");
                patchOperation.setOp("add");
                patchOperation.setValue(defaultAddress);
                patchOperations.add(patchOperation);
            }
            if (!(homeAddress = this.buildUserAddress(modifications, AddressCanonicalType.home, false)).isEmpty()) {
                SCIMv2PatchOperation patchOperation = new SCIMv2PatchOperation();
                patchOperation.setPath("addresses");
                patchOperation.setOp("add");
                patchOperation.setValue(homeAddress);
                patchOperations.add(patchOperation);
            }
            if (!(workAddress = this.buildUserAddress(modifications, AddressCanonicalType.work, false)).isEmpty()) {
                SCIMv2PatchOperation patchOperation = new SCIMv2PatchOperation();
                patchOperation.setPath("addresses");
                patchOperation.setOp("add");
                patchOperation.setValue(workAddress);
                patchOperations.add(patchOperation);
            }
            if (!(otherAddress = this.buildUserAddress(modifications, AddressCanonicalType.other, false)).isEmpty()) {
                SCIMv2PatchOperation patchOperation = new SCIMv2PatchOperation();
                patchOperation.setPath("addresses");
                patchOperation.setOp("add");
                patchOperation.setValue(otherAddress);
                patchOperations.add(patchOperation);
            }
        }
        if (modifications.stream().anyMatch(mod -> mod.getName().startsWith("addresses") && !CollectionUtil.isEmpty((Collection)mod.getValuesToReplace()))) {
            SCIMv2Connector.addAddressToPatchOperations(patchOperations, currentUser.getAddresses().stream().filter(a -> a.getType() == null).findFirst(), this.buildUserAddress(modifications, null, true));
            SCIMv2Connector.addAddressToPatchOperations(patchOperations, currentUser.getAddresses().stream().filter(a -> AddressCanonicalType.home == a.getType()).findFirst(), this.buildUserAddress(modifications, AddressCanonicalType.home, true));
            SCIMv2Connector.addAddressToPatchOperations(patchOperations, currentUser.getAddresses().stream().filter(a -> AddressCanonicalType.work == a.getType()).findFirst(), this.buildUserAddress(modifications, AddressCanonicalType.work, true));
            SCIMv2Connector.addAddressToPatchOperations(patchOperations, currentUser.getAddresses().stream().filter(a -> AddressCanonicalType.other == a.getType()).findFirst(), this.buildUserAddress(modifications, AddressCanonicalType.other, true));
        }
        return patchOperations;
    }

    private static void addAddressToPatchOperations(List<SCIMv2PatchOperation> patchOperations, Optional<SCIMUserAddress> currentOtherAddress, SCIMUserAddress newAddress) {
        if (!newAddress.isEmpty()) {
            SCIMv2PatchOperation patchOperation = new SCIMv2PatchOperation();
            patchOperation.setPath("addresses");
            patchOperation.setOp("add");
            patchOperation.setValue(newAddress.fillFrom(currentOtherAddress));
            patchOperations.add(patchOperation);
        } else if (currentOtherAddress.isPresent()) {
            SCIMv2PatchOperation patchOperation = new SCIMv2PatchOperation();
            patchOperation.setPath("addresses");
            patchOperation.setOp("add");
            patchOperation.setValue(currentOtherAddress.get());
            patchOperations.add(patchOperation);
        }
    }

    private SCIMUserAddress buildUserAddress(Set<AttributeDelta> modifications, AddressCanonicalType type, boolean isReplace) {
        SCIMUserAddress address = new SCIMUserAddress();
        Optional.ofNullable(type).ifPresent(address::setType);
        SCIMv2Connector.setAddressAttribute(modifications, "addresses." + (String)(type == null ? "" : type.name() + ".") + "streetAddress", isReplace, address::setStreetAddress);
        SCIMv2Connector.setAddressAttribute(modifications, "addresses." + (String)(type == null ? "" : type.name() + ".") + "locality", isReplace, address::setLocality);
        SCIMv2Connector.setAddressAttribute(modifications, "addresses." + (String)(type == null ? "" : type.name() + ".") + "region", isReplace, address::setRegion);
        SCIMv2Connector.setAddressAttribute(modifications, "addresses." + (String)(type == null ? "" : type.name() + ".") + "postalCode", isReplace, address::setPostalCode);
        SCIMv2Connector.setAddressAttribute(modifications, "addresses." + (String)(type == null ? "" : type.name() + ".") + "country", isReplace, address::setCountry);
        return address;
    }

    private static void setAddressAttribute(Set<AttributeDelta> modifications, String addressAttrName, boolean isReplace, Consumer<String> setter) {
        modifications.stream().filter(mod -> mod.getName().equalsIgnoreCase(addressAttrName) && isReplace && !CollectionUtil.isEmpty((Collection)mod.getValuesToReplace()) || !isReplace && !CollectionUtil.isEmpty((Collection)mod.getValuesToAdd())).findFirst().ifPresent(mod -> setter.accept(isReplace ? mod.getValuesToReplace().get(0).toString() : mod.getValuesToAdd().get(0).toString()));
    }

    @Override
    protected void manageEntitlements(SCIMv2User user, List<String> values) {
        List<SCIMv2EntitlementResource> scimEntitlementRefs = values == null ? Collections.emptyList() : values.stream().map(((SCIMv2Client)this.client)::getEntitlement).filter(g -> g != null).collect(Collectors.toList());
        scimEntitlementRefs.forEach(e -> user.getEntitlements().add(new SCIMv2Entitlement.Builder().value(e.getId()).ref(this.configuration.getBaseAddress() + "Entitlements/" + e.getId()).display(e.getDisplayName()).primary(true).type(e.getType()).build()));
    }

    @Override
    protected SCIMv2EnterpriseUser.SCIMv2EnterpriseUserManager buildEnterpriseUserManager(String value) {
        SCIMv2EnterpriseUser.SCIMv2EnterpriseUserManager manager = new SCIMv2EnterpriseUser.SCIMv2EnterpriseUserManager();
        manager.setValue(value);
        return manager;
    }

    private BaseResourceReference buildPatchValue(SCIMv2User user) {
        BaseResourceReference.Builder builder = new BaseResourceReference.Builder();
        switch (this.provider) {
            case WSO2: {
                builder.value(user.getId()).display(user.getUserName());
                break;
            }
            case KEYCLOAK: {
                builder.value(user.getId()).ref(this.configuration.getBaseAddress() + "Users/" + user.getId()).display(user.getDisplayName());
                break;
            }
            default: {
                builder.value(user.getId());
            }
        }
        return builder.build();
    }
}

