/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAVirSchema;

public class JPAVirSchemaDAO
extends AbstractDAO<VirSchema>
implements VirSchemaDAO {
    protected final ExternalResourceDAO resourceDAO;

    public JPAVirSchemaDAO(ExternalResourceDAO resourceDAO) {
        this.resourceDAO = resourceDAO;
    }

    public VirSchema find(String key) {
        return (VirSchema)this.entityManager().find(JPAVirSchema.class, (Object)key);
    }

    public List<VirSchema> findByAnyTypeClasses(Collection<AnyTypeClass> anyTypeClasses) {
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(JPAVirSchema.class.getSimpleName()).append(" e WHERE ");
        anyTypeClasses.forEach(anyTypeClass -> queryString.append("e.anyTypeClass.id='").append(anyTypeClass.getKey()).append("' OR "));
        TypedQuery query = this.entityManager().createQuery(queryString.substring(0, queryString.length() - 4), VirSchema.class);
        return query.getResultList();
    }

    public List<String> find(ExternalResource resource) {
        Query query = this.entityManager().createNativeQuery("SELECT id FROM VirSchema e WHERE e.resource_id=?");
        query.setParameter(1, (Object)resource.getKey());
        List results = query.getResultList();
        return results.stream().map(Object::toString).collect(Collectors.toList());
    }

    public List<VirSchema> find(String resource, String anyType) {
        Query query = this.entityManager().createNativeQuery("SELECT id FROM VirSchema e WHERE e.resource_id=? AND e.anyType_id=?");
        query.setParameter(1, (Object)resource);
        query.setParameter(2, (Object)anyType);
        List results = query.getResultList();
        return results.stream().map(row -> this.find(row.toString())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<VirSchema> findByKeyword(String keyword) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAVirSchema.class.getSimpleName() + " e WHERE e.id LIKE :keyword", VirSchema.class);
        query.setParameter("keyword", (Object)keyword);
        return query.getResultList();
    }

    public List<VirSchema> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAVirSchema.class.getSimpleName() + " e", VirSchema.class);
        return query.getResultList();
    }

    public VirSchema save(VirSchema schema) {
        ((JPAVirSchema)schema).map2json();
        return (VirSchema)this.entityManager().merge((Object)schema);
    }

    public void delete(String key) {
        VirSchema schema = this.find(key);
        if (schema == null) {
            return;
        }
        this.resourceDAO.deleteMapping(key);
        if (schema.getAnyTypeClass() != null) {
            schema.getAnyTypeClass().getVirSchemas().remove(schema);
        }
        this.entityManager().remove((Object)schema);
    }
}

