/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.serializer.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.Optional;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.serializer.XmlObjectResultsHandler;
import org.identityconnectors.framework.impl.serializer.xml.XmlObjectDecoder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlObjectParser {
    private static final SAXParserFactory SAX_PARSER_FACTORY;
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY;

    public static void parse(InputSource inputSource, XmlObjectResultsHandler handler, boolean validate) {
        try {
            SAXParser parser = SAX_PARSER_FACTORY.newSAXParser();
            MySAXHandler saxHandler = new MySAXHandler(handler, validate);
            parser.parse(inputSource, (DefaultHandler)saxHandler);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    static {
        DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
        try {
            SAX_PARSER_FACTORY = SAXParserFactory.newInstance();
            SAX_PARSER_FACTORY.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private static class MySAXHandler
    extends DefaultHandler {
        private Document currentTopLevelElementDocument;
        private final Stack<Element> elementStack = new Stack();
        private final boolean validate;
        private final XmlObjectResultsHandler handler;
        private boolean _stillHandling = true;

        public MySAXHandler(XmlObjectResultsHandler handler, boolean validate) {
            this.handler = handler;
            this.validate = validate;
        }

        private Optional<Element> currentElement() {
            return Optional.ofNullable(this.elementStack.isEmpty() ? null : this.elementStack.peek());
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.currentElement().ifPresent(e -> e.appendChild(this.currentTopLevelElementDocument.createTextNode(new String(ch, start, length))));
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if (!this.elementStack.isEmpty()) {
                Element element = this.elementStack.pop();
                if (this.elementStack.isEmpty()) {
                    this.currentTopLevelElementDocument = null;
                    if (this._stillHandling) {
                        XmlObjectDecoder decoder = new XmlObjectDecoder(element, null);
                        Object object = decoder.readObject();
                        this._stillHandling = this.handler.handle(object);
                    }
                }
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) {
            this.currentElement().ifPresent(e -> e.appendChild(this.currentTopLevelElementDocument.createTextNode(new String(ch, start, length))));
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            String name = StringUtil.isBlank((String)localName) ? qName : localName;
            Element element = null;
            if (this.elementStack.isEmpty()) {
                if (!"MultiObject".equals(name)) {
                    try {
                        this.currentTopLevelElementDocument = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder().newDocument();
                    }
                    catch (Exception e2) {
                        throw ConnectorException.wrap((Throwable)e2);
                    }
                    element = this.currentTopLevelElementDocument.createElement(name);
                }
            } else {
                element = this.currentElement().map(e -> (Element)e.appendChild(this.currentTopLevelElementDocument.createElement(name))).orElse(null);
            }
            if (element != null) {
                this.elementStack.push(element);
                for (int i = 0; i < atts.getLength(); ++i) {
                    element.setAttribute(atts.getLocalName(i), atts.getValue(i));
                }
            }
        }

        @Override
        public InputSource resolveEntity(String pubid, String sysid) throws SAXException {
            if ("connectors.dtd".equals(pubid)) {
                if (!this.validate) {
                    return new InputSource(new StringReader("<?xml version='1.0' encoding='UTF-8'?>"));
                }
                try {
                    return new InputSource(XmlObjectParser.class.getResource(pubid).openStream());
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
            return null;
        }
    }
}

