/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.export;

import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CollectionHandler;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.bpmn.model.VariableAggregationDefinition;
import org.flowable.bpmn.model.VariableAggregationDefinitions;

public class MultiInstanceExport
implements BpmnXMLConstants {
    public static void writeMultiInstance(Activity activity, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        if (activity.getLoopCharacteristics() != null) {
            MultiInstanceLoopCharacteristics multiInstanceObject = activity.getLoopCharacteristics();
            CollectionHandler handler = multiInstanceObject.getHandler();
            boolean didWriteExtensionStartElement = false;
            if (StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getLoopCardinality()) || StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getInputDataItem()) || StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getCompletionCondition()) || StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getCollectionString())) {
                Map extensions;
                VariableAggregationDefinitions aggregations;
                xtw.writeStartElement("multiInstanceLoopCharacteristics");
                BpmnXMLUtil.writeDefaultAttribute("isSequential", String.valueOf(multiInstanceObject.isSequential()).toLowerCase(), xtw);
                if (handler == null && StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getInputDataItem())) {
                    BpmnXMLUtil.writeQualifiedAttribute("collection", multiInstanceObject.getInputDataItem(), xtw);
                }
                if (StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getElementVariable())) {
                    BpmnXMLUtil.writeQualifiedAttribute("elementVariable", multiInstanceObject.getElementVariable(), xtw);
                }
                if (StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getElementIndexVariable())) {
                    BpmnXMLUtil.writeQualifiedAttribute("elementIndexVariable", multiInstanceObject.getElementIndexVariable(), xtw);
                }
                if (multiInstanceObject.isNoWaitStatesAsyncLeave()) {
                    BpmnXMLUtil.writeQualifiedAttribute("noWaitStatesAsyncLeave", "true", xtw);
                }
                if (handler != null) {
                    xtw.writeStartElement("extensionElements");
                    didWriteExtensionStartElement = true;
                    xtw.writeStartElement("http://flowable.org/bpmn", "collection");
                    BpmnXMLUtil.writeQualifiedAttribute(handler.getImplementationType(), handler.getImplementation(), xtw);
                    if (StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getInputDataItem())) {
                        xtw.writeStartElement("http://flowable.org/bpmn", "expression");
                        xtw.writeCharacters(multiInstanceObject.getInputDataItem());
                        xtw.writeEndElement();
                    } else if (StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getCollectionString())) {
                        xtw.writeStartElement("http://flowable.org/bpmn", "string");
                        xtw.writeCData(multiInstanceObject.getCollectionString().trim());
                        xtw.writeEndElement();
                    }
                    xtw.writeEndElement();
                }
                if ((aggregations = multiInstanceObject.getAggregations()) != null) {
                    if (!didWriteExtensionStartElement) {
                        xtw.writeStartElement("extensionElements");
                        didWriteExtensionStartElement = true;
                    }
                    for (VariableAggregationDefinition aggregation : aggregations.getAggregations()) {
                        xtw.writeStartElement("http://flowable.org/bpmn", "variableAggregation");
                        BpmnXMLUtil.writeDefaultAttribute("target", aggregation.getTarget(), xtw);
                        BpmnXMLUtil.writeDefaultAttribute("targetExpression", aggregation.getTargetExpression(), xtw);
                        if (aggregation.isStoreAsTransientVariable()) {
                            BpmnXMLUtil.writeDefaultAttribute("storeAsTransientVariable", "true", xtw);
                        }
                        if (aggregation.isCreateOverviewVariable()) {
                            BpmnXMLUtil.writeDefaultAttribute("createOverviewVariable", "true", xtw);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)aggregation.getImplementationType())) {
                            BpmnXMLUtil.writeDefaultAttribute(aggregation.getImplementationType(), aggregation.getImplementation(), xtw);
                        }
                        for (VariableAggregationDefinition.Variable definition : aggregation.getDefinitions()) {
                            xtw.writeStartElement("variable");
                            BpmnXMLUtil.writeDefaultAttribute("source", definition.getSource(), xtw);
                            BpmnXMLUtil.writeDefaultAttribute("sourceExpression", definition.getSourceExpression(), xtw);
                            BpmnXMLUtil.writeDefaultAttribute("target", definition.getTarget(), xtw);
                            BpmnXMLUtil.writeDefaultAttribute("targetExpression", definition.getTargetExpression(), xtw);
                            xtw.writeEndElement();
                        }
                        xtw.writeEndElement();
                    }
                }
                if (!(extensions = multiInstanceObject.getExtensionElements()).isEmpty()) {
                    didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)multiInstanceObject, didWriteExtensionStartElement, model.getNamespaces(), xtw);
                }
                if (didWriteExtensionStartElement) {
                    xtw.writeEndElement();
                }
                if (StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getLoopCardinality())) {
                    xtw.writeStartElement("loopCardinality");
                    xtw.writeCharacters(multiInstanceObject.getLoopCardinality());
                    xtw.writeEndElement();
                }
                if (StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getCompletionCondition())) {
                    xtw.writeStartElement("completionCondition");
                    xtw.writeCharacters(multiInstanceObject.getCompletionCondition());
                    xtw.writeEndElement();
                }
                xtw.writeEndElement();
            }
        }
    }
}

