/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.bloodhound;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.bloodhound.Prefetch;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.bloodhound.Remote;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.util.Json;

public class BloodhoundConfig
extends AbstractConfig {
    private static final IKey<Json.RawValue> DatumTokenizer = BloodhoundConfig.newKey((String)"datumTokenizer", null);
    private static final IKey<Json.RawValue> QueryTokenizer = BloodhoundConfig.newKey((String)"queryTokenizer", null);
    private static final IKey<Integer> Limit = BloodhoundConfig.newKey((String)"limit", (Object)5);
    private static final IKey<Json.RawValue> DupDetector = BloodhoundConfig.newKey((String)"dupDetector", null);
    private static final IKey<Json.RawValue> Sorter = BloodhoundConfig.newKey((String)"sorter", null);
    private static final IKey<Json.RawValue> Local = BloodhoundConfig.newKey((String)"local", null);
    private static final IKey<Prefetch> Prefetch = BloodhoundConfig.newKey((String)"prefetch", null);
    private static final IKey<Remote> Remote = BloodhoundConfig.newKey((String)"remote", null);

    public BloodhoundConfig() {
        this(BloodhoundConfig.whitespaceDatumTokenizer("value"), BloodhoundConfig.queryWhitespaceTokenizer());
    }

    public BloodhoundConfig(Json.RawValue datumTokenizer, Json.RawValue queryTokenizer) {
        if (datumTokenizer == null) {
            throw new IllegalArgumentException("You need to specify a datumTokenizer");
        }
        if (queryTokenizer == null) {
            throw new IllegalArgumentException("You need to specify a queryTokenizer");
        }
        this.put(DatumTokenizer, datumTokenizer);
        this.put(QueryTokenizer, queryTokenizer);
    }

    public static Json.RawValue whitespaceDatumTokenizer(String param) {
        return new Json.RawValue(String.format("function(d) { return Bloodhound.tokenizers.whitespace(d.%s); }", param));
    }

    public static Json.RawValue queryWhitespaceTokenizer() {
        return new Json.RawValue("Bloodhound.tokenizers.whitespace");
    }

    public BloodhoundConfig withLimit(int limit) {
        this.put(Limit, limit);
        return this;
    }

    public BloodhoundConfig withDupDetector(Json.RawValue detector) {
        this.put(DupDetector, detector);
        return this;
    }

    public BloodhoundConfig withSorter(Json.RawValue sorter) {
        this.put(Sorter, sorter);
        return this;
    }

    public BloodhoundConfig withLocal(Json.RawValue local) {
        this.put(Local, local);
        return this;
    }

    public BloodhoundConfig withPrefetch(Prefetch prefetch) {
        this.put(Prefetch, (Object)prefetch);
        return this;
    }

    public BloodhoundConfig withRemote(Remote remote) {
        this.put(Remote, (Object)remote);
        return this;
    }

    public Prefetch getPrefetch() {
        return (Prefetch)((Object)this.get(Prefetch));
    }

    public Remote getRemote() {
        return (Remote)((Object)this.get(Remote));
    }

    public Json.RawValue getLocal() {
        return (Json.RawValue)this.get(Local);
    }
}

