/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.support.saml.services.BaseSamlRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class AuthnRequestRequestedAttributesAttributeReleasePolicy
extends BaseSamlRegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthnRequestRequestedAttributesAttributeReleasePolicy.class);
    private static final long serialVersionUID = -3483733307124962357L;
    private boolean useFriendlyName;

    @Override
    protected Map<String, List<Object>> getAttributesForSamlRegisteredService(Map<String, List<Object>> attributes, ApplicationContext applicationContext, SamlRegisteredServiceCachingMetadataResolver resolver, SamlRegisteredServiceServiceProviderMetadataFacade facade, EntityDescriptor entityDescriptor, RegisteredServiceAttributeReleasePolicyContext context) {
        HashMap releaseAttributes = new HashMap();
        AuthnRequestRequestedAttributesAttributeReleasePolicy.getSamlAuthnRequest(applicationContext).ifPresent(authnRequest -> {
            if (authnRequest.getExtensions() != null) {
                authnRequest.getExtensions().getUnknownXMLObjects().stream().filter(object -> object instanceof RequestedAttribute).map(object -> (RequestedAttribute)object).filter(attr -> {
                    String name = this.useFriendlyName ? attr.getFriendlyName() : attr.getName();
                    LOGGER.debug("Checking for requested attribute [{}] in metadata for [{}]", (Object)name, (Object)context.getRegisteredService().getName());
                    return attributes.containsKey(name);
                }).forEach(attr -> {
                    String name = this.useFriendlyName ? attr.getFriendlyName() : attr.getName();
                    LOGGER.debug("Found requested attribute [{}] in metadata for [{}]", (Object)name, (Object)context.getRegisteredService().getName());
                    releaseAttributes.put(name, (List)attributes.get(name));
                });
            }
        });
        return this.authorizeReleaseOfAllowedAttributes(context, releaseAttributes);
    }

    protected List<String> determineRequestedAttributeDefinitions(RegisteredServiceAttributeReleasePolicyContext context) {
        ArrayList<String> definitions = new ArrayList<String>();
        ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
        AuthnRequestRequestedAttributesAttributeReleasePolicy.getSamlAuthnRequest(applicationContext).ifPresent(authnRequest -> {
            if (authnRequest.getExtensions() != null) {
                authnRequest.getExtensions().getUnknownXMLObjects().stream().filter(object -> object instanceof RequestedAttribute).map(object -> (RequestedAttribute)object).forEach(attr -> {
                    String name = this.useFriendlyName ? attr.getFriendlyName() : attr.getName();
                    LOGGER.debug("Found requested attribute [{}] in metadata for [{}]", (Object)name, (Object)context.getRegisteredService().getName());
                    definitions.add(name);
                });
            }
        });
        return definitions;
    }

    @Generated
    public String toString() {
        return "AuthnRequestRequestedAttributesAttributeReleasePolicy(super=" + super.toString() + ", useFriendlyName=" + this.useFriendlyName + ")";
    }

    @Generated
    public void setUseFriendlyName(boolean useFriendlyName) {
        this.useFriendlyName = useFriendlyName;
    }

    @Generated
    public boolean isUseFriendlyName() {
        return this.useFriendlyName;
    }

    @Generated
    public AuthnRequestRequestedAttributesAttributeReleasePolicy(boolean useFriendlyName) {
        this.useFriendlyName = useFriendlyName;
    }

    @Generated
    public AuthnRequestRequestedAttributesAttributeReleasePolicy() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthnRequestRequestedAttributesAttributeReleasePolicy)) {
            return false;
        }
        AuthnRequestRequestedAttributesAttributeReleasePolicy other = (AuthnRequestRequestedAttributesAttributeReleasePolicy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.useFriendlyName == other.useFriendlyName;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthnRequestRequestedAttributesAttributeReleasePolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.useFriendlyName ? 79 : 97);
        return result;
    }
}

