/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authorization;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authorization.BaseUseAttributesAuthorizationGenerator;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchOperation;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapUserAttributesToRolesAuthorizationGenerator
extends BaseUseAttributesAuthorizationGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapUserAttributesToRolesAuthorizationGenerator.class);
    private final String roleAttribute;
    private final String rolePrefix;

    public LdapUserAttributesToRolesAuthorizationGenerator(SearchOperation userSearchOperation, boolean allowMultipleResults, String roleAttribute, String rolePrefix) {
        super(userSearchOperation, allowMultipleResults);
        this.roleAttribute = roleAttribute;
        this.rolePrefix = rolePrefix;
    }

    @Override
    protected Optional<UserProfile> generateAuthorizationForLdapEntry(UserProfile profile, LdapEntry userEntry) {
        if (!userEntry.getAttributes().isEmpty()) {
            LdapAttribute attribute = userEntry.getAttribute(this.roleAttribute);
            if (attribute != null) {
                this.addProfileRoles(userEntry, profile, attribute, this.rolePrefix);
            } else {
                LOGGER.warn("Configured role attribute cannot be found for this user");
            }
        } else {
            LOGGER.warn("No attributes are retrieved for this user.");
        }
        return Optional.ofNullable(profile);
    }

    @Generated
    public String getRoleAttribute() {
        return this.roleAttribute;
    }

    @Generated
    public String getRolePrefix() {
        return this.rolePrefix;
    }
}

