/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authorization;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authorization.BaseUseAttributesAuthorizationGenerator;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchResponse;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapUserGroupsToRolesAuthorizationGenerator
extends BaseUseAttributesAuthorizationGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapUserGroupsToRolesAuthorizationGenerator.class);
    private final String groupAttributeName;
    private final String groupPrefix;
    private final SearchOperation groupSearchOperation;

    public LdapUserGroupsToRolesAuthorizationGenerator(SearchOperation userSearchOperation, boolean allowMultipleResults, String groupAttributeName, String groupPrefix, SearchOperation groupSearchOperation) {
        super(userSearchOperation, allowMultipleResults);
        this.groupAttributeName = groupAttributeName;
        this.groupPrefix = groupPrefix;
        this.groupSearchOperation = groupSearchOperation;
    }

    @Override
    protected Optional<UserProfile> generateAuthorizationForLdapEntry(UserProfile profile, LdapEntry userEntry) {
        LOGGER.debug("Attempting to get roles for user [{}].", (Object)userEntry.getDn());
        SearchResponse response = (SearchResponse)FunctionUtils.doUnchecked(() -> this.groupSearchOperation.execute(LdapUtils.newLdaptiveSearchFilter(this.groupSearchOperation.getTemplate().getFilter(), "user", (List<String>)CollectionUtils.wrap((Object)userEntry.getDn()))));
        LOGGER.debug("LDAP role search response: [{}]", (Object)response);
        for (LdapEntry entry : response.getEntries()) {
            LdapAttribute groupAttribute = entry.getAttribute(this.groupAttributeName);
            if (groupAttribute == null) {
                LOGGER.warn("Role attribute not found on entry [{}]", (Object)entry);
                continue;
            }
            this.addProfileRolesFromAttributes(profile, groupAttribute, this.groupPrefix);
        }
        return Optional.ofNullable(profile);
    }
}

