/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.logout;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.slo.SingleLogoutUrl;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.web.controllers.BaseOidcController;
import org.apereo.cas.oidc.web.controllers.logout.OidcPostLogoutRedirectUrlMatcher;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.support.WebUtils;
import org.jose4j.jwt.JwtClaims;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriComponentsBuilder;

public class OidcLogoutEndpointController
extends BaseOidcController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcLogoutEndpointController.class);
    private final UrlValidator urlValidator;
    private final OidcPostLogoutRedirectUrlMatcher postLogoutRedirectUrlMatcher;

    public OidcLogoutEndpointController(OidcConfigurationContext context, OidcPostLogoutRedirectUrlMatcher postLogoutRedirectUrlMatcher, UrlValidator urlValidator) {
        super(context);
        this.urlValidator = urlValidator;
        this.postLogoutRedirectUrlMatcher = postLogoutRedirectUrlMatcher;
    }

    @GetMapping(value={"/oidc/oidcLogout", "/oidc/logout", "/**/oidcLogout"})
    public ResponseEntity handleRequestInternal(@RequestParam(value="post_logout_redirect_uri", required=false) String postLogoutRedirectUrl, @RequestParam(value="state", required=false) String state, @RequestParam(value="id_token_hint", required=false) String idToken, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, "oidcLogout")) {
            String body = OAuth20Utils.toJson((Object)OAuth20Utils.getErrorResponseBody((String)"invalid_request", (String)"Invalid issuer"));
            return new ResponseEntity((Object)body, HttpStatus.BAD_REQUEST);
        }
        String clientId = null;
        if (StringUtils.isNotBlank((CharSequence)idToken)) {
            Optional<String> validURL;
            LOGGER.trace("Decoding logout id token [{}]", (Object)idToken);
            OidcConfigurationContext configContext = (OidcConfigurationContext)this.getConfigurationContext();
            JwtClaims claims = configContext.getIdTokenSigningAndEncryptionService().decode(idToken, Optional.empty());
            clientId = claims.getStringClaimValue("client_id");
            LOGGER.debug("Client id retrieved from id token is [{}]", (Object)clientId);
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)configContext.getServicesManager(), (String)clientId);
            LOGGER.debug("Located registered service [{}]", (Object)registeredService);
            WebApplicationService service = (WebApplicationService)configContext.getWebApplicationServiceServiceFactory().createService(clientId);
            AuditableContext audit = AuditableContext.builder().service((Service)service).registeredService((RegisteredService)registeredService).build();
            AuditableExecutionResult accessResult = configContext.getRegisteredServiceAccessStrategyEnforcer().execute(audit);
            accessResult.throwExceptionIfNeeded();
            WebUtils.putRegisteredService((HttpServletRequest)request, (RegisteredService)((RegisteredService)Objects.requireNonNull(registeredService)));
            List urls = configContext.getSingleLogoutServiceLogoutUrlBuilder().determineLogoutUrl((RegisteredService)registeredService, service, Optional.of(request)).stream().map(SingleLogoutUrl::getUrl).collect(Collectors.toList());
            LOGGER.debug("Logout urls assigned to registered service are [{}]", urls);
            if (StringUtils.isNotBlank((CharSequence)postLogoutRedirectUrl) && registeredService.getMatchingStrategy() != null) {
                boolean matchResult;
                boolean bl = matchResult = registeredService.matches(postLogoutRedirectUrl) || urls.stream().anyMatch(url -> this.postLogoutRedirectUrlMatcher.matches(postLogoutRedirectUrl, (String)url));
                if (matchResult) {
                    LOGGER.debug("Requested logout URL [{}] is authorized for redirects", (Object)postLogoutRedirectUrl);
                    return new ResponseEntity(this.executeLogoutRedirect(Optional.ofNullable(StringUtils.trimToNull((String)state)), Optional.of(postLogoutRedirectUrl), Optional.of(clientId), request, response));
                }
            }
            if ((validURL = urls.stream().filter(arg_0 -> ((UrlValidator)this.urlValidator).isValid(arg_0)).findFirst()).isPresent()) {
                return new ResponseEntity(this.executeLogoutRedirect(Optional.ofNullable(StringUtils.trimToNull((String)state)), validURL, Optional.of(clientId), request, response));
            }
            LOGGER.debug("No logout urls could be determined for registered service [{}]", (Object)registeredService.getName());
        }
        return new ResponseEntity(this.executeLogoutRedirect(Optional.ofNullable(StringUtils.trimToNull((String)state)), Optional.empty(), Optional.ofNullable(clientId), request, response));
    }

    protected HttpStatus executeLogoutRedirect(Optional<String> state, Optional<String> redirectUrl, Optional<String> clientId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        redirectUrl.ifPresent(url -> {
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
            state.ifPresent(st -> builder.queryParam("state", new Object[]{st}));
            clientId.ifPresent(id -> builder.queryParam("client_id", new Object[]{id}));
            String logoutUrl = builder.build().toUriString();
            LOGGER.debug("Final logout redirect URL is [{}]", (Object)logoutUrl);
            WebUtils.putLogoutRedirectUrl((HttpServletRequest)request, (String)logoutUrl);
        });
        request.getServletContext().getRequestDispatcher("/logout").forward((ServletRequest)request, (ServletResponse)response);
        return HttpStatus.PERMANENT_REDIRECT;
    }
}

