/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnFeaturesEnabled;
import org.apereo.cas.web.flow.CasDefaultFlowUrlHandler;
import org.apereo.cas.web.flow.CasFlowHandlerAdapter;
import org.apereo.cas.web.flow.CasFlowHandlerMapping;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.configurer.acct.AccountProfileWebflowConfigurer;
import org.apereo.cas.web.flow.executor.WebflowExecutorFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.executor.FlowExecutor;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeaturesEnabled(value={@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.Webflow), @ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.AccountManagement, enabledByDefault=false)})
@AutoConfiguration
public class CasWebflowAccountProfileConfiguration {
    private static final FlowExecutionListener[] FLOW_EXECUTION_LISTENERS = new FlowExecutionListener[0];

    @ConditionalOnMissingBean(name={"accountProfileWebflowConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasWebflowConfigurer accountProfileWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowRegistry, @Qualifier(value="accountProfileFlowRegistry") FlowDefinitionRegistry accountProfileFlowRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
        return new AccountProfileWebflowConfigurer(flowBuilderServices, accountProfileFlowRegistry, loginFlowRegistry, applicationContext, casProperties);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"accountProfileWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer accountProfileWebflowExecutionPlanConfigurer(@Qualifier(value="accountProfileWebflowConfigurer") CasWebflowConfigurer accountProfileWebflowConfigurer) {
        return plan -> plan.registerWebflowConfigurer(accountProfileWebflowConfigurer);
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public FlowExecutor accountProfileFlowExecutor(CasConfigurationProperties casProperties, @Qualifier(value="accountProfileFlowRegistry") FlowDefinitionRegistry accountProfileFlowRegistry, @Qualifier(value="webflowCipherExecutor") CipherExecutor webflowCipherExecutor) {
        WebflowExecutorFactory factory = new WebflowExecutorFactory(casProperties.getWebflow(), accountProfileFlowRegistry, webflowCipherExecutor, FLOW_EXECUTION_LISTENERS);
        return factory.build();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public FlowDefinitionRegistry accountProfileFlowRegistry(ConfigurableApplicationContext applicationContext, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="flowBuilder") FlowBuilder flowBuilder) {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)applicationContext, flowBuilderServices);
        builder.addFlowBuilder(flowBuilder, "account");
        return builder.build();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public HandlerAdapter accountProfileWebflowHandlerAdapter(@Qualifier(value="accountProfileFlowExecutor") FlowExecutor accountProfileFlowExecutor) {
        CasFlowHandlerAdapter handler = new CasFlowHandlerAdapter("account");
        handler.setFlowExecutor(accountProfileFlowExecutor);
        handler.setFlowUrlHandler((FlowUrlHandler)new CasDefaultFlowUrlHandler());
        return handler;
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public HandlerMapping accountProfileFlowHandlerMapping(@Qualifier(value="casWebflowExecutionPlan") CasWebflowExecutionPlan webflowExecutionPlan, @Qualifier(value="accountProfileFlowRegistry") FlowDefinitionRegistry accountProfileFlowRegistry) {
        CasFlowHandlerMapping handler = new CasFlowHandlerMapping();
        handler.setOrder(0);
        handler.setFlowRegistry(accountProfileFlowRegistry);
        handler.setInterceptors(webflowExecutionPlan.getWebflowInterceptors().toArray());
        return handler;
    }
}

