/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springmodules.cache.provider.CacheManagerFactoryBean;

public abstract class AbstractCacheManagerFactoryBean
implements CacheManagerFactoryBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String cacheProviderName;
    private Resource configLocation;

    public final void afterPropertiesSet() throws Exception {
        this.cacheProviderName = this.getCacheProviderName();
        this.logger.info((Object)("Creating the " + this.cacheProviderName + " cache manager."));
        this.createCacheManager();
    }

    public final void destroy() throws Exception {
        if (this.getObject() != null) {
            this.logger.info((Object)("Shutting down the " + this.cacheProviderName + " cache manager."));
            this.destroyCacheManager();
        } else {
            this.logger.info((Object)("The " + this.cacheProviderName + " cache manager was not built. No need to shut it down."));
        }
    }

    public boolean isSingleton() {
        return true;
    }

    public final void setConfigLocation(Resource newConfigLocation) {
        this.configLocation = newConfigLocation;
    }

    protected abstract void createCacheManager() throws Exception;

    protected abstract void destroyCacheManager() throws Exception;

    protected abstract String getCacheProviderName();

    protected final Resource getConfigLocation() {
        return this.configLocation;
    }

    protected final Properties getConfigProperties() throws IOException {
        Properties properties = null;
        if (this.configLocation != null) {
            properties = new Properties();
            properties.load(this.configLocation.getInputStream());
        }
        return properties;
    }
}

