/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.audit;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;

public class OAuth20UserProfileDataAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    public String[] resolveFrom(JoinPoint auditableTarget, Object retval) {
        Object clientId;
        Objects.requireNonNull(retval, "User profile data must not be null");
        Map profileMap = (Map)Map.class.cast(retval);
        OAuth20AccessToken accessToken = (OAuth20AccessToken)OAuth20AccessToken.class.cast(auditableTarget.getArgs()[0]);
        Object service = profileMap.get("service");
        if (service == null) {
            service = accessToken.getService();
        }
        if ((clientId = profileMap.get("client_id")) == null) {
            clientId = accessToken.getClientId();
        }
        HashMap values = new HashMap();
        values.put("id", profileMap.get("id"));
        values.put("client_id", clientId);
        values.put("service", service);
        values.put("scopes", accessToken.getScopes());
        values.put("attributes", profileMap.get("attributes"));
        return new String[]{this.auditFormat.serialize(values)};
    }
}

