/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.impl.api.ObjectStreamHandler;
import org.identityconnectors.framework.spi.SearchResultsHandler;

public class StreamHandlerUtil {
    public static boolean isAdaptableToObjectStreamHandler(Class<?> clazz) {
        return ResultsHandler.class.isAssignableFrom(clazz) || SyncResultsHandler.class.isAssignableFrom(clazz);
    }

    public static ObjectStreamHandler adaptToObjectStreamHandler(Class<?> interfaceType, Object target) {
        return new ObjectStreamHandlerAdapter(interfaceType, target);
    }

    public static Object adaptFromObjectStreamHandler(Class<?> interfaceType, ObjectStreamHandler target) {
        if (interfaceType == ResultsHandler.class || interfaceType == SearchResultsHandler.class) {
            return new SearchResultsHandlerAdapter(target);
        }
        if (interfaceType == SyncResultsHandler.class) {
            return new SyncResultsHandlerAdapter(target);
        }
        throw new UnsupportedOperationException("Unhandled case: " + interfaceType);
    }

    private static class ObjectStreamHandlerAdapter
    implements ObjectStreamHandler {
        private final Class<?> targetInterface;
        private final Object target;

        public ObjectStreamHandlerAdapter(Class<?> targetInterface, Object target) {
            Assertions.nullCheck(targetInterface, (String)"targetInterface");
            Assertions.nullCheck((Object)target, (String)"target");
            if (!targetInterface.isInstance(target)) {
                throw new IllegalArgumentException("Target" + targetInterface + " " + target);
            }
            if (!StreamHandlerUtil.isAdaptableToObjectStreamHandler(targetInterface)) {
                throw new IllegalArgumentException("Target interface not supported: " + targetInterface);
            }
            this.targetInterface = targetInterface;
            this.target = target;
        }

        @Override
        public boolean handle(Object obj) {
            if (this.targetInterface == ResultsHandler.class || this.targetInterface == SearchResultsHandler.class) {
                if (obj instanceof ConnectorObject) {
                    return ((ResultsHandler)this.target).handle((ConnectorObject)obj);
                }
                if (obj instanceof SearchResult) {
                    ((SearchResultsHandler)this.target).handleResult((SearchResult)obj);
                    return true;
                }
            } else if (this.targetInterface == SyncResultsHandler.class) {
                return ((SyncResultsHandler)this.target).handle((SyncDelta)obj);
            }
            throw new UnsupportedOperationException("Unhandled case: " + this.targetInterface);
        }
    }

    private static class SyncResultsHandlerAdapter
    implements SyncResultsHandler {
        private final ObjectStreamHandler target;

        public SyncResultsHandlerAdapter(ObjectStreamHandler target) {
            this.target = target;
        }

        public boolean handle(SyncDelta obj) {
            return this.target.handle(obj);
        }
    }

    private static class SearchResultsHandlerAdapter
    implements SearchResultsHandler {
        private final ObjectStreamHandler target;

        public SearchResultsHandlerAdapter(ObjectStreamHandler target) {
            this.target = target;
        }

        public void handleResult(SearchResult result) {
            this.target.handle(result);
        }

        public boolean handle(ConnectorObject obj) {
            return this.target.handle(obj);
        }
    }
}

