/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.strats.AbstractFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationStrategies;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;

public abstract class ContainerFieldStrategy
extends AbstractFieldStrategy {
    private static final long serialVersionUID = 1L;

    protected abstract ClassMapping[] getIndependentElementMappings(boolean var1);

    @Override
    public void appendIsEmpty(SQLBuffer sql, Select sel, Joins joins) {
        this.testEmpty(sql, sel, joins, true);
    }

    @Override
    public void appendIsNotEmpty(SQLBuffer sql, Select sel, Joins joins) {
        this.testEmpty(sql, sel, joins, false);
    }

    @Override
    public void appendIsNull(SQLBuffer sql, Select sel, Joins joins) {
        this.testEmpty(sql, sel, joins, true);
    }

    @Override
    public void appendIsNotNull(SQLBuffer sql, Select sel, Joins joins) {
        this.testEmpty(sql, sel, joins, false);
    }

    private void testEmpty(SQLBuffer sql, Select sel, Joins joins, boolean empty) {
        if (empty) {
            sql.append("0 = ");
        } else {
            sql.append("0 < ");
        }
        this.appendSize(sql, sel, joins);
    }

    public abstract ForeignKey getJoinForeignKey();

    @Override
    public void appendSize(SQLBuffer sql, Select sel, Joins joins) {
        DBDictionary dict = this.field.getMappingRepository().getDBDictionary();
        dict.assertSupport(dict.supportsSubselect, "SupportsSubselect");
        ClassMapping[] ind = this.getIndependentElementMappings(false);
        if (ind != null && ind.length > 1) {
            throw RelationStrategies.unjoinable(this.field);
        }
        ForeignKey fk = this.getJoinForeignKey();
        ContainerFieldStrategy.appendJoinCount(sql, sel, joins, dict, this.field, fk);
    }

    @Override
    public void appendIndex(SQLBuffer sql, Select sel, Joins joins) {
        sql.append(sel.getColumnAlias(this.field.getOrderColumn(), this.field.getName()));
    }

    protected static void appendJoinCount(SQLBuffer sql, Select sel, Joins joins, DBDictionary dict, FieldMapping field, ForeignKey fk) {
        String fullTable = dict.getFullName(fk.getTable(), false);
        sql.append("(SELECT COUNT(*) FROM ").append(fullTable).append(" WHERE ");
        ContainerFieldStrategy.appendUnaliasedJoin(sql, sel, joins, dict, field, fk);
        sql.append(")");
    }

    public static void appendUnaliasedJoin(SQLBuffer sql, Select sel, Joins joins, DBDictionary dict, FieldMapping field, ForeignKey fk) {
        String fullTable = dict.getFullName(fk.getTable(), false);
        Column[] cols = fk.getColumns();
        Column[] pks = fk.getPrimaryKeyColumns();
        int count = 0;
        int i = 0;
        while (i < cols.length) {
            if (count > 0) {
                sql.append(" AND ");
            }
            sql.append(fullTable).append(".").append(cols[i]).append(" = ").append(sel.getColumnAlias(pks[i], joins));
            ++i;
            ++count;
        }
        cols = fk.getConstantColumns();
        i = 0;
        while (i < cols.length) {
            if (count > 0) {
                sql.append(" AND ");
            }
            sql.append(fullTable).append(".").append(cols[i]).append(" = ").appendValue(fk.getConstant(cols[i]), cols[i]);
            ++i;
            ++count;
        }
        pks = fk.getConstantPrimaryKeyColumns();
        i = 0;
        while (i < pks.length) {
            if (count > 0) {
                sql.append(" AND ");
            }
            sql.append(sel.getColumnAlias(pks[i], joins)).append(" = ").appendValue(fk.getPrimaryKeyConstant(pks[i]), pks[i]);
            ++i;
            ++count;
        }
    }
}

