/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.AuthenticatedStateCommand;
import javax.mail.Quota;

public class SetQuotaCommand
extends AuthenticatedStateCommand {
    public static final String NAME = "SETQUOTA";

    SetQuotaCommand() {
        super(NAME, null);
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) {
        if (!session.getHost().getStore().isQuotaSupported()) {
            response.commandFailed(this, "Quota is not supported. Activate quota capability first");
        }
        try {
            String root = this.parser.mailbox(request);
            Quota quota = new Quota(root);
            this.parser.consumeChar(request, ' ');
            this.parser.consumeChar(request, '(');
            this.parseAndUpdateResourceLimit(request, quota);
            char c = request.nextWordChar();
            if (')' != c) {
                this.parseAndUpdateResourceLimit(request, quota);
            }
            this.parser.consumeChar(request, ')');
            session.getHost().getStore().setQuota(quota, session.getUser().getQualifiedMailboxName());
            response.commandComplete(this);
        }
        catch (ProtocolException e) {
            response.commandFailed(this, "Can not parse command " + this.getName() + ": " + e.getMessage());
        }
    }

    private void parseAndUpdateResourceLimit(ImapRequestLineReader request, Quota quota) throws ProtocolException {
        String astring = this.parser.astring(request);
        try {
            String value = this.parser.atomOnly(request);
            long limit = Long.parseLong(value);
            if (limit < 0L) {
                throw new ProtocolException("Expected number (positive integer) but got " + limit);
            }
            quota.setResourceLimit(astring, limit);
        }
        catch (ProtocolException | NumberFormatException ex) {
            throw new ProtocolException("Failed to parse quota " + quota.quotaRoot + " resource limit " + astring + " value: " + ex.getMessage(), ex);
        }
    }
}

