/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.encoder;

public class LayersInfo {
    private static final int SZ_INIT = 10;
    private static final int SZ_INCR = 5;
    int totlyrs = 1;
    float totbrate;
    int nopt;
    float[] optbrate = new float[10];
    int[] extralyrs = new int[10];

    public LayersInfo(float brate) {
        if (brate <= 0.0f) {
            throw new IllegalArgumentException("Overall target bitrate must be a positive number");
        }
        this.totbrate = brate;
    }

    public float getTotBitrate() {
        return this.totbrate;
    }

    public int getTotNumLayers() {
        return this.totlyrs;
    }

    public int getNOptPoints() {
        return this.nopt + 1;
    }

    public float getTargetBitrate(int n) {
        return n < this.nopt ? this.optbrate[n] : this.totbrate;
    }

    public int getExtraLayers(int n) {
        return n < this.nopt ? this.extralyrs[n] : 0;
    }

    public void addOptPoint(float brate, int elyrs) {
        if (brate <= 0.0f) {
            throw new IllegalArgumentException("Target bitrate must be positive");
        }
        if (elyrs < 0) {
            throw new IllegalArgumentException("The number of extra layers must be 0 or more");
        }
        if (this.nopt > 0 && this.optbrate[this.nopt - 1] >= brate) {
            throw new IllegalArgumentException("New optimization point must have a target bitrate higher than the preceding one");
        }
        if (this.optbrate.length == this.nopt) {
            float[] tbr = this.optbrate;
            int[] tel = this.extralyrs;
            this.optbrate = new float[this.optbrate.length + 5];
            this.extralyrs = new int[this.extralyrs.length + 5];
            System.arraycopy(tbr, 0, this.optbrate, 0, this.nopt);
            System.arraycopy(tel, 0, this.extralyrs, 0, this.nopt);
        }
        this.optbrate[this.nopt] = brate;
        this.extralyrs[this.nopt] = elyrs;
        ++this.nopt;
        this.totlyrs += 1 + elyrs;
    }
}

