/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.Advice;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.Statement;
import org.opensaml.xmlsec.signature.Signature;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AssertionUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    @Nonnull
    public XMLObject unmarshall(@Nonnull Element domElement) throws UnmarshallingException {
        Assertion assertion = (Assertion)super.unmarshall(domElement);
        if (assertion.getMinorVersion() != 0 && !Strings.isNullOrEmpty((String)assertion.getID())) {
            XMLObjectSupport.marshallAttributeIDness(null, (String)"AssertionID", (Element)domElement, (boolean)true);
        }
        return assertion;
    }

    protected void processChildElement(@Nonnull XMLObject parentObject, @Nonnull XMLObject childObject) throws UnmarshallingException {
        Assertion assertion = (Assertion)parentObject;
        if (childObject instanceof Signature) {
            assertion.setSignature((Signature)childObject);
        } else if (childObject instanceof Conditions) {
            assertion.setConditions((Conditions)childObject);
        } else if (childObject instanceof Advice) {
            assertion.setAdvice((Advice)childObject);
        } else if (childObject instanceof Statement) {
            assertion.getStatements().add((Statement)childObject);
        } else {
            super.processChildElement(parentObject, childObject);
        }
    }

    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        block19: {
            Assertion assertion = (Assertion)xmlObject;
            if (attribute.getNamespaceURI() == null) {
                if ("AssertionID".equals(attribute.getLocalName())) {
                    assertion.setID(attribute.getValue());
                } else if ("Issuer".equals(attribute.getLocalName())) {
                    assertion.setIssuer(attribute.getValue());
                } else if ("IssueInstant".equals(attribute.getLocalName()) && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                    assertion.setIssueInstant(DOMTypeSupport.stringToInstant((String)attribute.getValue()));
                } else {
                    if ("MajorVersion".equals(attribute.getLocalName())) {
                        try {
                            int major = Integer.parseInt(attribute.getValue());
                            if (major != 1) {
                                throw new UnmarshallingException("MajorVersion was invalid, must be 1");
                            }
                            break block19;
                        }
                        catch (NumberFormatException n) {
                            throw new UnmarshallingException((Exception)n);
                        }
                    }
                    if ("MinorVersion".equals(attribute.getLocalName())) {
                        int minor;
                        try {
                            minor = Integer.parseInt(attribute.getValue());
                        }
                        catch (NumberFormatException n) {
                            throw new UnmarshallingException((Exception)n);
                        }
                        if (minor == 0) {
                            assertion.setVersion(SAMLVersion.VERSION_10);
                        } else if (minor == 1) {
                            assertion.setVersion(SAMLVersion.VERSION_11);
                        }
                    } else {
                        super.processAttribute(xmlObject, attribute);
                    }
                }
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        }
    }
}

