/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.transform;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DTDResolver
implements EntityResolver {
    private static final String WEB_SITE_DTD = "http://turbine.apache.org/dtd/intake_2_3_3.dtd";
    private InputSource intakeDTD = null;
    private static Log log = LogFactory.getLog((Class)DTDResolver.class);

    public DTDResolver() {
        try {
            InputStream dtdStream = this.getClass().getResourceAsStream("intake.dtd");
            if (dtdStream != null) {
                this.intakeDTD = new InputSource(dtdStream);
            } else {
                log.warn((Object)"Could not located the intake.dtd");
            }
        }
        catch (Exception ex) {
            log.error((Object)"Could not get stream for dtd", (Throwable)ex);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (this.intakeDTD != null && WEB_SITE_DTD.equals(systemId)) {
            String pkg = this.getClass().getName().substring(0, this.getClass().getName().lastIndexOf("."));
            log.info((Object)("Resolver: used intake.dtd from " + pkg + " package "));
            return this.intakeDTD;
        }
        if (systemId == null) {
            log.info((Object)"Resolver: used intake.dtd from Turbine Web site");
            return this.getInputSource(WEB_SITE_DTD);
        }
        log.info((Object)("Resolver: used System DTD for " + systemId));
        return this.getInputSource(systemId);
    }

    private InputSource getInputSource(String urlString) {
        try {
            URL url = new URL(urlString);
            return new InputSource(url.openStream());
        }
        catch (IOException ex) {
            log.error((Object)("Could not get InputSource for " + urlString), (Throwable)ex);
            return new InputSource();
        }
    }
}

