/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto;

public final class HexConverter {
    private static final char[] HEXTAB = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final String toString(byte[] data) {
        return HexConverter.bytesToHexStr(data, 0, data.length);
    }

    public static final byte[] toBytes(String data) {
        byte[] result = new byte[data.length() / 2];
        HexConverter.hexStrToBytes(data, result, 0, 0, result.length);
        return result;
    }

    private static final String bytesToHexStr(byte[] data, int nOfs, int nLen) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.setLength(nLen << 1);
        int nPos = 0;
        int nC = nOfs + nLen;
        while (nOfs < nC) {
            sbuf.setCharAt(nPos++, HEXTAB[data[nOfs] >> 4 & 0xF]);
            sbuf.setCharAt(nPos++, HEXTAB[data[nOfs++] & 0xF]);
        }
        return sbuf.toString();
    }

    private static final int hexStrToBytes(String sHex, byte[] data, int nSrcOfs, int nDstOfs, int nLen) {
        int nOutputCapacity;
        int nStrLen = sHex.length();
        int nAvailBytes = nStrLen - nSrcOfs >> 1;
        if (nAvailBytes < nLen) {
            nLen = nAvailBytes;
        }
        if (nLen > (nOutputCapacity = data.length - nDstOfs)) {
            nLen = nOutputCapacity;
        }
        int nDstOfsBak = nDstOfs;
        for (int nI = 0; nI < nLen; ++nI) {
            int bActByte = 0;
            boolean blConvertOK = true;
            for (int nJ = 0; nJ < 2; ++nJ) {
                char cActChar;
                bActByte = (byte)(bActByte << 4);
                if ((cActChar = sHex.charAt(nSrcOfs++)) >= 'a' && cActChar <= 'f') {
                    bActByte = (byte)(bActByte | (byte)(cActChar - 97) + 10);
                    continue;
                }
                if (cActChar >= '0' && cActChar <= '9') {
                    bActByte = (byte)(bActByte | (byte)(cActChar - 48));
                    continue;
                }
                blConvertOK = false;
            }
            if (!blConvertOK) continue;
            data[nDstOfs++] = bActByte;
        }
        return nDstOfs - nDstOfsBak;
    }
}

