/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.impl;

import java.io.PrintWriter;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.excalibur.instrument.manager.impl.AbstractValueInstrumentSample;
import org.apache.excalibur.instrument.manager.impl.InstrumentProxy;

class MeanValueInstrumentSample
extends AbstractValueInstrumentSample {
    private long m_valueTotal;

    MeanValueInstrumentSample(InstrumentProxy instrumentProxy, String name, long interval, int size, String description, long lease) {
        super(instrumentProxy, name, interval, size, description, lease);
    }

    public int getType() {
        return 104;
    }

    protected void advanceToNextSample(boolean reset) {
        super.advanceToNextSample(reset);
        this.m_valueTotal = 0L;
    }

    protected void writeStateAttributes(PrintWriter out) {
        super.writeStateAttributes(out);
        out.print(" value-total=\"");
        out.print(this.m_valueTotal);
        out.print("\"");
    }

    protected void loadState(int value, Configuration state) throws ConfigurationException {
        super.loadState(value, state);
        this.m_valueTotal = state.getAttributeAsLong("value-total");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValueInner(int value, long time) {
        long sampleTime;
        int sampleValue;
        MeanValueInstrumentSample meanValueInstrumentSample = this;
        synchronized (meanValueInstrumentSample) {
            this.update(time, false);
            this.m_lastValue = value;
            if (this.m_valueCount > 0) {
                ++this.m_valueCount;
                this.m_valueTotal += (long)value;
                this.m_value = (int)(this.m_valueTotal / (long)this.m_valueCount);
            } else {
                this.m_valueCount = 1;
                this.m_value = value;
                this.m_valueTotal = this.m_value;
            }
            sampleValue = this.m_value;
            sampleTime = this.m_time;
        }
        this.updateListeners(sampleValue, sampleTime);
    }
}

