/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.block;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.disk.LRUMapJCS;
import org.apache.jcs.auxiliary.disk.block.BlockDiskCache;
import org.apache.jcs.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.jcs.auxiliary.disk.block.BlockDiskElementDescriptor;
import org.apache.jcs.utils.timing.ElapsedTimer;

public class BlockDiskKeyStore {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$block$BlockDiskKeyStore == null ? (class$org$apache$jcs$auxiliary$disk$block$BlockDiskKeyStore = BlockDiskKeyStore.class$("org.apache.jcs.auxiliary.disk.block.BlockDiskKeyStore")) : class$org$apache$jcs$auxiliary$disk$block$BlockDiskKeyStore));
    private BlockDiskCacheAttributes blockDiskCacheAttributes;
    private Map keyHash;
    private File keyFile;
    private final String logCacheName;
    private String fileName;
    private int maxKeySize;
    private BlockDiskCache blockDiskCache;
    private File rootDirectory;
    private static ClockDaemon persistenceDaemon;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$block$BlockDiskKeyStore;

    public BlockDiskKeyStore(BlockDiskCacheAttributes cacheAttributes, BlockDiskCache blockDiskCache) throws Exception {
        this.blockDiskCacheAttributes = cacheAttributes;
        this.logCacheName = "Region [" + this.blockDiskCacheAttributes.getCacheName() + "] ";
        this.fileName = this.blockDiskCacheAttributes.getCacheName();
        this.maxKeySize = cacheAttributes.getMaxKeySize();
        this.blockDiskCache = blockDiskCache;
        String rootDirName = cacheAttributes.getDiskPath();
        this.rootDirectory = new File(rootDirName);
        this.rootDirectory.mkdirs();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.logCacheName + "Cache file root directory [" + rootDirName + "]"));
        }
        this.keyFile = new File(this.rootDirectory, this.fileName + ".key");
        if (log.isInfoEnabled()) {
            log.info((Object)(this.logCacheName + "Key File [" + this.keyFile.getAbsolutePath() + "]"));
        }
        if (this.keyFile.length() > 0L) {
            this.loadKeys();
        } else {
            this.initKeyMap();
        }
        if (this.blockDiskCacheAttributes.getKeyPersistenceIntervalSeconds() > 0L) {
            if (persistenceDaemon == null) {
                persistenceDaemon = new ClockDaemon();
                persistenceDaemon.setThreadFactory((ThreadFactory)new MyThreadFactory());
            }
            persistenceDaemon.executePeriodically(this.blockDiskCacheAttributes.getKeyPersistenceIntervalSeconds() * 1000L, new Runnable(){

                public void run() {
                    BlockDiskKeyStore.this.saveKeys();
                }
            }, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveKeys() {
        try {
            ElapsedTimer timer = new ElapsedTimer();
            int numKeys = this.keyHash.size();
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Saving keys to [" + this.keyFile.getAbsolutePath() + "], key count [" + numKeys + "]"));
            }
            this.keyFile.delete();
            this.keyFile = new File(this.rootDirectory, this.fileName + ".key");
            FileOutputStream fos = new FileOutputStream(this.keyFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 1024);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            try {
                Iterator keyIt = this.keyHash.entrySet().iterator();
                while (keyIt.hasNext()) {
                    Map.Entry entry = keyIt.next();
                    BlockDiskElementDescriptor descriptor = new BlockDiskElementDescriptor();
                    descriptor.setKey((Serializable)entry.getKey());
                    descriptor.setBlocks((int[])entry.getValue());
                    oos.writeObject(descriptor);
                }
            }
            finally {
                oos.flush();
                oos.close();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Finished saving keys. It took " + timer.getElapsedTimeString() + " to store " + numKeys + " keys.  Key file length [" + this.keyFile.length() + "]"));
            }
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Problem storing keys."), (Throwable)e);
        }
    }

    protected void reset() {
        File keyFileTemp = new File(this.rootDirectory, this.fileName + ".key");
        keyFileTemp.delete();
        this.keyFile = new File(this.rootDirectory, this.fileName + ".key");
        this.initKeyMap();
    }

    protected void clearMemoryMap() {
        this.keyHash.clear();
    }

    private void initKeyMap() {
        this.keyHash = null;
        if (this.maxKeySize >= 0) {
            this.keyHash = new LRUMap(this.maxKeySize);
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Set maxKeySize to: '" + this.maxKeySize + "'"));
            }
        } else {
            this.keyHash = new HashMap();
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Set maxKeySize to unlimited'"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadKeys() throws InterruptedException {
        if (log.isInfoEnabled()) {
            log.info((Object)(this.logCacheName + "Loading keys for " + this.keyFile.toString()));
        }
        try {
            this.initKeyMap();
            HashMap<Serializable, int[]> keys = new HashMap<Serializable, int[]>();
            FileInputStream fis = new FileInputStream(this.keyFile);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ObjectInputStream ois = new ObjectInputStream(bis);
            try {
                try {
                    while (true) {
                        BlockDiskElementDescriptor descriptor;
                        if ((descriptor = (BlockDiskElementDescriptor)ois.readObject()) == null) {
                            continue;
                        }
                        keys.put(descriptor.getKey(), descriptor.getBlocks());
                    }
                }
                catch (EOFException eof) {
                    ois.close();
                }
            }
            catch (Throwable throwable) {
                ois.close();
                throw throwable;
            }
            if (!keys.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.logCacheName + "Found " + keys.size() + " in keys file."));
                }
                this.keyHash.putAll(keys);
                if (log.isInfoEnabled()) {
                    log.info((Object)(this.logCacheName + "Loaded keys from [" + this.fileName + "], key count: " + this.keyHash.size() + "; up to " + this.maxKeySize + " will be available."));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Problem loading keys for file " + this.fileName), (Throwable)e);
        }
    }

    public Set entrySet() {
        return this.keyHash.entrySet();
    }

    public Set keySet() {
        return this.keyHash.keySet();
    }

    public int size() {
        return this.keyHash.size();
    }

    public int[] get(Object key) {
        return (int[])this.keyHash.get(key);
    }

    public void put(Object key, int[] value) {
        this.keyHash.put(key, value);
    }

    public int[] remove(Object key) {
        return (int[])this.keyHash.remove(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MyThreadFactory
    implements ThreadFactory {
        MyThreadFactory() {
        }

        public Thread newThread(Runnable runner) {
            Thread t = new Thread(runner);
            t.setDaemon(true);
            t.setPriority(1);
            return t;
        }
    }

    public class LRUMap
    extends LRUMapJCS {
        private static final long serialVersionUID = 4955079991472142198L;
        public String tag = "orig";

        public LRUMap() {
        }

        public LRUMap(int maxKeySize) {
            super(maxKeySize);
        }

        protected void processRemovedLRU(Object key, Object value) {
            BlockDiskKeyStore.this.blockDiskCache.freeBlocks((int[])value);
            if (log.isDebugEnabled()) {
                log.debug((Object)(BlockDiskKeyStore.this.logCacheName + "Removing key: [" + key + "] from key store."));
                log.debug((Object)(BlockDiskKeyStore.this.logCacheName + "Key store size: [" + this.size() + "]."));
            }
        }
    }
}

