/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashSet;
import java.util.Properties;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ResultDocument;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Validation;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.EmptySequence;

public class XSLResultDocument
extends StyleElement {
    private static final HashSet fans = new HashSet(25);
    private Expression href;
    private int format = -1;
    private Expression formatExpression = null;
    private int validationAction = 4;
    private SchemaType schemaType = null;
    private IntHashMap serializationAttributes = new IntHashMap(10);

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return null;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string6 = this.getNamePool().getClarkName(n);
            if (string6 == "format") {
                string = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string6 == "href") {
                string2 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string6 == "validation") {
                string3 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string6 == "type") {
                string4 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string6 == "use-character-maps") {
                string5 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (fans.contains(string6) || string6.startsWith("{")) {
                String string7 = attributeCollection.getValue(i).trim();
                Expression expression = this.makeAttributeValueTemplate(string7);
                this.serializationAttributes.put(n & 0xFFFFF, expression);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string2 != null) {
            this.href = this.makeAttributeValueTemplate(string2);
        }
        if (string != null) {
            this.formatExpression = this.makeAttributeValueTemplate(string);
            if (this.formatExpression instanceof StringLiteral) {
                try {
                    this.format = this.makeNameCode(((StringLiteral)this.formatExpression).getStringValue().trim()) & 0xFFFFF;
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage(), "XTSE0280");
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException.getMessage(), "XTDE1460");
                }
            }
        }
        if (string3 == null) {
            this.validationAction = this.getContainingStylesheet().getDefaultValidation();
        } else {
            this.validationAction = Validation.getCode(string3);
            if (this.validationAction != 4 && !this.getConfiguration().isSchemaAware(50)) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
            if (this.validationAction == -1) {
                this.compileError("Invalid value of @validation attribute", "XTSE0020");
            }
        }
        if (string4 != null) {
            if (!this.getConfiguration().isSchemaAware(50)) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.schemaType = this.getSchemaType(string4);
            this.validationAction = 8;
        }
        if (string4 != null && string3 != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
        if (string5 != null) {
            String string8 = XSLOutput.prepareCharacterMaps(this, string5, new Properties());
            this.serializationAttributes.put(this.getNamePool().allocate("", "", "use-character-maps"), new StringLiteral(string8));
        }
    }

    public void validate() throws XPathException {
        if (this.href != null && !this.getPreparedStylesheet().getConfiguration().isAllowExternalFunctions()) {
            this.compileError("xsl:result-document is disabled when extension functions are disabled");
        }
        this.href = this.typeCheck("href", this.href);
        this.formatExpression = this.typeCheck("format", this.formatExpression);
        IntIterator intIterator = this.serializationAttributes.keyIterator();
        while (intIterator.hasNext()) {
            Expression expression;
            int n = intIterator.next();
            String string = this.getNamePool().getDisplayName(n);
            Expression expression2 = (Expression)this.serializationAttributes.get(n);
            if (expression2 == (expression = this.typeCheck(string, expression2))) continue;
            this.serializationAttributes.put(n, expression);
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        Object object;
        Object object2;
        Properties properties;
        if (this.formatExpression == null) {
            try {
                properties = this.getPrincipalStylesheet().gatherOutputProperties(this.format);
            }
            catch (XPathException xPathException) {
                this.compileError("Named output format has not been defined", "XTSE1460");
                return null;
            }
        } else {
            properties = new Properties();
            this.getPrincipalStylesheet().setNeedsDynamicOutputProperties(true);
        }
        int n = this.getNamePool().allocate("", "", "method");
        if (this.formatExpression == null && properties.getProperty("method") == null && this.serializationAttributes.get(n) == null && (object2 = (NodeInfo)(object = this.iterateAxis((byte)3)).next()) instanceof LiteralResultElement) {
            if (object2.getFingerprint() == this.getNamePool().allocate("", "http://www.w3.org/1999/xhtml", "html")) {
                if (this.backwardsCompatibleModeIsEnabled()) {
                    properties.setProperty("method", "xml");
                } else {
                    properties.setProperty("method", "xhtml");
                }
            } else if (object2.getLocalPart().equalsIgnoreCase("html") && object2.getURI().equals("")) {
                properties.setProperty("method", "html");
            } else {
                properties.setProperty("method", "xml");
            }
        }
        object = new Properties();
        object2 = new IntHashSet(10);
        boolean bl = this.formatExpression != null;
        NameChecker nameChecker = executable.getConfiguration().getNameChecker();
        NamespaceResolver namespaceResolver = this.getStaticContext().getNamespaceResolver();
        Object object3 = this.serializationAttributes.keyIterator();
        while (object3.hasNext()) {
            String string;
            int n2 = object3.next();
            Expression expression = (Expression)this.serializationAttributes.get(n2);
            if (expression instanceof StringLiteral) {
                string = ((StringLiteral)expression).getStringValue();
                String string2 = this.getNamePool().getLocalName(n2);
                String string3 = this.getNamePool().getURI(n2);
                try {
                    ResultDocument.setSerializationProperty((Properties)object, string3, string2, string, namespaceResolver, false, nameChecker);
                    ((IntHashSet)object2).add(n2);
                }
                catch (XPathException xPathException) {
                    if ("http://saxon.sf.net/".equals(xPathException.getErrorCodeNamespace())) {
                        this.compileWarning(xPathException.getMessage(), xPathException.getErrorCodeLocalPart());
                        continue;
                    }
                    this.compileError(xPathException);
                }
                continue;
            }
            string = this.getNamePool().getLocalName(n2);
            if (!string.equals("method") && !string.equals("cdata-section-elements")) continue;
            bl = true;
        }
        object3 = ((IntHashSet)object2).iterator();
        while (object3.hasNext()) {
            this.serializationAttributes.remove(object3.next());
        }
        object3 = new ResultDocument(properties, (Properties)object, this.href, this.formatExpression, this.getBaseURI(), this.validationAction, this.schemaType, this.serializationAttributes, bl ? namespaceResolver : null);
        Expression expression = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
        if (expression == null) {
            expression = new Literal(EmptySequence.getInstance());
        }
        ((ResultDocument)object3).setContent(expression);
        ExpressionTool.makeParentReferences((Expression)object3);
        return object3;
    }

    static {
        fans.add("method");
        fans.add("output-version");
        fans.add("byte-order-mark");
        fans.add("indent");
        fans.add("encoding");
        fans.add("media-type");
        fans.add("doctype-system");
        fans.add("doctype-public");
        fans.add("omit-xml-declaration");
        fans.add("standalone");
        fans.add("cdata-section-elements");
        fans.add("include-content-type");
        fans.add("escape-uri-attributes");
        fans.add("undeclare-prefixes");
        fans.add("normalization-form");
        fans.add("{http://saxon.sf.net/}next-in-chain");
        fans.add("{http://saxon.sf.net/}character-representation");
        fans.add("{http://saxon.sf.net/}indent-spaces");
        fans.add("{http://saxon.sf.net/}require-well-formed");
    }
}

