/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SemaphoreAcquireCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreAvailablePermitsCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreDrainPermitsCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreIncreasePermitsCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreInitCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreReducePermitsCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreReleaseCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreTryAcquireCodec;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.core.ISemaphore;
import java.util.concurrent.TimeUnit;

public class ClientSemaphoreProxy
extends PartitionSpecificClientProxy
implements ISemaphore {
    public ClientSemaphoreProxy(String serviceName, String objectId, ClientContext context) {
        super(serviceName, objectId, context);
    }

    @Override
    public boolean init(int permits) {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreInitCodec.encodeRequest(this.name, permits);
        ClientMessage response = this.invokeOnPartition(request);
        SemaphoreInitCodec.ResponseParameters resultParameters = SemaphoreInitCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public void acquire() throws InterruptedException {
        ClientMessage request = SemaphoreAcquireCodec.encodeRequest(this.name, 1);
        this.invokeOnPartition(request);
    }

    @Override
    public void acquire(int permits) throws InterruptedException {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreAcquireCodec.encodeRequest(this.name, permits);
        this.invokeOnPartition(request);
    }

    @Override
    public int availablePermits() {
        ClientMessage request = SemaphoreAvailablePermitsCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        SemaphoreAvailablePermitsCodec.ResponseParameters resultParameters = SemaphoreAvailablePermitsCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public int drainPermits() {
        ClientMessage request = SemaphoreDrainPermitsCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        SemaphoreDrainPermitsCodec.ResponseParameters resultParameters = SemaphoreDrainPermitsCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public void reducePermits(int reduction) {
        this.checkNegative(reduction);
        ClientMessage request = SemaphoreReducePermitsCodec.encodeRequest(this.name, reduction);
        this.invokeOnPartition(request);
    }

    @Override
    public void increasePermits(int increase) {
        this.checkNegative(increase);
        ClientMessage request = SemaphoreIncreasePermitsCodec.encodeRequest(this.name, increase);
        this.invokeOnPartition(request);
    }

    @Override
    public void release() {
        ClientMessage request = SemaphoreReleaseCodec.encodeRequest(this.name, 1);
        this.invokeOnPartition(request);
    }

    @Override
    public void release(int permits) {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreReleaseCodec.encodeRequest(this.name, permits);
        this.invokeOnPartition(request);
    }

    @Override
    public boolean tryAcquire() {
        ClientMessage request = SemaphoreTryAcquireCodec.encodeRequest(this.name, 1, 0L);
        ClientMessage response = this.invokeOnPartition(request);
        SemaphoreTryAcquireCodec.ResponseParameters resultParameters = SemaphoreTryAcquireCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean tryAcquire(int permits) {
        this.checkNegative(permits);
        try {
            return this.tryAcquire(permits, 0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout == 0L) {
            return this.tryAcquire();
        }
        ClientMessage request = SemaphoreTryAcquireCodec.encodeRequest(this.name, 1, unit.toMillis(timeout));
        ClientMessage response = this.invokeOnPartition(request);
        SemaphoreTryAcquireCodec.ResponseParameters resultParameters = SemaphoreTryAcquireCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreTryAcquireCodec.encodeRequest(this.name, permits, unit.toMillis(timeout));
        ClientMessage response = this.invokeOnPartition(request);
        SemaphoreTryAcquireCodec.ResponseParameters resultParameters = SemaphoreTryAcquireCodec.decodeResponse(response);
        return resultParameters.response;
    }

    private void checkNegative(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits cannot be negative!");
        }
    }

    public String toString() {
        return "ISemaphore{name='" + this.name + '\'' + '}';
    }
}

