/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.conditions;

import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionEvaluator;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionEvaluatorDispatcher;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.unit.DistanceUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoLocationByPointSessionConditionEvaluator
implements ConditionEvaluator {
    private static final Logger logger = LoggerFactory.getLogger((String)GeoLocationByPointSessionConditionEvaluator.class.getName());

    public boolean eval(Condition condition, Item item, Map<String, Object> context, ConditionEvaluatorDispatcher dispatcher) {
        block5: {
            try {
                String type = (String)condition.getParameter("type");
                String name = condition.getParameter("name") == null ? "properties.location" : (String)condition.getParameter("name");
                Double latitudeProperty = Double.parseDouble(BeanUtils.getProperty((Object)item, (String)(name + ".lat")));
                Double longitudeProperty = Double.parseDouble(BeanUtils.getProperty((Object)item, (String)(name + ".lon")));
                if ("circle".equals(type)) {
                    Double circleLatitude = (Double)condition.getParameter("circleLatitude");
                    Double circleLongitude = (Double)condition.getParameter("circleLongitude");
                    DistanceUnit.Distance distance = DistanceUnit.Distance.parseDistance((String)condition.getParameter("distance").toString());
                    double d = GeoDistance.PLANE.calculate(circleLatitude.doubleValue(), circleLongitude.doubleValue(), latitudeProperty.doubleValue(), longitudeProperty.doubleValue(), distance.unit);
                    return d < distance.value;
                }
                if ("rectangle".equals(type)) {
                    Double rectLatitudeNE = (Double)condition.getParameter("rectLatitudeNE");
                    Double rectLongitudeNE = (Double)condition.getParameter("rectLongitudeNE");
                    Double rectLatitudeSW = (Double)condition.getParameter("rectLatitudeSW");
                    Double rectLongitudeSW = (Double)condition.getParameter("rectLongitudeSW");
                    if (rectLatitudeNE != null && rectLongitudeNE != null && rectLatitudeSW != null && rectLongitudeSW != null) {
                        return latitudeProperty < Math.max(rectLatitudeNE, rectLatitudeSW) && latitudeProperty > Math.min(rectLatitudeNE, rectLatitudeSW) && longitudeProperty < Math.max(rectLongitudeNE, rectLongitudeSW) && longitudeProperty > Math.min(rectLongitudeNE, rectLongitudeSW);
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Cannot evaluate condition, properties 'properties.location.lat' or 'properties.location.lon' not found, enable debug log level to see full stacktrace");
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("Cannot evaluate condition", (Throwable)e);
            }
        }
        return false;
    }
}

